%module Xerces
%{
#include "stdio.h"
#include "string.h"
#include "sax/InputSource.hpp"
#include "sax/SAXException.hpp"
#include "sax/SAXParseException.hpp"
#include "sax/Locator.hpp"
#include "sax/HandlerBase.hpp"
#include "sax2/Attributes.hpp"
#include "sax2/ContentHandler.hpp"
#include "sax2/LexicalHandler.hpp"
#include "sax2/DefaultHandler.hpp"
#include "sax2/SAX2XMLReader.hpp"
#include "sax2/XMLReaderFactory.hpp"
#include "util/PlatformUtils.hpp"
#include "util/TransService.hpp"
#include "util/XMLString.hpp"
#include "util/XMLUri.hpp"
#include "util/QName.hpp"
#include "util/HexBin.hpp"
#include "util/Base64.hpp"
#include "parsers/DOMParser.hpp"
#include "parsers/IDOMParser.hpp"
#include "parsers/SAXParser.hpp"
#include "idom/IDOM.hpp"
#include "dom/DOM.hpp"
#include "dom/DOM_DOMException.hpp"
#include "dom/DOM_RangeException.hpp"
#include "framework/LocalFileInputSource.hpp"
#include "framework/MemBufInputSource.hpp"
#include "framework/StdInInputSource.hpp"
#include "framework/URLInputSource.hpp"
#include "framework/XMLValidator.hpp"
#include "PerlErrorCallbackHandler.hpp"
#include "PerlEntityResolverHandler.i"
#include "PerlDocumentCallbackHandler.hpp"
#include "PerlContentCallbackHandler.hpp"


// we initialize the static UTF-8 transcoding info
// these are used by the typemaps to convert between
// Xerces internal UTF-16 and Perl's internal UTF-8
static XMLCh* UTF8_ENCODING = NULL; 
static XMLTranscoder* UTF8_TRANSCODER  = NULL;

static XMLCh* ISO_8859_1_ENCODING = NULL; 
static XMLTranscoder* ISO_8859_1_TRANSCODER  = NULL;

static bool DEBUG_UTF8_OUT = 0;
static bool DEBUG_UTF8_IN = 0;
%}

bool DEBUG_UTF8_OUT;
bool DEBUG_UTF8_IN;

/**************/
/*            */
/*  TYPEMAPS  */
/*            */
/**************/

%include typemaps.i

/*******************/
/*                 */
/*  INCLUDE FILES  */
/*                 */
/*******************/

%pragma nodefault

// We have to define these in order to get past the occurrence of the
// macro in class declaration line
#define SAX_EXPORT
#define PLATFORM_EXPORT
#define PLATFORM_IMPORT
#define PARSERS_EXPORT
#define CDOM_EXPORT
#define SAX2_EXPORT
#define XMLUTIL_EXPORT
#define PARSERS_EXPORT
#define XMLPARSER_EXPORT
#define VALIDATORS_EXPORT

/*
 * The generic exception handler
 */
%except(perl5) {
    try {
        $function
    } 
    catch (const XMLException& e)
        {
	    char *class_name = "XML::Xerces::XMLException";
	    HV *hash = newHV();
	    HV *stash = gv_stashpv(class_name, FALSE);
	    SV *tmpsv;
	    hv_magic(hash, 
		     (GV *)sv_setref_pv(sv_newmortal(), 
					class_name, (void *)&e), 
		     'P');
	    tmpsv = sv_bless(newRV_noinc((SV *)hash), stash);
	    SV *error = ERRSV;
	    SvSetSV(error,tmpsv);
	    (void)SvUPGRADE(error, SVt_PV);
	    Perl_die(Nullch);
        }
    catch (...)
        {
            XMLPlatformUtils::Terminate();
            croak("%s", "Handling Unknown exception");
        }
}

// we remove this macro for PlatformUtils and XMLURL
#define MakeXMLException(theType, expKeyword)

/* 
 * NEEDED FOR INITIALIZATION AND TERMINATION 
 */
%rename(operator_assignment) operator=;
%rename(operator_equal_to) operator==;
%rename(operator_not_equal_to) operator!=;

// both of these static variables cause trouble
// the transcoding service is only useful to C++ anyway.
%ignore XMLPlatformUtils::fgTransService;
%ignore XMLPlatformUtils::fgNetAccessor;

%ignore openFile(const XMLCh* const);
%include "Xerces_headers/util/PlatformUtils.hpp"

/*
 * Utility Classes
 */
%rename(XMLURL__constructor__base) XMLURL::XMLURL(const   XMLCh* const, const XMLCh* const);
%rename(XMLURL__constructor__text) XMLURL::XMLURL(const XMLCh* const);
%rename(XMLURL__constructor__copy) XMLURL::XMLURL(const XMLURL&);
%rename(XMLURL__constructor__url_base) XMLURL::XMLURL(const XMLURL&,const XMLCh* const);
%rename(makeRelativeTo__overload__XMLURL) XMLURL::makeRelativeTo(const XMLURL&);
%rename(setURL__overload__string) XMLURL::setURL(const XMLCh* const,const XMLCh* const);
%rename(setURL__overload__XMLURL) XMLURL::setURL(const XMLURL&,const XMLCh* const);
%ignore XMLURL::XMLURL(const XMLURL&,const char* const);
%ignore XMLURL::XMLURL(const char* const);
%ignore XMLURL::XMLURL(const XMLCh* const, const char* const);
%include "util/XMLURL.hpp"

%rename(XMLUri__constructor__uri) XMLUri::XMLUri(const XMLCh* const);
%include "Xerces_headers/util/XMLUri.hpp"
%ignore getPrefix() const;
%ignore getLocalPart() const;
%ignore getURI() const;
%ignore getRawName() const;
%include "util/QName.hpp"

// although not really necessary for Perl, why not?
%include "util/HexBin.hpp"
%include "util/Base64.hpp"

// do we need these Unicode string constants?
// %include "util/XMLUni.hpp"

// does anyone want to use this class for formatting Unicode?
// %include "framework/XMLFormatter.hpp"


// Perl has no need for these methods
// %include "util/XMLStringTokenizer.hpp"

// this macro will get redefined and swig 1.3.8 thinks that's an error
#undef MakeXMLException
%include "util/XMLExceptMsgs.hpp"
%include "util/XMLException.hpp"

// in case someone wants to re-use validators
%include "framework/XMLValidator.hpp"

// I will wait until someone asks for these scanner classes
// %include "framework/XMLAttDef.hpp"
// %include "framework/XMLAttDefList.hpp"
// %include "framework/XMLAttr.hpp"
// %include "framework/XMLContentModel.hpp"
// %include "framework/XMLElementDecl.hpp"
// %include "framework/XMLEntityDecl.hpp"
// %include "framework/XMLNotationDecl.hpp"
// %include "framework/XMLEntityHandler.hpp"
// %include "framework/XMLErrorCodes.hpp"
// %include "framework/XMLValidityCodes.hpp"
// %include "framework/XMLDocumentHandler.hpp"

/* 
 * FOR SAX 1.0 API 
 */
%include "sax/SAXException.hpp"
%include "sax/SAXParseException.hpp"
%include "sax/ErrorHandler.hpp"
%include "sax/DTDHandler.hpp"
%include "sax/DocumentHandler.hpp"
%include "sax/EntityResolver.hpp"
%rename(getType__overload__index) AttributeList::getType(const unsigned int);
%ignore AttributeList::getValue(const XMLCh* const);
%rename(getValue__overload__index) AttributeList::getValue(const unsigned int);
%include "sax/AttributeList.hpp"
%include "sax/HandlerBase.hpp"
%include "sax/Locator.hpp"

/* 
 * FOR SAX 2.0 API 
 */
%rename(getType__overload__qname) Attributes::getType(const XMLCh* const);
%rename(getType__overload__index) Attributes::getType(const unsigned int);
%rename(getValue__overload__qname) Attributes::getValue(const XMLCh* const);
%rename(getValue__overload__index) Attributes::getValue(const unsigned int);
%rename(getIndex__overload__qname) Attributes::getIndex(const XMLCh* const);
%include "sax2/Attributes.hpp"
%include "sax2/ContentHandler.hpp"
%include "sax2/LexicalHandler.hpp"
%include "sax2/DefaultHandler.hpp"
// the overloaded factory method is useless for perl
%ignore createXMLReader(const XMLCh*);
%include "sax2/XMLReaderFactory.hpp"

/* 
 * FOR ERROR HANDLING and other callbacks  
 */
%include "PerlErrorCallbackHandler.swig.hpp"
%include "PerlDocumentCallbackHandler.swig.hpp"
%include "PerlContentCallbackHandler.swig.hpp"
%include "PerlEntityResolverHandler.swig.hpp" 

/* 
 * THE NEW DOM IMPLEMENATION 
 */

// the IDOM classes gets a special exception handler
%except(perl5) {
    try {
        $function
    } 
    catch (const XMLException& e)
        {
	    char *class_name = "XML::Xerces::XMLException";
	    HV *hash = newHV();
	    HV *stash = gv_stashpv(class_name, FALSE);
	    SV *tmpsv;
	    hv_magic(hash, 
		     (GV *)sv_setref_pv(sv_newmortal(), 
					class_name, (void *)&e), 
		     'P');
	    tmpsv = sv_bless(newRV_noinc((SV *)hash), stash);
	    SV *error = ERRSV;
	    SvSetSV(error,tmpsv);
	    (void)SvUPGRADE(error, SVt_PV);
	    Perl_die(Nullch);
        }
    catch (const IDOM_DOMException& e)
    {
	    char *class_name = "XML::Xerces::IDOM_DOMException";
	    HV *hash = newHV();
	    HV *stash = gv_stashpv(class_name, FALSE);
	    SV *tmpsv;
	    hv_magic(hash, 
		     (GV *)sv_setref_pv(sv_newmortal(), 
					class_name, (void *)&e), 
		     'P');
	    tmpsv = sv_bless(newRV_noinc((SV *)hash), stash);
	    SV *error = ERRSV;
	    SvSetSV(error,tmpsv);
	    (void)SvUPGRADE(error, SVt_PV);
	    Perl_die(Nullch);
    }
    catch (...)
        {
            XMLPlatformUtils::Terminate();
            croak("%s", "Handling Unknown exception");
        }
}

%include "idom/IDOM_Node.hpp"
%include "idom/IDOM_Attr.hpp"
%include "idom/IDOM_CharacterData.hpp"
%include "idom/IDOM_Text.hpp"
%include "idom/IDOM_CDATASection.hpp"
%include "idom/IDOM_Comment.hpp"
%include "idom/IDOM_Document.hpp"
%include "idom/IDOM_DocumentFragment.hpp"
%include "idom/IDOM_DocumentType.hpp"
%include "idom/IDOM_DOMException.hpp"
%include "idom/IDOM_DOMImplementation.hpp"
%include "idom/IDOM_Element.hpp"
%include "idom/IDOM_Entity.hpp"
%include "idom/IDOM_EntityReference.hpp"
%include "idom/IDOM_NamedNodeMap.hpp"
%include "idom/IDOM_NodeFilter.hpp"
%include "idom/IDOM_NodeIterator.hpp"
%include "idom/IDOM_NodeList.hpp"
%include "idom/IDOM_Notation.hpp"
%include "idom/IDOM_ProcessingInstruction.hpp"
%include "idom/IDOM_Range.hpp"
%include "idom/IDOM_RangeException.hpp"
%include "idom/IDOM_TreeWalker.hpp"

/* 
 * The old DOM implementation
 */
// the DOM classes gets a special exception handler
%except(perl5) {
    try {
        $function
    } 
    catch (const XMLException& e)
        {
	    char *class_name = "XML::Xerces::XMLException";
	    HV *hash = newHV();
	    HV *stash = gv_stashpv(class_name, FALSE);
	    SV *tmpsv;
	    hv_magic(hash, 
		     (GV *)sv_setref_pv(sv_newmortal(), 
					class_name, (void *)&e), 
		     'P');
	    tmpsv = sv_bless(newRV_noinc((SV *)hash), stash);
	    SV *error = ERRSV;
	    SvSetSV(error,tmpsv);
	    (void)SvUPGRADE(error, SVt_PV);
	    Perl_die(Nullch);
        }
    catch (const DOM_DOMException& e)
    {
	    char *class_name = "XML::Xerces::DOM_DOMException";
	    HV *hash = newHV();
	    HV *stash = gv_stashpv(class_name, FALSE);
	    SV *tmpsv;
	    hv_magic(hash, 
		     (GV *)sv_setref_pv(sv_newmortal(), 
					class_name, (void *)&e), 
		     'P');
	    tmpsv = sv_bless(newRV_noinc((SV *)hash), stash);
	    SV *error = ERRSV;
	    SvSetSV(error,tmpsv);
	    (void)SvUPGRADE(error, SVt_PV);
	    Perl_die(Nullch);
    }
    catch (...)
        {
            XMLPlatformUtils::Terminate();
            croak("%s", "Handling Unknown exception");
        }
}

// we ignore the nulling operator= and the != NULL operator
%ignore operator= (DOM_NullPtr *);
%ignore operator!= (DOM_NullPtr *);
// %rename(operator_assignment) operator= ;
// %rename(operator_equal_to) operator== ;
// %rename(operator_not_equal_to) operator!= ;

%include "dom/DOMString.hpp"
%include "dom/DOM_Node.hpp"
%rename(DOM_Attr__constructor__copy) DOM_Attr(const DOM_Attr&);
%include "dom/DOM_Attr.hpp"
%include "dom/DOM_CharacterData.hpp"
%include "dom/DOM_Text.hpp"
%include "dom/DOM_CDATASection.hpp"
%include "dom/DOM_Comment.hpp"
%include "dom/DOM_DOMException.hpp"
%include "dom/DOM_DOMImplementation.hpp"
%include "dom/DOM_Document.hpp"
%include "dom/DOM_DocumentFragment.hpp"
%include "dom/DOM_DocumentType.hpp"
%include "dom/DOM_Element.hpp"
%include "dom/DOM_Entity.hpp"
%include "dom/DOM_EntityReference.hpp"
%include "dom/DOM_NamedNodeMap.hpp"
%include "dom/DOM_NodeFilter.hpp"
%include "dom/DOM_NodeIterator.hpp"
%include "dom/DOM_NodeList.hpp"
%include "dom/DOM_Notation.hpp"
%include "dom/DOM_ProcessingInstruction.hpp"
%include "dom/DOM_Range.hpp"
%include "dom/DOM_RangeException.hpp"

// this method is broken -- it is declared in the header, but never defined
%ignore DOM_TreeWalker::getExpandEntityReferences();
%include "dom/DOM_TreeWalker.hpp"

%rename(DOM_XMLDecl__constructor__copy) DOM_XMLDecl(const DOM_XMLDecl&);
%include "dom/DOM_XMLDecl.hpp"

/* 
 * INPUT SOURCES 
 *
 */
// we return to our previously scheduled handler
%except(perl5) {
    try {
        $function
    } 
    catch (const XMLException& e)
        {
	    char *class_name = "XML::Xerces::XMLException";
	    HV *hash = newHV();
	    HV *stash = gv_stashpv(class_name, FALSE);
	    SV *tmpsv;
	    hv_magic(hash, 
		     (GV *)sv_setref_pv(sv_newmortal(), 
					class_name, (void *)&e), 
		     'P');
	    tmpsv = sv_bless(newRV_noinc((SV *)hash), stash);
	    SV *error = ERRSV;
	    SvSetSV(error,tmpsv);
	    (void)SvUPGRADE(error, SVt_PV);
	    Perl_die(Nullch);
        }
    catch (...)
        {
            XMLPlatformUtils::Terminate();
            croak("%s", "Handling Unknown exception");
        }
}
%include "sax/InputSource.hpp"

%ignore MemBufInputSource(const XMLByte* const, const unsigned int, const XMLCh* const,const bool);
%include "framework/MemBufInputSource.hpp"
%include "Xerces_headers/framework/StdInInputSource.hpp"

%rename(LocalFileInputSource__constructor__base) LocalFileInputSource(const XMLCh* const,const XMLCh* const);
%include "framework/LocalFileInputSource.hpp"

%rename(URLInputSource__constructor__pub) URLInputSource(const XMLCh* const,const char* const,const char* const);
%rename(URLInputSource__constructor__sys) URLInputSource(const XMLCh* const,const char* const);
%ignore URLInputSource(const XMLCh* const,const XMLCh* const, const XMLCh* const);
%ignore URLInputSource(const XMLCh* const,const XMLCh* const);
%include "framework/URLInputSource.hpp"

/* 
 * PARSERS (PRETTY IMPORTANT) 
 *
 */
// scan token helper class for progressive parsing
// has assignment operator and needs private header
%include "Xerces_headers/framework/XMLPScanToken.hpp"

// Overloaded methods
%rename(parse__overload__is) parse(const InputSource&, const bool);
%ignore parse(const XMLCh* const,const bool);
%rename(parseFirst__overload__is) parseFirst(const InputSource&, XMLPScanToken &, const bool);
%ignore parseFirst(const XMLCh *const ,XMLPScanToken &,const bool );

/*
 * methods not needed by the public Parser interfaces
 *
 *   this is probably because I'm not using AdvDocHandlers and things
 *   that want to control the parsing process, but until someone asks
 *   for them, I'm going to leave them out.
 */

// XMLEntityHandler interface
%ignore endInputSource;
%ignore expandSystemId;
%ignore resetEntities;
%ignore resolveEntity;
%ignore startInputSource;

// XMLDocumentHandler interface.
%ignore docCharacters;
%ignore docComment;
%ignore docPI;
%ignore endDocument;
%ignore endElement;
%ignore endEntityReference;
%ignore ignorableWhitespace;
%ignore resetDocument;
%ignore startDocument;
%ignore startElement;
%ignore startEntityReference;
%ignore XMLDecl;

// depricated methods - don't ask me to include these
%ignore getDoValidation;
%ignore setDoValidation;
%ignore attDef;
%ignore doctypeComment;
%ignore doctypeDecl;
%ignore doctypePI;
%ignore doctypeWhitespace;
%ignore elementDecl;
%ignore endAttList;
%ignore endIntSubset;
%ignore endExtSubset;
%ignore entityDecl;
%ignore resetDocType;
%ignore notationDecl;
%ignore startAttList;
%ignore startIntSubset;
%ignore startExtSubset;
%ignore TextDecl;

// %include "sax/Parser.hpp"
%include "sax2/SAX2XMLReader.hpp"
%include "parsers/SAXParser.hpp"
%include "parsers/DOMParser.hpp"
%include "parsers/IDOMParser.hpp"

/* %pragma(perl5) include="Xerces-extra.pm" */
%pragma(perl5) code="package XML::Xerces; 
$VERSION = q[1.5.2_0];";
