# Before `make install' is performed this script should be runnable
# with `make test'. After `make install' it should work as `perl
# DOM_NamedNodeMap.t'

######################### We start with some black magic to print on failure.

# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)

BEGIN { $| = 1; print "1..3\n"; }
END {print "not ok 1\n" unless $loaded;}
use Carp;
use XML::Xerces;

use lib 't';
use TestUtils qw(result $DOM);
use vars qw($i $loaded);
use strict;

$loaded = 1;
$i = 1;
result($loaded);

######################### End of black magic.

# Insert your test code below (better if it prints "ok 13"
# (correspondingly "not ok 13") depending on the success of chunk 13
# of the test code):

my $document = <<EOT;
<list>
  <element one='1' two='2' three='3'/>
</list>
EOT

$DOM->parse( new XML::Xerces::MemBufInputSource($document, 'list') );

my $doc = $DOM->getDocument();

# get the single <element> node
my ($element) = $doc->getElementsByTagName('element');
my %attrs = $element->getAttributes();
result(scalar keys %attrs == 3 &&
       $attrs{one} == 1 &&
       $attrs{two} == 2 &&
       $attrs{three} == 3);

# test that we can still get a DOM_NodeList object
my $dom_node_map = $element->getAttributes();
result(ref($dom_node_map) && 
       $dom_node_map->isa('XML::Xerces::DOM_NamedNodeMap'));

