# -*- ruby -*-
#
# Using an internal stack.
#

require 'xtemplate'
require 'xtemplate/xml'

doc = XTemplate::XMLDocument.new(<<EOF)
<?xml version="1.0"?>
<document>
<items>
  <item link="link1">item1</item>
  <item link="link2">item2</item>
  <item link="link3">item3</item>
</items>
<note>
This is a <b>comment</b>.
</note>
</document>
EOF

text = <<EOF
<?xml version="1.0" encoding="UTF-8"?>
<html>
<body id="document">
  <ul>
    <li id="items"><a id="item{rename(@link,@href)}" /></li>
  </ul>
  <blockquote><xt:copy-of id="note" xmlns:xt="#{XTemplate::BIND_URI}"/></blockquote>
</body>
</html>
EOF

t = XTemplate::XMLTemplate.new(text)
print(t.expand(doc))
