/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id: calccategory.h 301 2005-08-31 05:24:20Z aquamaniac $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifndef AQBANKING_KDE_CALCCATEGORY_H
#define AQBANKING_KDE_CALCCATEGORY_H


class KBanking;
class Transaction;
class QWidget;
class Category;


#include "checkduplicates.ui.h"
#include <aqbanking/value.h>
#include "refpointer.h"
#include "transaction.h"

#include <list>
#include <string>

class CalculateCategory : public CheckDuplicatesUI {
  Q_OBJECT
private:
  KBanking *_app;
  bool _aborted;
  Category *_category;
  AB_VALUE *_value;

  bool _isOfCategory(const char *s, Category *cat);

public:
  CalculateCategory(KBanking *kb,
                    Category *p=0,
                    AB_VALUE *value=0,
                    QWidget* parent=0,
                    const char* name=0,
                    WFlags fl=0);
  ~CalculateCategory();

  bool calculate();
  bool calculateAll();

  bool getTransactions(std::list<RefPointer<Transaction> > &l);

public slots:
  void slotAbortClicked();

};







#endif


