#ifndef INC__GIOVANNI_DICANIO__EXPRPARSER_INL_
#define INC__GIOVANNI_DICANIO__EXPRPARSER_INL_


//===============================================================
//
//		ExprParser		-- Written by Giovanni Dicanio
//
//		A C++ class to parse mathematical expressions.
//
//		(v. 0.3)
//
//
//		Copyright (c) by Giovanni Dicanio
//
//===============================================================



//---------------------------------------------------------------
// File:			exprparser.inl
// Description:		Inline methods implementation file.
// Author:			Giovanni Dicanio
// First date:		20th January 2000
// Last update:		1st February 2000
//---------------------------------------------------------------


inline const char * ExprParser::getExpression() const
{
	return m_expr;
}


inline bool ExprParser::errorOccurred() const
{
	if (m_error == OK)
		return false;
	else
		return true;
}


inline ExprParser::errorCode ExprParser::getErrorCode() const
{
	return m_error;
}


inline ExprParser::angleUnit ExprParser::getAngleMode() const
{
	return m_angleMode;	// get current angle unit
}


inline ExprParser & ExprParser::setAngleMode(angleUnit unit)
{
	m_angleMode = unit;	// update angle mode

	return *this;
}


inline void ExprParser::goAhead()
{
	// Go ahead only if there are no errors!
	if (m_error == OK)
		m_currChar++;		// go to next char
}


inline void ExprParser::freeVariables()
{
	m_freeVariableSlot = 0;
}


inline int ExprParser::getNumberOfVariables() const
{
	return m_freeVariableSlot;
}


inline ExprParser & ExprParser::deleteAllVariables()
{
	// Flush all variables.
	freeVariables();

	return *this;
}


#endif // INC__GIOVANNI_DICANIO__EXPRPARSER_INL_
