/***************************************************************************
                          rfilebase.cpp  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/


/****************************************************************************
** rfilebase.cpp 1998/08/28 A. Mustun RibbonSoft
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#include "rfilebase.h"

#include <qfile.h>
#include <qdatetime.h>

#include "rappwin.h"
#include "rlog.h"
#include "rstatuspanel.h"

// Constructor with name:
//
RFileBase::RFileBase(const QString& _name, bool _noEmptyLines)
{
  fPointer=0;
  fBuf=0;
  fBufP=0;
  fSize=0;
  dosFile=false;
  noEmptyLines=_noEmptyLines;
  if(_name) setName(_name);
}



// Destructor:
//
RFileBase::~RFileBase()
{

}



// Reset whole object
//   (base class too)
//
void 
RFileBase::reset()
{
  QFile::reset();
  
  delBuffer();
  fBufP=0;
  fSize=0;
  if(fPointer) {
    fclose(fPointer);
    fPointer=0;
  }
}



// Reset buffer pointer to the beginning of the buffer:
//
void 
RFileBase::resetBufP()
{
  fBufP=0;
}



// Set buffer pointer to the given index:
//
void 
RFileBase::setBufP(int _fBufP)
{
  if(_fBufP<(int)fSize) {
    fBufP = _fBufP;
  }
}


// delete buffer:
//
void 
RFileBase::delBuffer()
{
  if(fBuf) {
    delete[] fBuf;
    fBuf=0;
  }
}



// Remove any 13-characters in the buffer:
//
void
RFileBase::dos2unix()
{
    char *src = fBuf, *dst = fBuf;

    if (!fBuf)
        return;

    while (*src != '\0') {
        if (*src == '\r') {
            dosFile = true;
        } else {
            *dst++ = *src;
        }
        src++;
    }

    *dst = '\0';
}


// Get next line in the buffer:
//   and overread ALL seperators
//
// return:  -Null-string: end of buffer 
//          -String which is the next line in buffer
//
QString
RFileBase::getBufLine()
{
    char *ret;
    QString str;

    if (fBufP >= (int)fSize)
        return QString::null;
    
    ret = &fBuf[fBufP];
    
    // Skip empty lines
    if (*ret == '\0' && noEmptyLines) {
        while (++fBufP < (int)fSize && fBuf[fBufP] == '\0') ;
        if (fBufP >= (int)fSize)
            return QString::null;
        ret = &fBuf[fBufP];
    }
    
    // Move fBufP pointer to the next line
    while (fBufP < (int)fSize && fBuf[fBufP++] != '\0') ;
    
    str = QString::fromLocal8Bit(ret).stripWhiteSpace();

    if (str.isNull()) {
        return "";
    } else {
        return str;
    }
}




// Get next line in the buffer:
//   and overread ALL seperators
//
// return:  -Null-string: end of buffer 
//          -String which is the next line in buffer
//
char*
RFileBase::getBufLineCh()
{
    char *ret;

    if (fBufP >= (int)fSize)
        return 0;
    
    ret = &fBuf[fBufP];
    
    // Skip empty lines
    if (*ret == '\0' && noEmptyLines) {
        while (++fBufP < (int)fSize && fBuf[fBufP] == '\0') ;
        if (fBufP >= (int)fSize)
            return 0;
        ret = &fBuf[fBufP];
    }
    
    // Move fBufP pointer to the next line
    while (fBufP < (int)fSize && fBuf[fBufP++] != '\0') ;
    
    return ret;
}



// Copy buffer from a given string:
//
void    
RFileBase::copyBufFrom(const char* _buf)
{
  if(_buf) {
    fBuf = new char[strlen(_buf)+16];
    strcpy(fBuf, _buf);
  }
}



// Go to the next '_lstr'-line in buffer:
//
// return: true:  line found
//         false: end of buffer
//
bool 
RFileBase::gotoBufLine(char* _lstr)
{
  QString l;
  do {
    l=getBufLine();
  }while(!l.isNull() && l!=_lstr);
  
  if(!l.isNull()) return true;
  return false;
}



// Goto next line where the string _lstr appears:
//
// return: true:  string in line found
//         false: end of buffer
//         
//
bool 
RFileBase::gotoBufLineString(char* _lstr)
{
  QString l;
  do {
    l=getBufLine();
  }while(!l.isNull() && l.contains(_lstr));

  if(!l.isNull()) return true;
  return false;
}



// Replace bynary Bytes (<32) by an other (given) byte:
//
void
RFileBase::replaceBinaryBytesBy(char _c)
{
  int bc;

  for(bc=0; bc<(int)fSize; ++bc) {
    if(fBuf[bc]<32 && fBuf[bc]>=0) {
      fBuf[bc] = _c;
    }
  }
}



// Separate buffer (change chars sc1 and sc2 in '\0'
//
void
RFileBase::separateBuf(char _c1,
                       char _c2,
                       char _c3,
                       char _c4)
{
  int bc;

  for(bc=0; bc<(int)fSize; ++bc) {
    if(fBuf[bc]==_c1 || fBuf[bc]==_c2 ||
       fBuf[bc]==_c3 || fBuf[bc]==_c4    ) {
      fBuf[bc] = '\0';
    }
  }
}



// remove comment between '_fc' and '_lc'
//   comments get replaced by '\0'
//
void
RFileBase::removeComment(char _fc, char _lc)
{
  bool rem=false;   // Are we removing currrently?
  int bc;           // counter
  
  for(bc=0; bc<(int)fSize; ++bc) {
    if(fBuf[bc]==_fc) rem=true;
    if(fBuf[bc]==_lc) { fBuf[bc]='\0'; rem=false; }
    if(rem) fBuf[bc]='\0';
  }
}



// Read file '_name' in buffer (buf)
//
// '_bNum' : Max number of Bytes
//         : -1: All
// return: true: successful
//         false: file not found
//
bool 
RFileBase::readFileInBuffer(char* _name, int _bNum)
{
  setName(_name);
  return readFileInBuffer(_bNum);
}



// Read file in buffer (buf)
//
// 'bNum' : Max number of Bytes
//        : -1: All
// return: true: successful
//         false: file not found
//
bool 
RFileBase::readFileInBuffer(int _bNum)
{
  fPointer = fopen(name(), "rb");
  if(fPointer!=NULL) {
    if(open(IO_ReadOnly, fPointer)) {
      fSize=size();
      if(_bNum==-1) _bNum=fSize;
      
      fBuf = new char[_bNum+16];
      
      readBlock(fBuf, _bNum);
      fBuf[_bNum] = '\0';
      close();
    }
    fclose(fPointer);

    // Convert 13/10 to 10
    dos2unix();
    fPointer=NULL;

    return true;
  }
  return false;
}



// Save buffer (buf) to file '_name'
//
// return: true: successful
//         false: can not open file
//
bool 
RFileBase::saveBufferToFile(char* _name)
{
  setName(_name);
  return saveBufferToFile();
}



// Save buffer (buf) to file 
//
// return: true: successful
//         false: file not found
//
bool 
RFileBase::saveBufferToFile()
{
  fPointer = fopen(name(), "wb");
  if(fPointer!=NULL) {
    if(open(IO_WriteOnly, fPointer)) {
      fSize=strlen(fBuf);
      
      writeBlock(fBuf, fSize);
      close();
    }
    fclose(fPointer);
    fPointer=NULL;

    return true;
  }
  return false;
}




// Get status panel for current Doc:
//
RStatusPanel*
RFileBase::statusPanel()
{
  return RAppWin::getRAppWin()->getStatusPanel();
}



// EOF











