/***************************************************************************
                          rinfowidget.h  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/

/****************************************************************************
** rinfowidget.h 1998/09/23 A. Mustun RibbonSoft 
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#ifndef RINFOWIDGET_H
#define RINFOWIDGET_H

#include "rgraphic.h"
#include "rwidget.h"

class QLabel;

class RInfoWidget : public RWidget
{
  Q_OBJECT
public:
  RInfoWidget(QWidget* _parent=0, 
              const char* _name=0, 
              WFlags _f=0);
  ~RInfoWidget();

  void resizeChildren();

  void      setGraphic(RGraphic* _graphic);
  RGraphic* getGraphic() { return graphic; }

protected:
  virtual void resizeEvent(QResizeEvent* _ev);
  void updateInfo(bool _values);
    
public slots:
  virtual void show();
  void updateInfo() { updateInfo(true); }

private:
  bool      valid;        // is the info still valid?

  RGraphic* graphic;      // Pointer to graphic
  QLabel*   lPath;        // Label for path
  QLabel*   path;         // path
  QLabel*   lCreation;    // Label for creation date/time
  QLabel*   creation;     // creation date/time
  QLabel*   lSize;        // Label for size
  QLabel*   size;         // size
  QLabel*   lObjects;     // Label for number of Objects
  QLabel*   objects;      // objects
  QLabel*   lTotalWay;    // Label for total way
  QLabel*   totalWay;     // total way
  QLabel*   lCuttingWay;  // Label for cutting way
  QLabel*   cuttingWay;   // cutting way
  
};


#endif

// EOF


