/***************************************************************************
                          rlineedit.cpp  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/


/****************************************************************************
** rlineedit.cpp 1998/09/19 A. Mustun RibbonSoft
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <qlineedit.h>

#include "rlineedit.h"
#include "rmath.h"
#include "rstring.h"
#include "rconfig.h"


// Constructor:
//
RLineEdit::RLineEdit(QWidget* _parent, const char* _name)
:QLineEdit(_parent, _name)
{
  setFont( RCONFIG->getFont(0) );
}


// Destructor:
//
RLineEdit::~RLineEdit()
{
}


/*! Add some behaviour for special characters.
*/
void 
RLineEdit::keyPressEvent( QKeyEvent *e )
{
  if ( e->state() & ControlButton && e->state() & ShiftButton ) {
    switch ( e->key() ) {
      case Key_O:
        insert("");
        break;
			case Key_D:
			  insert("");
			  break;
			case Key_U:
			  insert("");
			  break;
			case Key_Plus:
			  insert("");
			  break;
			case Key_Colon:
			  insert("");
			  break;
			default:
	      QLineEdit::keyPressEvent( e );
			  break;
		}
	}
	else {
	  QLineEdit::keyPressEvent( e );
	}
}



// Set a double value:
//
void
RLineEdit::setFloat(double _value)
{
  QString str;
  str.setNum(_value, 'g', 6);
  setText(str);
  //setText(strFloatToString(_value));
}


// Set a integer value:
//
void
RLineEdit::setInteger(int _value)
{
  /*char strValue[128];
  sprintf(strValue, "%d", _value);
  setText(strValue);*/
  
  QString str;
  str.setNum(_value);
  setText(str);
}


// Get the contents of this box as a double value:
//
double
RLineEdit::getFloat()
{
  return mtCalculate( text() );
  
  /*
  ExprParser parser;
  parser.setExpression( text().latin1() );
  ret = parser.getValue();
  if( !parser.errorOccurred() ) {
    return ret;
  }
  else {
    return 0.0;
  }
  */
}


// Get the contents of this box as an int value:
//
int
RLineEdit::getInt()
{
  //return atoi(text());
  //return text().toInt();
  
  return mtRound( mtCalculate( text() ) );
  
  /*
  double ret;
  
  ExprParser parser;
  parser.setExpression( text().latin1() );
  ret = parser.getValue();
  if( !parser.errorOccurred() ) {
    return (int)ret;
  }
  else {
    return 0;
  }
  */
}

// EOF

