/***************************************************************************
                          rpreferencesdialog.h  -  description
                             -------------------
    begin                : Tue Nov 23 1999
    copyright            : (C) 1999 by Andrew Mustun
    email                : andrew@qcad.org
 ***************************************************************************/


#ifndef RPREFERENCESDIALOG_H
#define RPREFERENCESDIALOG_H

#include <qwidget.h>
#include <qtabdialog.h>

class QCheckBox;
class RComboBox;
class RLineEdit;
class RListView;
class QRadioButton;
class QLabel;
class QListViewItem;
class QWidget;
class QWidgetStack;

class RPreferencesDialog : public QDialog  {
  Q_OBJECT
public:
	RPreferencesDialog( QWidget * parent=0, bool _drawing=false, const char * name=0, bool modal=FALSE, WFlags f=0 );
	~RPreferencesDialog();
	
protected slots:
  void accept();
  void slotChangePage( QListViewItem* _item );
  void slotSystemChanged(const QString &);
  void slotGridFormatChanged(const QString &);
  void slotScaleTypeChanged(const QString &);
  void slotScaleChanged(const QString &);
  void slotPageFormatChanged(const QString &);
  void slotLanguageChanged(const QString &);
  void slotPortrait();
  void slotLandscape();

private:
  bool drawingOnly;

  RListView*    lvCategory;

  QWidgetStack* widgetStack;

  RComboBox *cbUnit;
  QLabel    *labelScale;

  RComboBox *cbLanguage;

  RComboBox *cbFontName;
  RComboBox *cbCharset;
  RComboBox *cbFontSize0;
  RComboBox *cbFontSize1;
  RComboBox *cbFontSize2;
  RComboBox *cbFontSize3;

  RComboBox *cbPreviewElements;
  RComboBox *cbSnapRange;
  RComboBox *cbMarkSize;
  QCheckBox *ckbAutoRedraw;

  RComboBox *cbDimUnit;
  RComboBox *cbDimFormat;
  RComboBox *cbDimExactness;
  QCheckBox *ckbDimShowUnits;
  //RComboBox *cbDimScale;
  RComboBox *cbAngDimUnit;
  RComboBox *cbAngDimFormat;
  RComboBox *cbAngDimExactness;
  RComboBox *cbDimTextHeight;
  RComboBox *cbDimOverLength;
  RComboBox *cbDimUnderLength;
  RComboBox *cbDimArrowSize;
  QLabel    *labelUnit1;
  QLabel    *labelUnit2;
  QLabel    *labelUnit3;
  QLabel    *labelUnit4;

  RComboBox *cbScaleType;
  RComboBox *cbPaperSpace;
  RComboBox *cbPageFormat;
  //RComboBox *cbPageOrientation;
  QRadioButton *rbPortrait;
  QRadioButton *rbLandscape;
  RLineEdit *lePageSizeX;
  RLineEdit *lePageSizeY;
  RLineEdit *lePageOriginX;
  RLineEdit *lePageOriginY;
  QCheckBox *ckbShowPageBorder;

  //RComboBox *cbGridUnit;
  RComboBox *cbGridFormat;
  RComboBox *cbMinGridX;
  RComboBox *cbMinGridY;
  QCheckBox *ckbMetaGrid;
  QCheckBox *ckbAutoScaleGrid;
  RComboBox *cbMinGridSpace;

  RComboBox *cbMachineGenerator;

  RComboBox *cbPrinterName;
  RComboBox *cbPrintProgram;
  
  RLineEdit *leBrowserPath;
  RLineEdit *leLibraryPath1;

  QString lastUnit;

};

#endif













