/***************************************************************************
                          astar.h  -  description
                             -------------------
    begin                : Die Jul 26 2005
    copyright            : (C) 2005 by Krippel Harald
    email                : neuro.harald@surfeu.at
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ASTAR_H
#define ASTAR_H


/**
  *@author Krippel Harald
  */

class aStar {
public: 
	aStar(unsigned tmpmapWidth, unsigned tmpmapHeight , unsigned tmptileSize, unsigned tmpnumberPeople );

 void ReadPath(int pathfinderID,int currentX,int currentY, int pixelsPerFrame);
 int FindPath(int pathfinderID,int startingX, int startingY, int targetX, int targetY);
 double ReadPathX(int pathfinderID,int pathLocation);
 double ReadPathY(int pathfinderID,int pathLocation);
 int ReadMap(const char *file);
 int ReadMapValue(int x ,int y);  
	~aStar();


private:

	//Declare constants
//	unsigned mapWidth , mapHeight, tileSize, numberPeople;
	int mapWidth , mapHeight, tileSize, numberPeople;
	int onClosedList;
	int notfinished, notStarted;// path-related constants
	int found, nonexistent;
	int walkable, unwalkable;// walkability array constants

	//Create needed arrays
	char **walkability ;
	char **map ;
	int  *openList; //1 dimensional array holding ID# of open list items
	int  **whichList;  //2 dimensional array used to record
  // 		whether a cell is on the open list or on the closed list.
	int *openX; //1d array stores the x location of an item on the open list
	int *openY; //1d array stores the y location of an item on the open list
	int **parentX; //2d array to store parent of each cell (x)
	int **parentY; //2d array to store parent of each cell (y)
	int *Fcost;	//1d array to store F cost of a cell on the open list
	int **Gcost; 	//2d array to store G cost for each cell.
	int *Hcost;	//1d array to store H cost of a cell on the open list
	int *pathLength;     //stores length of the found path for critter
	int *pathLocation;   //stores current position along the chosen path for critter
	int** pathBank;

	//Path reading variables
	int *pathStatus;
	int *xPath;
	int *yPath;
};
#endif
