/***************************************************************************
                          mainwindow.cpp  -  description
                             -------------------
    begin                : Fri JAN  12 16:54:22 CET 2007
    copyright            : (C) 2007 by Harald Krippel
    email                : harald@the-develop.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   this program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 **************pluginsDir*************************************************************/

#include <QtGui>
#include <QPluginLoader>

#include "mainwindow.hpp"
#include "opmltree.hpp"
#include "globdefines.h"
#include "messages.hpp"
#include "plugindialog.hpp"

#include <CDefault.hpp>
#include <CGlobalEdit.hpp>
#include <CLampEdit.hpp>
#include <CCameraEdit.hpp>
#include <CObjectEdit.hpp>
#include <CBarrierEdit.hpp>
#include <CBodyEdit.hpp>
#include <CPartsysEdit.hpp>
#include <CWavesysEdit.hpp>
#include <CFireEdit.hpp>
#include <CFogEdit.hpp>
#include <CPlayerEdit.hpp>
#include <CSkyEdit.hpp>
#include <CShaderEdit.hpp>
#include <CCursorEdit.hpp>
#include <CSplEdit.hpp>
#include <CSoundEdit.hpp>
#include <CGuitxtEdit.hpp>
#include <CGuiinputEdit.hpp>
#include <CGuibuttonEdit.hpp>
#include <CGuiosbuttonEdit.hpp>
#include <CNetworkEdit.hpp>
#include <CSceneEdit.hpp>
#include <CProjectEdit.hpp>
#include <CPrefEdit.hpp>

MainWindow::MainWindow()
{
    tmpItem = NULL;
    g_gl= gl = new Glcontrol( this );
    setCentralWidget(gl);
    gl->show();

    createActions();
    createMenus();
    createToolBars();
    createStatusBar();
    createDockWindows();

    readSettings();
    setWindowTitle(tr(QCAKEVERSION));
    
    toolsEditGroup = new  QActionGroup(this);
    toolsPlayGroup = new  QActionGroup(this);

    fileSaveAct->setEnabled(false);
    viewFullScreenAct->setEnabled(false);

    toolsEditCamAct->setEnabled(false);
    toolsEditCamAct->setCheckable(true);
    toolsEditGroup->addAction(toolsEditCamAct);

    toolsTranslateAct->setEnabled(false);
    toolsTranslateAct->setCheckable(true);
    toolsEditGroup->addAction(toolsTranslateAct);

    toolsRotateAct->setEnabled(false);
    toolsRotateAct->setCheckable(true);
    toolsEditGroup->addAction(toolsRotateAct);

    toolsScaleAct->setEnabled(false);
    toolsScaleAct->setCheckable(true);
    toolsEditGroup->addAction(toolsScaleAct);

    toolsPlayAct->setEnabled(false);
    toolsPlayAct->setCheckable(true);
    toolsPlayGroup->addAction(toolsPlayAct);

    toolsStopAct->setEnabled(false);
    toolsStopAct->setCheckable(true);
    toolsPlayGroup->addAction(toolsStopAct);

    toolsPauseAct->setEnabled(false);
    toolsPauseAct->setCheckable(true);
    toolsPlayGroup->addAction(toolsPauseAct);

    modified=false;
}
void MainWindow::closeEvent(QCloseEvent *event)
{
    if (maybeSave()) {
        writeSettings();
        event->accept();
    }else{
        event->ignore();
    }
}

void MainWindow::print()
{
//    QTextDocument *document = textEdit->document();
    QPrinter printer;

    QPrintDialog *dlg = new QPrintDialog(&printer, this);
    if (dlg->exec() != QDialog::Accepted)
        return;

//    document->print(&printer);
    statusBar()->showMessage(tr("Ready"), 2000);
}

void MainWindow::preferences()
{
    CPrefEditDlg *dlg = new CPrefEditDlg(tr("Preferences"),this,g_editor);
    if (dlg->exec() == QDialog::Accepted){
        g_editor = dlg->geteditpath();
        return;
    }

    statusBar()->showMessage(tr("Ready"), 2000);
}

void MainWindow::readSettings()
{
    QSettings settings("QCake", "QCDesigner");
    QPoint pos = settings.value("mainwindow/pos", QPoint(200, 200)).toPoint();
    QSize size = settings.value("mainwindow/size", QSize(400, 400)).toSize();
    g_3dcatalogpath = settings.value("mainwindow/catalog", QString(QDir::homePath () + "/cat3d/")).toString();
    g_scriptcatalogpath = settings.value("mainwindow/scriptcatalogpath", QString(QDir::homePath () + "/splcat/")).toString();
    g_soundcatalogpath = settings.value("mainwindow/soundcatalogpath", QString(QDir::homePath () + "/soundcat/")).toString();
    g_shadercatalogpath = settings.value("mainwindow/shadercatalogpath", QString(QDir::homePath () + "/shadercat/")).toString();
    g_physikcatalogpath = settings.value("mainwindow/physikcatalogpath", QString(QDir::homePath () + "/physikcat/")).toString();
    g_prjpath = settings.value("mainwindow/openpath", QString(QDir::homePath () )).toString();
#ifdef    Q_OS_IRIX
    g_editor = settings.value("mainwindow/editor", "jot").toString();
#endif
#ifdef    Q_OS_LINUX
    g_editor = settings.value("mainwindow/editor", "kwrite").toString();
#endif
#ifdef    Q_OS_MACX
    g_editor = settings.value("mainwindow/editor", "/Applications/TextEdit.app/Contents/MacOS/TextEdit").toString();
#endif
#ifdef    Q_OS_WIN32
    g_editor = settings.value("mainwindow/editor", "notepad").toString();
#endif
    resize(size);
    move(pos);
}

void MainWindow::writeSettings()
{
    QSettings settings("QCake", "QCDesigner");
    settings.setValue("mainwindow/pos", pos());
    settings.setValue("mainwindow/size", size());
    settings.setValue("mainwindow/catalog", g_3dcatalogpath);
    settings.setValue("mainwindow/scriptcatalogpath", g_scriptcatalogpath);
    settings.setValue("mainwindow/soundcatalogpath", g_soundcatalogpath);
    settings.setValue("mainwindow/shadercatalogpath", g_shadercatalogpath);
    settings.setValue("mainwindow/physikcatalogpath", g_physikcatalogpath);
    settings.setValue("mainwindow/openpath", g_prjpath);
    settings.setValue("mainwindow/editor", g_editor);
}

bool MainWindow::maybeSave()
{
    if (modified) {
        QMessageBox::StandardButton ret;
        ret = QMessageBox::warning(this, tr("Application"),
                     tr("The document has been modified.\n"
                        "Do you want to save your changes?"),
                     QMessageBox::Save | QMessageBox::Discard | QMessageBox::Cancel);
        if (ret == QMessageBox::Save){
            modified = false;
            return save();
        }else{ 
            if (ret == QMessageBox::Cancel)
               return false;
        }
    }
    return true;
}

bool MainWindow::save()
{
    QString fileName = doc_url;
    if (fileName.isEmpty())
        return false;

    QFile file(fileName);
    if (!file.open(QFile::WriteOnly | QFile::Text)) {
        QMessageBox::warning(this, tr("SAX QCake"),
                             tr("Cannot write file %1:\n%2.")
                             .arg(fileName)
                             .arg(file.errorString()));
        return false;
    }

    if (opmlTree->write(&file)){
        statusBar()->showMessage(tr("File saved"), 2000);
    }
    modified= false;
    return true;
}

void MainWindow::open()
{
    maybeSave();

    QString fileName =
            QFileDialog::getOpenFileName(this, tr("Open QCake File"),
                                         g_prjpath,
                                         tr("OPML Files (*.opml *.xml)"));

    qWarning( fileName.toAscii() );
    loadFile(fileName);
}

void MainWindow::loadFile(QString fileName)
{
    modified=false;
    // Load File
    if (fileName.isEmpty())
        return;

    QFile file(fileName);
    if (!file.open(QFile::ReadOnly | QFile::Text)) {

        QMessageBox::warning(this, tr("QCake File"),
                             tr("Cannot read file %1:\n%2.")
                             .arg(fileName)
                             .arg(file.errorString()));
        return;
    }
    // Delete old Date
    if(g_gl != NULL){
       if ( g_gl->scene != NULL ){
         slotToolsStop();
         g_gl->StopSound();
         g_gl->DeleteScene ();
       }
    }
    g_nextid=0;
    fileSaveAct->setEnabled(true);
    toolsEditCamAct->setEnabled(true);
    toolsTranslateAct->setEnabled(true);
    toolsRotateAct->setEnabled(true);
    toolsScaleAct->setEnabled(true);
    toolsPlayAct->setEnabled(true);
    toolsStopAct->setEnabled(true);
    toolsPauseAct->setEnabled(true);

    setCurrentFile(fileName);
    doc_url=fileName;
    g_prjpath =  QFileInfo(file).filePath();
    g_prjpath = g_prjpath.left(g_prjpath.lastIndexOf(QFileInfo(file).fileName()));
    qWarning( g_prjpath.toAscii() );

    if (opmlTree->read(&file)){
        statusBar()->showMessage(tr("File loaded"), 2000);
        g_tmpItem=opmlTree->getStart();
        if (g_tmpItem != NULL && g_gl != NULL){    // only it exist !!
          g_gl->switchScene(g_tmpItem);
        }
    }
}

bool MainWindow::newProject()
{
  QString copy;

  maybeSave();
  modified=false;

  CProjectEditDlg  *project = new  CProjectEditDlg(this);

  if ( project->exec() == QDialog::Accepted ){
         QString   result = project->getfile();
         QString   workingDirectory = project->getpath();
         qWarning( result.toAscii() );
         qWarning( workingDirectory.toAscii() );
         QDir *dir =new QDir();
         dir->mkdir(workingDirectory);
         g_prjpath =  workingDirectory + "/";

         // copy the data folder
#ifdef    Q_OS_LINUX
         QString   copy = "cp -dpR \""+ g_apppath +"/data\" " +  g_prjpath ;
         qWarning( copy.toAscii() );   // debug
         system (copy.toAscii());
#endif
#ifdef    Q_OS_IRIX
         QString   copy = "cp -DpR data " +  g_prjpath ;
         qWarning( copy.toAscii() );   // debug
         system (copy.toAscii());
#endif
#ifdef    Q_OS_MACX
         QString   copy = "cp -pR data " +  g_prjpath ;
         qWarning( copy.toAscii() );
         system (copy.toAscii());
#endif
#ifdef    Q_OS_WIN32
         QString   copy = "xcopy \""+ g_apppath +"/data\" \"" +  g_prjpath + "data\" /e /i" ;
         qWarning( copy.toAscii() );
         system (copy.toAscii());
#endif
         copy = "cp new.xml " +  g_prjpath + result + ".xml";  // debug
         qWarning( copy.toAscii() );                           // debug

         QFile srcFile(g_apppath+"/new.xml");
         srcFile.copy(g_prjpath + result + ".xml");
         QString  myurl = g_prjpath + result + ".xml";
         loadFile(myurl);
         doc_url = g_prjpath + result + ".xml" ;
  }else{
    return false;
  }
  return true;
}

void MainWindow::undo()
{

}

void MainWindow::cut()
{
  
}

void MainWindow::about()
{
  QPixmap  abouticon;

  abouticon = QPixmap(":/images/qcake.png");
 /*
  QMessageBox::about(this,tr("About..."),
                     tr("QCake\n Version " QCAKEVERSION
                     "\n(c) 2004-2007 by"
                     "\n    Krippel Harald"
                     "\n    Roland Schwartz"
                     "\n    Clifford Wolf"
                     "\n    Harald Leibrecht"
                     "\n    David Kuderer"
                     "\n    Macus Anderle"));
 */
  QMessageBox mb( this);
  mb.setIconPixmap(abouticon);
  mb.setWindowTitle(tr(QCAKEVERSION));
  mb.exec();
}

void MainWindow::aboutPlugins()
{
    PluginDialog dialog(pluginsDir.path(), pluginFileNames, this);
    dialog.exec();
}

void MainWindow::createActions()
{
    fileNewAct = new QAction(QIcon(":/images/filenew.png"), tr("&New"), this);
    fileNewAct->setShortcut(tr("Ctrl+N"));
    fileNewAct->setStatusTip(tr("Create a new project"));
    connect(fileNewAct, SIGNAL(triggered()), this, SLOT(newProject()));

    fileOpenAct = new QAction(QIcon(":/images/fileopen.png"), tr("&Open ..."), this);
    fileOpenAct->setShortcut(tr("Ctrl+O"));
    fileOpenAct->setStatusTip(tr("Open a project"));
    connect(fileOpenAct, SIGNAL(triggered()), this, SLOT(open()));

    fileSaveAct = new QAction(QIcon(":/images/filesave.png"), tr("&Save"), this);
    fileSaveAct->setShortcut(tr("Ctrl+S"));
    fileSaveAct->setStatusTip(tr("Save the current project"));
    connect(fileSaveAct, SIGNAL(triggered()), this, SLOT(save()));

    filePrintAct = new QAction(QIcon(":/images/print.png"), tr("&Print ..."), this);
    filePrintAct->setShortcut(tr("Ctrl+P"));
    filePrintAct->setStatusTip(tr("Print the current ??"));
    connect(filePrintAct, SIGNAL(triggered()), this, SLOT(print()));

//    filePrefAct = new QAction(QIcon(":/images/print.png"), tr("&Preferences ..."), this);
    filePrefAct = new QAction(tr("&Preferences ..."), this);
    filePrefAct->setShortcut(tr("Ctrl+F"));
    filePrefAct->setStatusTip(tr("Preferences"));
    connect(filePrefAct, SIGNAL(triggered()), this, SLOT(preferences()));

    editUndoAct = new QAction(QIcon(":/images/undo.png"), tr("&Undo"), this);
    editUndoAct->setShortcut(tr("Ctrl+Z"));
    editUndoAct->setStatusTip(tr("Undo the last editing action"));
    connect(editUndoAct, SIGNAL(triggered()), this, SLOT(undo()));

    editCutAct = new QAction(tr("&Cut"), this);
    editCutAct->setShortcut(tr("Ctrl+C"));
    editCutAct->setStatusTip(tr("Cut the selected item"));
    connect(editCutAct, SIGNAL(triggered()), this, SLOT(cut()));

    fileQuitAct = new QAction(tr("&Quit"), this);
    fileQuitAct->setShortcut(tr("Ctrl+Q"));
    fileQuitAct->setStatusTip(tr("Quit the application"));
    connect(fileQuitAct, SIGNAL(triggered()), this, SLOT(close()));

    viewFullScreenAct = new QAction(tr("&FullScreen"), this);
    viewFullScreenAct->setShortcut(tr("Ctrl+F"));
    viewFullScreenAct->setStatusTip(tr("full screen view"));
    connect(viewFullScreenAct, SIGNAL(triggered()), this, SLOT(slotFullScreen()));

    viewFrontScreenAct = new QAction(tr("&FrontView"), this);
    viewFrontScreenAct->setShortcut(tr("Ctrl+2"));
    viewFrontScreenAct->setStatusTip(tr("fornt view"));
    connect(viewFrontScreenAct, SIGNAL(triggered()), this, SLOT(slotFrontView()));

    toolsEditCamAct = new QAction(QIcon(":/images/wizard.png"),tr("&EditCam"), this);
    toolsEditCamAct->setShortcut(tr("Ctrl+K"));
    toolsEditCamAct->setStatusTip(tr("EditorCamera"));
    toolsEditCamAct->setWhatsThis(tr("Editor Camera\n\nmove around"));
    connect(toolsEditCamAct, SIGNAL(triggered()), this, SLOT(slotToolsEditCam()));

    toolsTranslateAct = new QAction(QIcon(":/images/move.png"),tr("&Translate"), this);
    toolsTranslateAct->setShortcut(tr("Ctrl+T"));
    toolsTranslateAct->setStatusTip(tr("Translate"));
    toolsTranslateAct->setWhatsThis(tr("Translate\n\nTranslate Object"));
    connect(toolsTranslateAct, SIGNAL(triggered()), this, SLOT(slotToolsTranslate()));

    toolsRotateAct = new QAction(QIcon(":/images/rotate.png"), tr("&Rotate"), this);
    toolsRotateAct->setShortcut(tr("Ctrl+R"));
    toolsRotateAct->setStatusTip(tr("Rotate"));
    toolsRotateAct->setWhatsThis(tr("Rotate\n\nRotate Object"));
    connect(toolsRotateAct, SIGNAL(triggered()), this, SLOT(slotToolsRotate()));

    toolsScaleAct = new QAction(QIcon(":/images/crop.png"), tr("&Scale"), this);
    toolsScaleAct->setShortcut(tr("Ctrl+A"));
    toolsScaleAct->setStatusTip(tr("Scale"));
    toolsScaleAct->setWhatsThis(tr("Scale\n\nScale Object"));
    connect(toolsScaleAct, SIGNAL(triggered()), this, SLOT(slotToolsScale()));

    toolsPlayAct = new QAction(QIcon(":/images/run.png"), tr("&Play"), this);
    toolsPlayAct->setShortcut(tr("Ctrl+P"));
    toolsPlayAct->setStatusTip(tr("Play"));
    toolsPlayAct->setWhatsThis(tr("Play\n\nswitch to Play mode"));
    connect(toolsPlayAct, SIGNAL(triggered()), this, SLOT(slotToolsPlay()));

    toolsPauseAct = new QAction(QIcon(":/images/redo.png"), tr("&Pause"), this);
    toolsPauseAct->setShortcut(tr("Ctrl+O"));
    toolsPauseAct->setStatusTip(tr("Pause"));
    toolsPauseAct->setWhatsThis(tr("Pause\n\nswitch to Pause mode"));
    connect(toolsPauseAct, SIGNAL(triggered()), this, SLOT(slotToolsPause()));

    toolsStopAct = new QAction(QIcon(":/images/stop.png"), tr("&Stop"), this);
    toolsStopAct->setShortcut(tr("Ctrl+X"));
    toolsStopAct->setStatusTip(tr("Stop"));
    toolsStopAct->setWhatsThis(tr("Stop\n\nswitch to Stop mode"));
    connect(toolsStopAct, SIGNAL(triggered()), this, SLOT(slotToolsStop()));


    helpAboutAppAct = new QAction(tr("&About"), this);
    helpAboutAppAct->setStatusTip(tr("Show the application's About box"));
    connect(helpAboutAppAct, SIGNAL(triggered()), this, SLOT(about()));

    helpaboutQtAct = new QAction(tr("About &Qt"), this);
    helpaboutQtAct->setStatusTip(tr("Show the Qt library's About box"));
    connect(helpaboutQtAct, SIGNAL(triggered()), qApp, SLOT(aboutQt()));

    aboutPluginsAct = new QAction(tr("About &Plugins"), this);
    aboutPluginsAct->setStatusTip(tr("Show the loaded Plugins"));
    connect(aboutPluginsAct, SIGNAL(triggered()), this, SLOT(aboutPlugins()));

    
    for (int i = 0; i < MaxRecentFiles; ++i) {
        recentFileActs[i] = new QAction(this);
        recentFileActs[i]->setVisible(false);
        connect(recentFileActs[i], SIGNAL(triggered()),
                this, SLOT(openRecentFile()));
    }
}

void MainWindow::createMenus()
{
    fileMenu = menuBar()->addMenu(tr("&File"));
    fileMenu->addAction(fileNewAct);
    fileMenu->addAction(fileOpenAct);
    fileMenu->addAction(fileSaveAct);
    fileMenu->addAction(filePrintAct);
    fileMenu->addAction(filePrefAct);
    separatorAct = fileMenu->addSeparator();
    for (int i = 0; i < MaxRecentFiles; ++i)
        fileMenu->addAction(recentFileActs[i]);
    fileMenu->addSeparator();
    fileMenu->addAction(fileQuitAct);
    updateRecentFileActions();

    editMenu = menuBar()->addMenu(tr("&Edit"));
    editMenu->addAction(editUndoAct);

    viewMenu = menuBar()->addMenu(tr("&View"));
    viewMenu->addAction(viewFullScreenAct);
    viewMenu->addAction(viewFrontScreenAct);

    toolMenu = menuBar()->addMenu(tr("&Tool"));
    toolMenu->addAction(toolsEditCamAct);
    toolMenu->addAction(toolsTranslateAct);
    toolMenu->addAction(toolsRotateAct);
    toolMenu->addAction(toolsScaleAct);
    toolMenu->addAction(toolsPlayAct);
    toolMenu->addAction(toolsPauseAct);
    toolMenu->addAction(toolsStopAct);

    menuBar()->addSeparator();

    helpMenu = menuBar()->addMenu(tr("&Help"));
    helpMenu->addAction(helpAboutAppAct);
    helpMenu->addAction(helpaboutQtAct);
    helpMenu->addAction(aboutPluginsAct);
}

void MainWindow::createToolBars()
{
    fileToolBar = addToolBar(tr("File"));
    fileToolBar->addAction(fileNewAct);
    fileToolBar->addAction(fileOpenAct);
    fileToolBar->addAction(fileSaveAct);
    fileToolBar->addAction(filePrintAct);

    toolToolBar = addToolBar(tr("Tool"));
    toolToolBar->addAction(toolsEditCamAct);
    toolToolBar->addAction(toolsTranslateAct);
    toolToolBar->addAction(toolsRotateAct);
    toolToolBar->addAction(toolsScaleAct);
    toolToolBar->addAction(toolsPlayAct);
    toolToolBar->addAction(toolsPauseAct);
    toolToolBar->addAction(toolsStopAct);
}

void MainWindow::createStatusBar()
{
    statusBar()->showMessage(tr("Ready"));
}

void MainWindow::createDockWindows()
{
//***Project-Dock***
    QDockWidget *dock = new QDockWidget(tr("Project"), this);
    dock->setAllowedAreas(Qt::LeftDockWidgetArea | Qt::RightDockWidgetArea);
    opmlTree = new OpmlTree(dock);
    dock->setWidget(opmlTree);
    addDockWidget(Qt::LeftDockWidgetArea, dock);
    viewMenu->addAction(dock->toggleViewAction());
    viewProjectAct = dock->toggleViewAction();
//***Dialog-Dock***
    dock = new QDockWidget(tr("Dialog"), this);
//*****************************************************************************
    CDefaultDlg  *DefaultEdit = new CDefaultDlg("default",this,0);
    CGlobalEditDlg *GlobalEdit = new CGlobalEditDlg("GlobalEdit",this,0);
    CLampEditDlg *LampEdit = new CLampEditDlg("LampEdit",this,0);
    CCameraEditDlg *CameraEdit = new CCameraEditDlg("CameraEdit",this,0);
    CObjEditDlg *ObjEdit = new CObjEditDlg("ObjEdit",this,0);
    CBarrierEditDlg *BarrierEdit = new CBarrierEditDlg("BarrierEdit",this,0);
    CBodyEditDlg *BodyEdit = new CBodyEditDlg("BodyEdit",this,0);
    CPartsysEditDlg *PartsysEdit = new CPartsysEditDlg("PartsysEdit",this,0);
    CWavesysEditDlg *WavesysEdit = new CWavesysEditDlg("WavesysEdit",this,0);
    CFireEditDlg *FireEdit = new CFireEditDlg("FireEdit",this,0);
    CFogEditDlg *FogEdit = new CFogEditDlg("FogEdit",this,0);
    CPlayerEditDlg *PlayerEdit = new CPlayerEditDlg("PlayerEdit",this,0);
    CSkyEditDlg *SkyEdit = new CSkyEditDlg("SkyEdit",this,0);
    CShaderEditDlg *ShaderEdit = new CShaderEditDlg("ShaderEdit",this,0);
    CCursorEditDlg *CursorEdit = new CCursorEditDlg("CursorEdit",this,0);
    CSplEditDlg *SplEdit = new CSplEditDlg("SplEdit",this,0);
    CSoundEditDlg *SoundEdit = new CSoundEditDlg("SoundEdit",this,0);
    CGUITextEditDlg *GUITextEdit = new CGUITextEditDlg("GUITextEdit",this,0);
    CGUIInputEditDlg *GUIInputEdit = new CGUIInputEditDlg("GUIInputEdit",this,0);
    CGUIButtonEditDlg *GUIButtonEdit = new CGUIButtonEditDlg("GUIButtonEdit",this,0);
    CGUIOSButtonEditDlg *GUIOSButtonEdit = new CGUIOSButtonEditDlg("GUIOSButtonEdit",this,0);
    CNetworkEditDlg *NetworkEdit = new CNetworkEditDlg("NetworkEdit",this,0);
    CSceneEditDlg *SceneEdit = new CSceneEditDlg("SceneEdit",this,0);
//*****************************************************************************

// Stack fuer Dialogboxen erzeugen
    stack = new QStackedWidget(dock);
    stack->setMinimumSize( 200, 200 );
    stack->addWidget(DefaultEdit); // 0
    stack->addWidget(GlobalEdit);  // 1
    stack->addWidget(LampEdit);  // 2 
    stack->addWidget(CameraEdit);  // 3 
    stack->addWidget(ObjEdit);  // 4 
    stack->addWidget(BarrierEdit);  // 5 
    stack->addWidget(BodyEdit);  // 6 
    stack->addWidget(PartsysEdit);  // 7 
    stack->addWidget(WavesysEdit);  // 8 
    stack->addWidget(FireEdit);  // 9 
    stack->addWidget(FogEdit);  // 10 
    stack->addWidget(PlayerEdit);  // 11 
    stack->addWidget(SkyEdit);  // 12 
    stack->addWidget(ShaderEdit);  // 13 
    stack->addWidget(CursorEdit);  // 14 
    stack->addWidget(SplEdit);  // 15 
    stack->addWidget(SoundEdit);  // 16 
    stack->addWidget(GUITextEdit);  // 17 
    stack->addWidget(GUIInputEdit);  // 18
    stack->addWidget(GUIButtonEdit);  // 19
    stack->addWidget(GUIOSButtonEdit);  // 20
    stack->addWidget(NetworkEdit);  // 21
    stack->addWidget(SceneEdit);  // 22
    // hash
    stackNameForItem.insert("DEFAULT",0);
    stackNameForItem.insert("GLOBAL",1);
    stackNameForItem.insert("LAMP",2);
    stackNameForItem.insert("CAMERA",3);
    stackNameForItem.insert("OBJECT",4);
    stackNameForItem.insert("BARRIER",5);
    stackNameForItem.insert("BODY",6);
    stackNameForItem.insert("PARTSYS",7);
    stackNameForItem.insert("WAVESYS",8);
    stackNameForItem.insert("FIRE",9);
    stackNameForItem.insert("FOG",10);
    stackNameForItem.insert("PLAYER",11);
    stackNameForItem.insert("SKY",12);
    stackNameForItem.insert("SHADER",13);
    stackNameForItem.insert("CURSOR",14);
    stackNameForItem.insert("SPL",15);
    stackNameForItem.insert("JS",15);
    stackNameForItem.insert("SOUND",16);
    stackNameForItem.insert("GUI-TXT",17);
    stackNameForItem.insert("GUI-INPUT",18);
    stackNameForItem.insert("GUI-BUTTON",19);
    stackNameForItem.insert("GUI-OSBUTTON",20);
    stackNameForItem.insert("NETWORK",21);
    stackNameForItem.insert("INTRO",0);
    stackNameForItem.insert("LEVEL",0);
    stackNameForItem.insert("SCENE",22);
    stackNameForItem.insert("HISCORE",0);
    stackNameForItem.insert("END",0);
    
    stack->setCurrentIndex(stackNameForItem["DEFAULT"]);
    connect(opmlTree, SIGNAL(itemClicked(QTreeWidgetItem *, int)),
            this, SLOT(opmlitemClicked(QTreeWidgetItem *, int)));
    connect(opmlTree, SIGNAL(itemActivated(QTreeWidgetItem *, int)),
            this, SLOT(opmlitemClicked(QTreeWidgetItem *, int)));
// add to dock
    dock->setWidget(stack);
    addDockWidget(Qt::LeftDockWidgetArea, dock);
    viewMenu->addAction(dock->toggleViewAction());
    viewDialogAct=dock->toggleViewAction();
//***Messages-Dock***
    dock = new QDockWidget(tr("Messages"), this);
    dock->setAllowedAreas(Qt::BottomDockWidgetArea);
    dock->setWidget(g_messages);
    addDockWidget(Qt::BottomDockWidgetArea, dock);
    viewMenu->addAction(dock->toggleViewAction());
    viewProjectAct = dock->toggleViewAction();
}

void MainWindow::setCurrentFile(const QString &fileName)
{
    QSettings settings("QCake", "QCDesigner");
    QStringList files = settings.value("recentFileList").toStringList();
    files.removeAll(fileName);
    files.prepend(fileName);
    while (files.size() > MaxRecentFiles){
        files.removeLast();
    }
    settings.setValue("recentFileList", files);
    updateRecentFileActions();
}

void MainWindow::updateRecentFileActions()
{
    QSettings settings("QCake", "QCDesigner");
    QStringList files = settings.value("recentFileList").toStringList();
    int numRecentFiles = qMin(files.size(), (int)MaxRecentFiles);

    for (int i = 0; i < numRecentFiles; ++i) {
        QString text = tr("&%1 %2").arg(i + 1).arg(strippedName(files[i]));
        recentFileActs[i]->setText(text);
        recentFileActs[i]->setData(files[i]);
        recentFileActs[i]->setVisible(true);
    }
    for (int j = numRecentFiles; j < MaxRecentFiles; ++j)
        recentFileActs[j]->setVisible(false);

    separatorAct->setVisible(numRecentFiles > 0);
}

void MainWindow::openRecentFile()
{
    maybeSave();
    QAction *action = qobject_cast<QAction *>(sender());
    if (action)
    	loadFile(action->data().toString());
}

QString MainWindow::strippedName(const QString &fullFileName)
{
    return QFileInfo(fullFileName).fileName();
}

void MainWindow::opmlitemClicked(QTreeWidgetItem *item, int column)
{
    modified = true;
    FolderListItem *i = (FolderListItem *) item;
    ((CQcakeDlg*)stack->widget(stackNameForItem[i->text(1)]))->slotGetData(i);
    i->dialog = ((CQcakeDlg*)stack->widget(stackNameForItem[item->text(1)]));
    stack->setCurrentIndex(stackNameForItem[i->text(1)]);
    if(i->text(1) == "SCENE"){
        if(!(gl))  {  // no GLWindow
            qWarning( "MainWindow: no gl context failed" );
        }else{
          if (tmpItem != i){    // only first click on scene !!
             if(!(i->gl)){
                i->gl=gl;
             }
             i->gl->switchScene(i);
             tmpItem = i;
             g_tmpItem = i;
          }
       }
   }else{
      i->updategl();	// set the focus to it
   }
}
void MainWindow::slotFullScreen()
{
/*
   if(viewProjectAct->isChecked()){
     viewProjectAct->setChecked(false);
     viewDialogAct->setChecked(false);
   }else{
     viewProjectAct->setChecked(true);
     viewDialogAct->setChecked(true);
   }
*/
}

void MainWindow::slotFrontView()
{
      g_gl->viewCamera(NULL);
}

void MainWindow::slotToolsEditCam()
{
  g_mouse_mode=3;
  toolsEditCamAct->setChecked(true);
}

void MainWindow::slotToolsTranslate()
{
  g_mouse_mode=0;
  toolsTranslateAct->setChecked(true);
}

void MainWindow::slotToolsRotate()
{
  g_mouse_mode=1;
  toolsRotateAct->setChecked(true);
}

void MainWindow::slotToolsScale()
{
  g_mouse_mode=2;
  toolsScaleAct->setChecked(true);
}

void MainWindow::slotToolsPlay()
{
  g_messages->clear();
  if(g_gl->compile()){
      slotToolsStop();
      return;
  }
  g_playmode = 1;
  toolsPlayAct->setChecked(true);
  g_gl->setFocus ();
  QString qmsg ="Play\n";
  ErrorMsg errormsg(qmsg);
}

void MainWindow::slotToolsPause()
{
  g_playmode = 0;
  toolsPauseAct->setChecked(true);
  if(g_gl != NULL){
    g_gl->StopSound();
  }
  QString qmsg ="Pause\n";
  ErrorMsg errormsg(qmsg);
  toolsStopAct->setChecked(false);
}

void MainWindow::slotToolsStop()
{
  g_playmode = 0;
  toolsStopAct->setChecked(true);
  if (g_tmpItem != NULL && g_gl != NULL){    // only it exist !!
      g_gl->switchScene(g_tmpItem);
  }
  QString qmsg ="Stop\n";
  ErrorMsg errormsg(qmsg);
  toolsPauseAct->setChecked(false);
}

void MainWindow::loadPlugins()
{
    foreach (QObject *plugin, QPluginLoader::staticInstances()){
//        populateMenus(plugin);
    }

    pluginsDir = QDir(qApp->applicationDirPath());

#if defined(Q_OS_WIN)
    if (pluginsDir.dirName().toLower() == "debug" || pluginsDir.dirName().toLower() == "release")
        pluginsDir.cdUp();
#elif defined(Q_OS_MAC)
    if (pluginsDir.dirName() == "MacOS") {
        pluginsDir.cdUp();
        pluginsDir.cdUp();
        pluginsDir.cdUp();
    }
#endif
    pluginsDir.cd("plugins");

    foreach (QString fileName, pluginsDir.entryList(QDir::Files)) {
        QPluginLoader loader(pluginsDir.absoluteFilePath(fileName));
        QObject *plugin = loader.instance();
        if (plugin) {
//            populateMenus(plugin);
            pluginFileNames += fileName;
        }
    }

//    brushMenu->setEnabled(!brushActionGroup->actions().isEmpty());
//    shapesMenu->setEnabled(!shapesMenu->actions().isEmpty());
//    filterMenu->setEnabled(!filterMenu->actions().isEmpty());
}

void MainWindow::populateMenus(QObject *plugin)
{
/*
    BrushInterface *iBrush = qobject_cast<BrushInterface *>(plugin);
    if (iBrush)
        addToMenu(plugin, iBrush->brushes(), brushMenu, SLOT(changeBrush()),
                  brushActionGroup);

    ShapeInterface *iShape = qobject_cast<ShapeInterface *>(plugin);
    if (iShape)
        addToMenu(plugin, iShape->shapes(), shapesMenu, SLOT(insertShape()));

    FilterInterface *iFilter = qobject_cast<FilterInterface *>(plugin);
    if (iFilter)
        addToMenu(plugin, iFilter->filters(), filterMenu, SLOT(applyFilter()));
*/
}

void MainWindow::addToMenu(QObject *plugin, const QStringList &texts,
                           QMenu *menu, const char *member,
                           QActionGroup *actionGroup)
{
    foreach (QString text, texts) {
        QAction *action = new QAction(text, plugin);
        connect(action, SIGNAL(triggered()), this, member);
        menu->addAction(action);

        if (actionGroup) {
            action->setCheckable(true);
            actionGroup->addAction(action);
        }
    }
}
