/*
 * qdacco: offline Dacco Catalan <-> English dictionary
 * Copyright (C) 2005-2006 Carles Pina i estany <carles@pina.cat>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2 or any
 * later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
 * USA.
*/


#ifndef STRUCTUREPARSER_H
#define STRUCTUREPARSER_H

#include <QXmlDefaultHandler>
#include <QQueue> 
#include "worddata.h"

class QString;

class StructureParser : public QXmlDefaultHandler
{
public:
    bool startDocument();
    bool startElement( const QString&, const QString&, const QString& ,
                       const QXmlAttributes& attributes);
    bool endElement( const QString&, const QString&, const QString& );
    bool characters ( const QString & ch );
    void setParaula(const QString &s);
    void setPdebug(int i);
    WordData getWordData();
    int ensenyarLlistat();
    QQueue<QString> getWordQueue();
    bool esBuida();
    QString seguent();

private:
    bool entrada,translation,catexamp,engexamp,tipus,example;
    bool engnote,catnote,picture,plural,femplural;
    bool synonyms;

    bool trobat;
    QString paraula,definicio,qcatexamp,qengexamp;
    QString qtipus,qgender,qgender_,qtipus_,qpicture_,qflickr_;
    WordData wd;
    int pdebug;

    QQueue<QString> wordqueue;
    int after_word;
};

#endif
