/*
 * QSimpleViewer.cpp
 * $Id: QSimpleViewer.cpp,v 1.2 2001/11/15 16:54:51 guenth Exp $
 *
 * Copyright (C) 1999, 2000 Markus Janich, Michael Meissner
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * As a special exception to the GPL, the QGLViewer authors (Markus
 * Janich, Michael Meissner, Richard Guenther, Alexander Buck and Thomas
 * Woerner) give permission to link this program with Qt (non-)commercial
 * edition, and distribute the resulting executable, without including
 * the source code for the Qt (non-)commercial edition in the source
 * distribution.
 *
 */

//  Description : Class inherits from QGLExaminerViewer 
//  Purpose     : Overloads the catch key method and emits an own key signal


/** documentation stuff

  @author Michael Meissner

  @version 0.0 //see cvs docu

*/



// QT 
///////
#include <qlabel.h>
#include <qslider.h>
#include <qpushbutton.h>
#include <qlayout.h>


// Own
////////
#include "QSimpleViewer.h"




// Function   : keyPressEvent
// Parameters : QKeyEvent *event
// Purpose    : Catch any key and emit a signal containing the
//              key's ascii code
// Comments   :
void QSimpleViewer::keyPressEvent(QKeyEvent *event)
/********************************************************************/
{
  switch(event->state()) {
    case NoButton:
       cout << endl << "QSimpleViewer: Emitting the signal for the ";
       cout << "pressed key" << endl;
       emit(sigMyKey(event->ascii()));
       break;
  }
  QGLExaminerViewer::keyPressEvent(event);

  return;
}
