/*
 * Decompiled with CFR 0.152.
 */
package king.core;

import driftwood.data.UberMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import king.core.AGE;
import king.core.AHE;
import king.core.Aspect;
import king.core.BondRot;
import king.core.KGroup;
import king.core.KIterator;
import king.core.KList;
import king.core.KPaint;
import king.core.KPalette;
import king.core.KPoint;
import king.core.KView;
import king.core.MasterGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Kinemage
extends AGE<Kinemage, KGroup> {
    public Map<String, Object> metadata = new HashMap<String, Object>();
    public boolean atWhitebackground = false;
    public boolean atOnewidth = false;
    public boolean atThinline = false;
    public boolean atPerspective = false;
    public boolean atFlat = false;
    public boolean atListcolordominant = false;
    public double atLens = 0.0;
    public String atPdbfile = null;
    public String atCommand = null;
    public Collection<String> dimensionNames = new ArrayList<String>();
    public List<Number> dimensionMinMax = new ArrayList<Number>();
    public List<Number> dimensionScale = new ArrayList<Number>();
    public List<Number> dimensionOffset = new ArrayList<Number>();
    protected List<KView> viewList = new ArrayList<KView>();
    protected float[] boundingBox = null;
    protected float[] center = new float[]{0.0f, 0.0f, 0.0f};
    protected float span = 0.0f;
    protected Map<String, KPaint> allColorMap;
    protected Map<String, KPaint> newColorMap;
    protected Map<String, KPaint> unmodAllColorMap = null;
    protected Map<String, KPaint> unmodNewColorMap = null;
    protected List<Aspect> aspectList = new ArrayList<Aspect>();
    protected Map<String, MasterGroup> mastersMap = new UberMap();
    public String pmLookup = "";
    protected boolean modified = false;
    protected Collection<BondRot> bondRots = null;
    protected int outerEventFlags = 0;
    protected boolean dirtyMasters = false;
    protected boolean dirtySize = false;
    protected static final int DIRTY_MASTERS = 264457;
    protected static final int DIRTY_SIZE = 4353;

    public Kinemage(String string) {
        this.setName(string);
        this.allColorMap = new UberMap(KPalette.getFullMap());
        this.newColorMap = new UberMap();
    }

    public Kinemage() {
        this("");
    }

    public void appendKinemage(Kinemage kinemage) {
        this.atWhitebackground = this.atWhitebackground || kinemage.atWhitebackground;
        this.atOnewidth = this.atOnewidth || kinemage.atOnewidth;
        this.atThinline = this.atThinline || kinemage.atThinline;
        this.atPerspective = this.atPerspective || kinemage.atPerspective;
        this.atFlat = this.atFlat || kinemage.atFlat;
        boolean bl = this.atListcolordominant = this.atListcolordominant || kinemage.atListcolordominant;
        if (this.atPdbfile == null) {
            this.atPdbfile = kinemage.atPdbfile;
        }
        if (this.atCommand == null) {
            this.atCommand = kinemage.atCommand;
        }
        for (KView iterator : kinemage.viewList) {
            iterator.parent = this;
            this.viewList.add(iterator);
        }
        for (Aspect aspect : kinemage.aspectList) {
            aspect.parent = this;
            this.aspectList.add(aspect);
        }
        for (KPaint kPaint : kinemage.getNewPaintMap().values()) {
            this.addPaint(kPaint);
        }
        boolean bl2 = false;
        for (MasterGroup masterGroup : kinemage.masterList()) {
            MasterGroup masterGroup2;
            if (masterGroup.pm_mask != 0) {
                masterGroup.pm_mask = this.toPmBitmask(kinemage.fromPmBitmask(masterGroup.pm_mask), true, false);
                bl2 = true;
            }
            if ((masterGroup2 = this.mastersMap.get(masterGroup.getName())) == null) {
                masterGroup.setParent(this);
                this.mastersMap.put(masterGroup.getName(), masterGroup);
                continue;
            }
            masterGroup2.pm_mask |= masterGroup.pm_mask;
        }
        if (bl2) {
            for (KPoint kPoint : KIterator.allPoints(kinemage)) {
                kPoint.setPmMask(this.toPmBitmask(kinemage.fromPmBitmask(kPoint.getPmMask())));
            }
        }
        for (KGroup kGroup : kinemage) {
            this.add(kGroup);
            kGroup.setParent(this);
        }
        this.fireKinChanged(-1);
        this.initAll(false);
    }

    @Override
    public Kinemage getParent() {
        return null;
    }

    @Override
    public void setParent(Kinemage kinemage) {
    }

    @Override
    public Kinemage getKinemage() {
        return this;
    }

    @Override
    public boolean isOn() {
        return true;
    }

    @Override
    public void setOn(boolean bl) {
    }

    @Override
    public boolean hasButton() {
        return false;
    }

    @Override
    public void setHasButton(boolean bl) {
    }

    @Override
    public boolean isDominant() {
        return false;
    }

    @Override
    public void setDominant(boolean bl) {
    }

    @Override
    public void fireKinChanged(int n) {
        this.outerEventFlags |= n;
        if ((n & 0x40909) != 0) {
            this.dirtyMasters = true;
        }
        if ((n & 0x1101) != 0) {
            this.dirtySize = true;
        }
    }

    public int queryKinChanged() {
        return this.queryKinChanged(-1, -1);
    }

    public int queryKinChanged(int n, int n2) {
        int n3 = this.outerEventFlags & n;
        this.outerEventFlags &= ~n2;
        return n3;
    }

    public void initAll(boolean bl) {
        if (bl) {
            this.removeEmptyAGEs();
        }
        this.calcSize();
        this.ensureAllMastersExist();
        if (bl) {
            this.removeUnusedMasters();
        }
        this.syncAllMasters();
        this.initAllViews();
        this.animate(0);
        if (!this.hasAnimateGroups()) {
            this.animate2(0);
        }
    }

    public void initAll() {
        this.initAll(true);
    }

    protected void calcSize() {
        float[] fArray = new float[]{Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE, -3.4028235E38f, -3.4028235E38f, -3.4028235E38f};
        this.calcBoundingBox(fArray);
        this.boundingBox = fArray;
        this.center[0] = (this.boundingBox[3] + this.boundingBox[0]) / 2.0f;
        this.center[1] = (this.boundingBox[4] + this.boundingBox[1]) / 2.0f;
        this.center[2] = (this.boundingBox[5] + this.boundingBox[2]) / 2.0f;
        this.span = 2.0f * (float)Math.sqrt(this.calcRadiusSq(this.center));
        if (this.span == 0.0f) {
            this.span = 1.0f;
        }
        this.dirtySize = false;
    }

    public float getSpan() {
        if (this.boundingBox == null || this.dirtySize) {
            this.calcSize();
        }
        return this.span;
    }

    public float[] getCenter() {
        if (this.boundingBox == null || this.dirtySize) {
            this.calcSize();
        }
        return (float[])this.center.clone();
    }

    public void addView(KView kView) {
        this.viewList.add(kView);
        this.fireKinChanged(131072);
    }

    public List<KView> getViewList() {
        return this.viewList;
    }

    public void initAllViews() {
        if (this.viewList.size() < 1) {
            KView kView = new KView(this);
            this.addView(kView);
        }
        for (KView kView : this.viewList) {
            kView.getSpan();
        }
    }

    public void syncAllMasters() {
        for (MasterGroup masterGroup : this.mastersMap.values()) {
            masterGroup.syncState();
        }
    }

    public void ensureAllMastersExist() {
        for (AGE aGE : KIterator.allNonPoints(this)) {
            for (String string : aGE.getMasters()) {
                if (this.mastersMap.containsKey(string)) continue;
                MasterGroup masterGroup = this.getMasterByName(string);
                masterGroup.syncState();
            }
        }
        this.dirtyMasters = false;
    }

    public MasterGroup getMasterByName(String string) {
        MasterGroup masterGroup = this.mastersMap.get(string);
        if (masterGroup == null) {
            masterGroup = new MasterGroup(this, string);
            this.mastersMap.put(string, masterGroup);
            this.fireKinChanged(262144);
        }
        return masterGroup;
    }

    public void ensureMasterExists(String string) {
        this.getMasterByName(string);
    }

    public Collection<MasterGroup> masterList() {
        if (this.dirtyMasters) {
            this.ensureAllMastersExist();
        }
        return Collections.unmodifiableCollection(this.mastersMap.values());
    }

    public int toPmBitmask(String string, boolean bl, boolean bl2) {
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            int n3 = this.pmLookup.indexOf(string.charAt(i));
            if (n3 >= 0 && n3 < 32) {
                n |= 1 << n3;
                continue;
            }
            if (!bl || n3 != -1) continue;
            this.pmLookup = this.pmLookup + string.charAt(i);
            n3 = this.pmLookup.indexOf(string.charAt(i));
            if (n3 >= 0 && n3 < 32) {
                n |= 1 << n3;
            }
            if (!bl2) continue;
            MasterGroup masterGroup = this.getMasterByName(string.substring(i, i + 1));
            masterGroup.setPmMask(string.substring(i, i + 1));
        }
        return n;
    }

    public int toPmBitmask(String string) {
        return this.toPmBitmask(string, false, false);
    }

    public String fromPmBitmask(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 1;
        int n3 = Math.min(32, this.pmLookup.length());
        for (int i = 0; i < n3; ++i) {
            if ((n & n2) != 0) {
                stringBuffer.append(this.pmLookup.charAt(i));
            }
            n2 <<= 1;
        }
        return stringBuffer.toString();
    }

    public void animate(int n) {
        this.doAnimation(this.getAnimateGroups(), this.get2AnimateGroups(), n);
    }

    public void animate2(int n) {
        this.doAnimation(this.get2AnimateGroups(), this.getAnimateGroups(), n);
    }

    protected void doAnimation(AGE[] aGEArray, AGE[] aGEArray2, int n) {
        int n2;
        int n3;
        int n4 = -1;
        for (n3 = 0; n3 < aGEArray.length; ++n3) {
            if (!aGEArray[n3].isOn()) continue;
            n4 = n3;
            break;
        }
        int n5 = n3 = n4 == -1 ? 0 : n4 + n;
        if (n3 < 0) {
            n3 = aGEArray.length - 1;
        } else if (n3 >= aGEArray.length) {
            n3 = 0;
        }
        for (n2 = 0; n2 < aGEArray.length; ++n2) {
            aGEArray[n2].setOn(n2 == n3);
        }
        for (n2 = 0; n2 < aGEArray2.length; ++n2) {
            aGEArray2[n2].setOn(false);
        }
    }

    public void accumulate() {
        this.doAccumulate(this.getAnimateGroups());
    }

    public void accumulate2() {
        this.doAccumulate(this.get2AnimateGroups());
    }

    protected void doAccumulate(AGE[] aGEArray) {
        int n;
        int n2 = -1;
        for (n = 0; n < aGEArray.length; ++n) {
            if (!aGEArray[n].isOn()) continue;
            n2 = n;
            break;
        }
        for (n = n2 + 1; n < n2 + aGEArray.length; ++n) {
            if (aGEArray[n % aGEArray.length].isOn()) continue;
            aGEArray[n % aGEArray.length].setOn(true);
            break;
        }
    }

    public boolean hasAnimateGroups() {
        for (KGroup kGroup : this.children) {
            if (!kGroup.isAnimate()) continue;
            return true;
        }
        return false;
    }

    public boolean has2AnimateGroups() {
        for (KGroup kGroup : this.children) {
            if (!kGroup.is2Animate()) continue;
            return true;
        }
        return false;
    }

    protected KGroup[] getAnimateGroups() {
        ArrayList<KGroup> arrayList = new ArrayList<KGroup>();
        for (KGroup kGroup : this.children) {
            if (!kGroup.isAnimate()) continue;
            arrayList.add(kGroup);
        }
        return arrayList.toArray(new KGroup[arrayList.size()]);
    }

    protected KGroup[] get2AnimateGroups() {
        ArrayList<KGroup> arrayList = new ArrayList<KGroup>();
        for (KGroup kGroup : this.children) {
            if (!kGroup.is2Animate()) continue;
            arrayList.add(kGroup);
        }
        return arrayList.toArray(new KGroup[arrayList.size()]);
    }

    public void addPaint(KPaint kPaint) {
        if (kPaint == null) {
            throw new NullPointerException("Can't add a null paint");
        }
        this.allColorMap.put(kPaint.toString(), kPaint);
        this.newColorMap.put(kPaint.toString(), kPaint);
        this.fireKinChanged(0x100000);
    }

    public KPaint getPaintForName(String string) {
        KPaint kPaint = this.allColorMap.get(string);
        if (kPaint == null) {
            kPaint = KPalette.forName(string);
        }
        return kPaint;
    }

    public Map<String, KPaint> getAllPaintMap() {
        if (this.unmodAllColorMap == null) {
            this.unmodAllColorMap = Collections.unmodifiableMap(this.allColorMap);
        }
        return this.unmodAllColorMap;
    }

    public Map<String, KPaint> getNewPaintMap() {
        if (this.unmodNewColorMap == null) {
            this.unmodNewColorMap = Collections.unmodifiableMap(this.newColorMap);
        }
        return this.unmodNewColorMap;
    }

    public void createAspect(String string, Integer n) {
        Aspect aspect = new Aspect(this, string, n);
        this.aspectList.add(aspect);
        this.fireKinChanged(524288);
    }

    public List<Aspect> getAspects() {
        return Collections.unmodifiableList(this.aspectList);
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean bl) {
        this.modified = bl;
    }

    public void setBondRots(Collection<BondRot> collection) {
        this.bondRots = collection;
    }

    public Collection<BondRot> getBondRots() {
        return this.bondRots;
    }

    public void removeUnusedMasters() {
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        for (AGE object : KIterator.allNonPoints(this)) {
            hashSet.addAll(object.getMasters());
        }
        for (KList kList : KIterator.allLists(this)) {
            for (AHE<KList> aHE : kList.getChildren()) {
                n |= aHE.getPmMask();
            }
        }
        Iterator<Object> iterator = this.mastersMap.entrySet().iterator();
        while (iterator.hasNext()) {
            AHE<KList> aHE;
            Map.Entry entry = (Map.Entry)iterator.next();
            String string = (String)entry.getKey();
            aHE = (MasterGroup)entry.getValue();
            if (hashSet.contains(string) || (((MasterGroup)aHE).pm_mask & n) != 0) continue;
            iterator.remove();
            this.fireKinChanged(262144);
        }
    }

    public void removeEmptyAGEs() {
        this.removeEmptyAGEs(this);
    }

    protected void removeEmptyAGEs(AGE aGE) {
        Iterator iterator = aGE.getChildren().iterator();
        while (iterator.hasNext()) {
            AGE aGE2;
            AHE aHE = (AHE)iterator.next();
            if (aHE instanceof KList) {
                aGE2 = (KList)aHE;
                if (!aGE2.getChildren().isEmpty() || ((KList)aGE2).getInstance() != null) continue;
                iterator.remove();
                if (aGE2.getParent() == aGE) {
                    aGE2.setParent(null);
                }
                this.fireKinChanged(1);
                continue;
            }
            if (!(aHE instanceof AGE)) continue;
            aGE2 = (AGE)aHE;
            this.removeEmptyAGEs(aGE2);
            if (!aGE2.getChildren().isEmpty()) continue;
            iterator.remove();
            if (aGE2.getParent() == aGE) {
                aGE2.setParent(null);
            }
            this.fireKinChanged(1);
        }
    }
}

