/*
 * Decompiled with CFR 0.152.
 */
package king.tool.bondrot;

import driftwood.gui.AngleDial;
import driftwood.gui.TablePane;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import king.BasicTool;
import king.ToolBox;
import king.UIText;
import king.core.BondRot;
import king.tool.bondrot.BondRotHandler;
import king.tool.bondrot.HyperRotParser;

public class SuiteRotationTool
extends BasicTool
implements ChangeListener,
ListSelectionListener,
ActionListener,
UIText.HypertextListener {
    AngleDial rotDial;
    TablePane pane;
    JList rotJList;
    JList hypJList;
    JTextField angField;
    HyperRotParser hyptyp;
    BondRotHandler handler;
    BondRot oldRot = null;
    boolean valueChanging = false;
    ArrayList highlightedLists = null;

    public SuiteRotationTool(ToolBox toolBox) {
        super(toolBox);
        this.buildGUI();
    }

    private void buildGUI() {
        this.rotDial = new AngleDial();
        this.rotJList = new JList();
        this.hypJList = new JList();
        this.angField = new JTextField("", 5);
        this.angField.addActionListener(this);
        this.pane = new TablePane();
        this.pane.addCell(this.rotJList);
        this.pane.addCell(this.rotDial);
        this.pane.addCell(this.hypJList);
        this.pane.newRow();
        this.pane.skip();
        this.pane.addCell(this.angField);
    }

    public void start() {
        Collection<BondRot> collection = this.kMain.getKinemage().getBondRots();
        if (collection.size() > 0) {
            this.handler = new BondRotHandler(collection);
            this.hyptyp = new HyperRotParser(this.kMain.getTextWindow().getText());
            DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
            String[] stringArray = this.hyptyp.getHypList();
            for (int i = 0; i < stringArray.length; ++i) {
                defaultListModel.addElement(stringArray[i]);
            }
            this.hypJList.setModel(defaultListModel);
            DefaultListModel<BondRot> defaultListModel2 = new DefaultListModel<BondRot>();
            BondRot[] bondRotArray = this.handler.getBondRotArray();
            for (int i = 0; i < bondRotArray.length; ++i) {
                defaultListModel2.addElement(bondRotArray[i]);
            }
            this.rotJList.setModel(defaultListModel2);
            this.rotJList.setSelectionMode(0);
            this.highlightedLists = new ArrayList();
            this.show();
            this.rotDial.addChangeListener(this);
            this.rotJList.addListSelectionListener(this);
            this.hypJList.addListSelectionListener(this);
            this.kMain.getTextWindow().addHypertextListener(this);
        }
        this.kCanvas.repaint();
    }

    public void reset() {
        this.stop();
        if (this.kMain.getKinemage() != null) {
            this.start();
        }
    }

    public void stop() {
        this.oldRot = null;
        this.rotDial.removeChangeListener(this);
        this.rotJList.removeListSelectionListener(this);
        DefaultListModel defaultListModel = (DefaultListModel)this.rotJList.getModel();
        defaultListModel.clear();
        this.hypJList.removeListSelectionListener(this);
        defaultListModel = (DefaultListModel)this.hypJList.getModel();
        defaultListModel.clear();
        this.kMain.getTextWindow().removeHypertextListener(this);
        this.hide();
    }

    protected Container getToolPanel() {
        return this.pane;
    }

    public String getHelpAnchor() {
        return "#suite-tool";
    }

    public String toString() {
        return "Suite Rotation";
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (!this.valueChanging) {
            this.handler.doRotation(this.oldRot, this.rotDial.getDegrees());
            this.kCanvas.repaint();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        JList jList;
        this.valueChanging = true;
        if (this.oldRot != null) {
            this.handler.updateCoords(this.oldRot);
            this.oldRot.setCurrentAngle(this.rotDial.getDegrees());
        }
        if ((jList = (JList)listSelectionEvent.getSource()).equals(this.rotJList)) {
            this.oldRot = (BondRot)this.rotJList.getSelectedValue();
            if (this.oldRot != null) {
                this.rotDial.setOrigDegrees(this.oldRot.getOrigAngle());
                this.rotDial.setDegrees(this.oldRot.getCurrentAngle());
                this.kCanvas.repaint();
            }
        } else if (jList.equals(this.hypJList)) {
            this.rotJList.clearSelection();
            this.rotDial.setDegrees(0.0);
            this.rotDial.setOrigDegrees(0.0);
            String string = (String)this.hypJList.getSelectedValue();
            ArrayList arrayList = this.hyptyp.getRotList(string);
            for (BondRot bondRot : arrayList) {
                if (this.handler.getBondRot(bondRot.getName()) == null) continue;
                this.handler.doRotation(this.handler.getBondRot(bondRot.getName()), bondRot.getCurrentAngle());
                this.handler.updateCoords(this.handler.getBondRot(bondRot.getName()));
                this.handler.getBondRot(bondRot.getName()).setCurrentAngle(bondRot.getCurrentAngle());
            }
            this.kCanvas.repaint();
        }
        this.valueChanging = false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.valueChanging = true;
        double d = Double.parseDouble(this.angField.getText());
        this.handler.doRotation(this.oldRot, d);
        this.handler.updateCoords(this.oldRot);
        this.oldRot.setCurrentAngle(d);
        this.rotDial.setDegrees(this.oldRot.getCurrentAngle());
        this.angField.setText("");
        this.valueChanging = false;
        this.kCanvas.repaint();
    }

    public void mageHypertextHit(String string) {
        ArrayList arrayList = this.hyptyp.extractRotInfo(string);
        for (BondRot bondRot : arrayList) {
            this.handler.doRotation(this.handler.getBondRot(bondRot.getName()), bondRot.getCurrentAngle());
            this.handler.updateCoords(this.handler.getBondRot(bondRot.getName()));
            this.kCanvas.repaint();
        }
    }

    private void pause() {
        long l = System.currentTimeMillis();
        long l2 = 0L;
        System.out.println("Pause on");
        while (l2 < l + 1000L) {
            l2 = System.currentTimeMillis();
        }
        System.out.println("Pause off");
    }

    public void debugSet() {
    }

    public void debug() {
    }
}

