// qsamplerInstrument.h
//
/****************************************************************************
   Copyright (C) 2004-2007, rncbc aka Rui Nuno Capela. All rights reserved.
   Copyright (C) 2007, Christian Schoenebeck

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*****************************************************************************/

#ifndef __qsamplerInstrument_h
#define __qsamplerInstrument_h

#include <QStringList>

namespace QSampler {

//-------------------------------------------------------------------------
// QSampler::Instrument - MIDI instrument map structure.
//

class Instrument
{
public:

	// Constructor.
	Instrument(int iMap = 0, int iBank = -1, int iProg = -1);

	// Default destructor.
	~Instrument();

	// Instrument accessors.
	void setMap(int iMap);
	int map() const;

	void setBank(int iBank);
	int bank() const;

	void setProg(int iProg);
	int prog() const;

	void setName(const QString& sName);
	const QString& name() const;

	void setEngineName(const QString& sEngineName);
	const QString& engineName() const;

	void setInstrumentFile(const QString& sInstrumentFile);
	const QString& instrumentFile() const;

	const QString& instrumentName() const;

	void setInstrumentNr(int InstrumentNr);
	int instrumentNr() const;

	void setVolume(float fVolume);
	float volume() const;

	void setLoadMode(int iLoadMode);
	int loadMode() const;

	// Sync methods.
	bool getInstrument();
	bool mapInstrument();
	bool unmapInstrument();

	// Instrument map names initialization...
	static QStringList getMapNames();
	static QString     getMapName(int iMidiMap);

private:

	// Instance variables.
	int     m_iMap;
	int     m_iBank;
	int     m_iProg;
	QString m_sName;
	QString m_sEngineName;
	QString m_sInstrumentFile;
	QString m_sInstrumentName;
	int     m_iInstrumentNr;
	float   m_fVolume;
	int     m_iLoadMode;
};

} // namespace QSampler

#endif  // __qsamplerInstrument_h


// end of qsamplerInstrument.h
