/***************************************************************************
                          fft.h  -  QSSTV
                             -------------------
    begin                : Sat Feb 10 2001
    copyright            : (C) 2001 by Johan Maes - ON1MH
    email                : on1mh@pandora.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef FFT_H
#define FFT_H
#include <qframe.h>
#include <qimage.h>
#include <qpointarray.h>

/**Fast Fourier Transform
  *@author Johan Maes - ON1MH
  */
#define FFTWIDTH 256
#define FFTHEIGHT 80

class fft : public QFrame
 {
 	Q_OBJECT
public: 
	fft(QWidget *p=NULL,const char *name=NULL);
	~fft();
  /** must be called before performing any FFT */
  void initFFT(unsigned int fftLength);
  /** do the actual FFT calculation */
  void realFFT(short int *iBuffer);
  /** plot one sgement of FFTLEN */
  void paintEvent(QPaintEvent *);
public slots:
	void mousePressEvent( QMouseEvent *e );

private:
	unsigned int points;
	double *sineTable;
	short *bitReversed;
	double *A,*B;
	double*sptr;
	double *endptr1,*endptr2;
	short *br1,*br2;
	double HRplus,HRminus,HIplus,HIminus;
	uint *arMag;
	double *oBuffer;
	uint bufIndex;
	uint dataLength;
	short int *buffer;
	QImage *im;
	int maxMag;
	int span; // frequency range to show
	bool showWaterfall;
	uint volAvg;
	QPointArray *FFTArray;
	uint fftArray[FFTWIDTH];
private: // Private methods
  /** delete allocated buffers */
  void deleteBuffers();
  /** No descriptions */
  void draw();
};

#endif
