/***************************************************************************
                          filefunc.h  -  QSSTV
                             -------------------
    begin                : Tue Apr 17 22:27:58 CEST 2001
    copyright            : (C) 2001 by Johan Maes ON1MH
    email                : on1mh@pandora.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FILEFUNC_H
#define FILEFUNC_H
#include "qstring.h"
#include <stdio.h>
#include <qfile.h>
#include <qdir.h>


// changes the file's extension
// if Always=FALSE ; add extention but do not change it if there is one
// if Always=TRUE ; change extension if there is one or add one

void changeExtension(QFileInfo &fdest,const char *ext,bool Always=TRUE);

#if  QT_VERSION <200
bool openForRead(QFile &fn,QDir StartWith=NULL,const char * ext="*"); 
bool openForWrite(QFile &fn,QDir StartWith=NULL,const char *ext="*");
#else
bool openForRead(QFile &fn,QDir StartWith=QString::null,const char * ext="*"); 
bool openForWrite(QFile &fn,QDir StartWith=QString::null,const char *ext="*");
#endif

bool getFileName(QFile &fn,QDir StartWith,const char *ext);

// keeps the directory path and eliminates the extension from the filename
void fileDirBaseName(QFileInfo &fdest,const QString fsrc);

// combines dirname and filename
void fullFilename(QFileInfo &fdest,const QDir dsrc,const QString fsrc);
#endif




