#include "thumbframe.h"
#include "qsstvglobal.h"
#include <qapp.h>
#include <qmsgbox.h>
#include <qpainter.h>
#include "dirdialog.h"
#include "imageframe.h"

thumbFrame::thumbFrame(QWidget* parent,int irow,int icolumn):QFrame(parent,NULL)
{
  imageFile.setFile("");
  setFrameStyle(QFrame::Panel|QFrame::Sunken);
  setLineWidth( 2 );
  //  setBackgroundMode( PaletteBase );
  pm.resize(width(),height());
  pm.fill(qRgb(0,80,80));
  show();
  row=irow;
  column=icolumn;
  
}

thumbFrame::thumbFrame(QWidget* parent,const char *name):QFrame(parent,name)
{
  
  setFrameStyle(QFrame::Panel|QFrame::Sunken);
  setLineWidth( 2 );
  pm.resize(width(),height());
  pm.fill(qRgb(0,80,80));
  row=0;
  column=0;
}

void thumbFrame::setCanvas(imageFrame *c)
{
  canvas=c;
}

void thumbFrame::mousePressEvent( QMouseEvent *e )
{
  QString temp;
  QString fn;
  temp=imageFile.filePath();
  if (( e->button() == LeftButton )&&(!temp.isEmpty()))
    {
      // transfer
      if (canvas!=NULL)
				{
	  			canvas->load(imageFile);
				}
    }
  else if (e->button() == RightButton)
    {
      // load image in thumbnail
	  	dirDialog dd(0,0,TRUE);
  		fn=dd.openFileName(configFile.readOption("ImageTxDir"));
  		if(!fn.isNull())
	  		{
  	    	load(QFileInfo(fn));
    		}
    }
}


void thumbFrame::load(QFileInfo fn)
{
  bool pix = pm.load(fn.filePath());		
  if ( !pix )
    {
      fileLoadError("Thumbframe Load error",fn.filePath());
      return;
    }
  imageFile=fn;
  scale(width(),height());
  repaint(FALSE);
}

QFileInfo *thumbFrame::getFilename()
{
  return(&imageFile);
}
 
void thumbFrame::paintEvent(QPaintEvent *e)
{
  QString temp;
  QFrame::paintEvent(e);
  temp=imageFile.filePath();
  if (!temp.isEmpty())
    {
      bitBlt(this, 0,0,&pmScaled);
    }   
}  


void thumbFrame::scale(int width, int height)
{
  QApplication::setOverrideCursor( waitCursor );          // this might take time   
  QWMatrix m;			                       	  // transformation matrix
  m.scale(((double)width)/pm.width(),	                  // define scale factors
		((double)height)/pm.height());
  pmScaled = pm.xForm( m );		                  // create scaled pixmap
  QApplication::restoreOverrideCursor();	          // restore original cursor
}


void thumbFrame::resizeEvent(QResizeEvent *)
{
  scale(width(),height());
  repaint(FALSE);
}


















