#ifndef XmlTimeStamp_h
#define XmlTimeStamp_h

// $Id: XmlTimeStamp.h,v 1.10 2013/04/29 07:18:59 hupereir Exp $

/******************************************************************************
*
* Copyright (C) 2002 Hugo PEREIRA <mailto: hugo.pereira@free.fr>
*
* This is free software; you can redistribute it and/or modify it under the
* terms of the GNU General Public License as published by the Free Software
* Foundation; either version 2 of the License, or (at your option) any later
* version.
*
* This software is distributed in the hope that it will be useful, but WITHOUT
* Any WARRANTY; without even the implied warranty of MERCHANTABILITY or
* FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
* for more details.
*
* You should have received a copy of the GNU General Public License along with
* this program.  If not, see <http://www.gnu.org/licenses/>.
*
*******************************************************************************/

#include "TimeStamp.h"

#include <QDomDocument>
#include <QDomElement>
#include <QString>

//! Xml interface to time manipulation object
class XmlTimeStamp:public TimeStamp
{

    public:

    //! empty constructor
    XmlTimeStamp( void )
    {}

    //! constructor from DOM
    XmlTimeStamp( const QDomElement& );

    //! create from timestamp
    XmlTimeStamp( const TimeStamp& stamp ):
        TimeStamp( stamp )
    {}

    //! get DOM element
    QDomElement domElement( const QString&, QDomDocument& ) const;

};

#endif
