Polymer({

    is: 'ripple-animation',

    behaviors: [
      Polymer.NeonSharedElementAnimationBehavior
    ],

    configure: function(config) {
      var shared = this.findSharedElements(config);
      if (!shared) {
        return null;
      }

      var translateX, translateY;
      var toRect = shared.to.getBoundingClientRect();
      if (config.gesture) {
        translateX = config.gesture.x - (toRect.left + (toRect.width / 2));
        translateY = config.gesture.y - (toRect.top + (toRect.height / 2));
      } else {
        var fromRect = shared.from.getBoundingClientRect();
        translateX = (fromRect.left + (fromRect.width / 2)) - (toRect.left + (toRect.width / 2));
        translateY = (fromRect.top + (fromRect.height / 2)) - (toRect.top + (toRect.height / 2));
      }
      var translate = 'translate(' + translateX + 'px,' + translateY + 'px)';

      var size = Math.max(toRect.width + Math.abs(translateX) * 2, toRect.height + Math.abs(translateY) * 2);
      var diameter = Math.sqrt(2 * size * size);
      var scaleX = diameter / toRect.width;
      var scaleY = diameter / toRect.height;
      var scale = 'scale(' + scaleX + ',' + scaleY + ')';

      this.setPrefixedProperty(shared.to, 'transformOrigin', '50% 50%');
      shared.to.style.borderRadius = '50%';

      this._effect = new KeyframeEffect(shared.to, [
        {'transform': translate + ' scale(0)'},
        {'transform': translate + ' ' + scale}
      ], this.timingFromConfig(config));
      return this._effect;
    },

    complete: function() {
      if (this.sharedElements) {
        this.setPrefixedProperty(this.sharedElements.to, 'transformOrigin', '');
        this.sharedElements.to.style.borderRadius = '';
      }
    }

  });