/* -*- Mode: C++; c-basic-offset: 2; tab-width: 2; indent-tabs-mode: nil -*-
 * 
 * Quadra, an action puzzle game
 * Copyright (C) 1998-2000  Ludus Design
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "video.h"
#include "input_dumb.h"
#ifdef UGS_LINUX_X11
#include "input_x11.h"
#endif
#ifdef UGS_LINUX_SVGA
#include "input_svga.h"
#endif

RCSID("$Id: input.cpp,v 1.3 2000/11/30 01:26:28 pphaneuf Exp $")

Input *input = NULL;

Input* Input::New(bool dumb) {
  if(dumb)
    return new Input_Dumb();
#ifdef UGS_LINUX_X11
  if(video->xwindow)
    return new Input_X11;
  else
#endif
#ifdef UGS_LINUX_SVGA
    return new Input_Svgalib;
#endif
  return NULL;
}
