
/*
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

// Id: BoundaryConditions.i,v 1.1 2001/05/23 13:14:20 nando Exp $

#ifndef quantlib_boundary_conditions_i
#define quantlib_boundary_conditions_i

%{
using QuantLib::FiniteDifferences::BoundaryCondition;
typedef BoundaryCondition::Type BoundaryConditionType;
using QuantLib::StringFormatter;
%}

// typemap boundary condition type to the corresponding strings

%typemap(python,in) BoundaryConditionType (BoundaryConditionType temp),
  const BoundaryConditionType & (BoundaryConditionType temp) {
    if (PyString_Check($source)) {
        std::string s(PyString_AsString($source));
        s = StringFormatter::toLowercase(s);
        if (s == "" || s == "none")
            temp = BoundaryCondition::None;
        else if (s == "neumann")
            temp = BoundaryCondition::Neumann;
        else if (s == "dirichlet")
            temp = BoundaryCondition::Dirichlet;
        else {
            PyErr_SetString(PyExc_TypeError,"not a boundary condition type");
            return NULL;
        }
    } else {
        PyErr_SetString(PyExc_TypeError,"not a boundary condition type");
        return NULL;
    }
    $target = &temp;
};

%typemap(python,out) BoundaryConditionType, const BoundaryConditionType & {
    switch (*$source) {
      case BoundaryCondition::None:
        $target = PyString_FromString("None");
        break;
      case BoundaryCondition::Neumann:
        $target = PyString_FromString("Neumann");
        break;
      case BoundaryCondition::Dirichlet:
        $target = PyString_FromString("Dirichlet");
        break;
      default:
        throw Error("unknown boundary condition type");
    }
};

%typemap(python,ret) BoundaryConditionType {
    delete $source;
};

// Boundary condition

class BoundaryCondition {
  public:
    // constructors
	BoundaryCondition(BoundaryConditionType type, double value);
	~BoundaryCondition();
	// inspectors
	BoundaryConditionType type() const;
	double value() const;
};


#endif

