
/*
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

// $Id: Observer.i,v 1.11 2002/03/05 16:58:17 lballabio Exp $

#ifndef quantlib_observer_i
#define quantlib_observer_i

%{
using QuantLib::Patterns::Observer;
using QuantLib::Patterns::Observable;
using QuantLib::Handle;
typedef Handle<Observer> ObserverHandle;
typedef Handle<Observable> ObservableHandle;
%}

%name(Observable) class ObservableHandle {
  private:
    ObservableHandle();
  public:
    ~ObservableHandle();
};

// Python function to be called when a given observable changes
%typemap(python,in) PyObject* pyObserverCallback {
	$target = $source;
}

%{
// C++ wrapper for Python observer
// the observables it registers with should be stored from Python
// so that they can be unregistered
class PyObserver : public Observer {
  public:
	PyObserver(PyObject* pyObserverCallback)
	: pyObserverCallback_(pyObserverCallback) {
	    /* make sure the Python object stays alive
	       as long as we need it */
	    Py_XINCREF(pyObserverCallback_);
    }
    PyObserver(const PyObserver& o)
    : pyObserverCallback_(o.pyObserverCallback_) {
	    /* make sure the Python object stays alive
	       as long as we need it */
	    Py_XINCREF(pyObserverCallback_);
    }
    PyObserver& operator=(const PyObserver& o) {
        if ((this != &o) && (pyObserverCallback_ != o.pyObserverCallback_)) {
            Py_XDECREF(pyObserverCallback_);
            pyObserverCallback_ = o.pyObserverCallback_;
    	    Py_XINCREF(pyObserverCallback_);
        }
        return *this;
    }
    ~PyObserver() {
        // now it can go as far as we are concerned
        Py_XDECREF(pyObserverCallback_);
    }
    void update() {
		PyObject* pyResult = PyObject_CallFunction(pyObserverCallback_,NULL);
		QL_ENSURE(pyResult != NULL, "failed to notify Python observer");
		Py_XDECREF(pyResult);
    }
  private:
	PyObject* pyObserverCallback_;
};
%}

// Python wrapper
%name(Observer) class PyObserver {
  public:
	PyObserver(PyObject* pyObserverCallback);
    ~PyObserver();
    void registerWith(const ObservableHandle&);
    void unregisterWith(const ObservableHandle&);
};


#endif
