
/*
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

// $Id: Pricers.i,v 1.16 2002/01/16 14:50:51 nando Exp $

#ifndef quantlib_pricers_i
#define quantlib_pricers_i

%include Date.i
%include Options.i
%include Types.i
%include Vectors.i
%include Barrier.i

%{
using QuantLib::Pricers::BarrierOption;
using QuantLib::Pricers::BinaryOption;
using QuantLib::Pricers::CliquetOption;
using QuantLib::Pricers::ContinuousGeometricAPO;
using QuantLib::Pricers::DiscreteGeometricAPO;
using QuantLib::Pricers::DiscreteGeometricASO;
using QuantLib::Pricers::EuropeanOption;
%}


class EuropeanOption {
  public:
	EuropeanOption(OptionType type, double underlying, double strike,
	  Spread dividendYield, Rate riskFreeRate, Time residualTime,
	  double volatility);
	~EuropeanOption();
	double value() const;
	double delta() const;
	double gamma() const;
	double theta() const;
	double vega() const;
	double rho() const;
	double dividendRho() const;
	double impliedVolatility(double targetValue, double accuracy = 1e-4,
	  int maxEvaluations = 100) const ;
};


class CliquetOption {
  public:
	CliquetOption(OptionType type,
                  double underlying,
                  Spread dividendYield,
                  Rate riskFreeRate,
                  const DoubleVector &dates,
                  double volatility);
	~CliquetOption();
	double value() const;
	double delta() const;
	double gamma() const;
	double theta() const;
	double vega() const;
	double rho() const;
	double dividendRho() const;
	double impliedVolatility(double targetValue,
	                         double accuracy = 1e-4,
	                         int maxEvaluations = 100) const ;
};

class BinaryOption {
  public:
	BinaryOption(OptionType type, double underlying, double strike,
	  Spread dividendYield, Rate riskFreeRate, Time residualTime,
	  double volatility, double cashPayoff = 1);
	~BinaryOption();
	double value() const;
	double delta() const;
	double gamma() const;
	double theta() const;
	double vega() const;
	double rho() const;
	double dividendRho() const;
	double impliedVolatility(double targetValue, double accuracy = 1e-4,
	  int maxEvaluations = 100) const ;
};

class BarrierOption {
  public:
    BarrierOption(BarrierType barrType, OptionType type, double underlying,
        double strike, Spread dividendYield, Rate riskFreeRate,
        Time residualTime, double volatility, double barrier,
        double rebate = 0.0);
    ~BarrierOption();
	double delta() const;
	double gamma() const;
	double theta() const;
	double vega() const;
	double rho() const;
	double dividendRho() const;
    double value() const;
};

class ContinuousGeometricAPO {
  public:
	ContinuousGeometricAPO(OptionType type, double underlying,
		double strike,
		Spread dividendYield, Rate riskFreeRate, double residualTime,
		double volatility);
    ~ContinuousGeometricAPO();
	double value() const;
};

class DiscreteGeometricAPO {
  public:
	DiscreteGeometricAPO(OptionType type,
                         double underlying,
                         double strike,
                         Spread dividendYield,
                         Rate riskFreeRate,
                         const DoubleVector& timeDelays,
                         double volatility);
    ~DiscreteGeometricAPO();
	double value() const;
};

class DiscreteGeometricASO {
  public:
	DiscreteGeometricASO(OptionType type,
                         double underlying,
                         Spread dividendYield,
                         Rate riskFreeRate,
                         const DoubleVector& timeDelays,
                         double volatility);
    ~DiscreteGeometricASO();
	double value() const;
};

#endif
