/***************************************************************************
 *            types.h
 *
 *  Fri Aug 25 15:18:21 2006
 *  Copyright  2006-2007  Neil Williams
 *  linux@codehelp.co.uk
 ****************************************************************************/
/*
    This package is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef _TYPES_H
#define _TYPES_H
/** @file types.h
	@brief Main data structures for Quicklist 
	
	\todo relocate definitions into respective files

	@author Copyright 2006-2007  Neil Williams <linux@codehelp.co.uk>
	@author Copyright 1999  Robert Lissner 
*/

#include <libgnomevfs/gnome-vfs.h>

/** \todo remove or rationalise limits. */
#define MAX_RECORDS        5000
#define MAX_FIELDS           30
#define MAX_FIELD_NAME       30
#define MAX_SORTS            12
#define MAX_SORT_NESTING      6
#define MAX_FILTERS          12
#define MAX_FILTER_NESTING    6
#define MAX_FILTER_COMPARE   30
#define MAX_REPORTS          18
#define MAX_CLIPBOARD      5000
#define SINGLE_COL 1

/** identifier used to store the tab context in the dialogue. */
#define QLTABID "QuickListTabID"

typedef enum
{ 
	FIELD_TYPE_TEXT = 1,
	FIELD_TYPE_NUMERIC,
	FIELD_TYPE_DATE,
	FIELD_TYPE_TIME
} QlFieldType;

typedef enum
{
	MODE_NEW = 1,
	MODE_EDIT,
	MODE_SAVE,
	MODE_OPEN,
	MODE_ADD,
	MODE_IMPORT,
	MODE_EXPORT,
} QlDialogMode;

typedef enum
{
	DISPLAY_EMPTY = 0,
	DISPLAY_LIST,
	DISPLAY_REPORT,
	DISPLAY_EDIT,
	DISPLAY_PRINT,
} QlDisplayMode;

typedef enum
{
	SELECT_NONE = 0,
	SELECT_COLUMN,
	SELECT_ROW,
	SELECT_BLOCK,
	SELECT_ENTRY
} QlSelectMode;

typedef enum
{
	QL_NO_FILE = 0,
	QL_OLD_QLF,
	QL_EXPORT_HTML,
	QL_CSV,
	QL_TSV,
	QL_XML
} QlFileType;

/** Structure to store one line of one sort. There can be up to 6 of
   these in one sort definition */
typedef struct 
{
	gint16 field; /* Which field to sort on */
	gboolean  ascending; /* True: ascending, false: descending */
	gint16  column;
	gint unused; 
} QlSortLine;

/** Structure to store one complete sort specification in memory */
typedef struct 
{
	gchar * name;
	gint16 line_ct; /* 0 is invalid */
	QlSortLine line[MAX_SORT_NESTING + 1];	/* line [0] unused */
	gint16 unused1, unused2; 
} QlSortInfo;

/** Structure to store one line of 1 filter */
typedef struct
{
	gboolean unused3; 
	gint16 field; /** -1 is "this field has been dropped */
	gint16 type; /** type of comparison, 0 .. n-1 */ 
	gchar compare[MAX_FILTER_COMPARE + 2];
	gint16 unused1, unused2;
} QlFilterLine;

/** Structure to store one complete filter */
typedef struct 
{
	gchar name[MAX_FIELD_NAME + 2];
	gint16 line_ct;
	gint16 unused2;
	gboolean by_and; /** True:  filter lines are linked by AND, False:  OR */
	QlFilterLine line[MAX_FILTER_NESTING];
	gboolean use_nocase;
} QlFilterInfo;

/** Structure to store one column's information in a report */
typedef struct
{
	gint16 field; /* which field from the data base comes first */
	gint16 width; /* in characters */
	gint16 group; /* True or false, group summary on change this col */
	gint16 total; /* True or false, print totals this column */
	gint16 unused1, unused2;
} QlReportColumn;

/** \brief Structure to store a whole report 

\todo Revise to remove the fixed length buffers in preference for
GList and the GtkHTML QlTHead data.

*/
typedef struct
{
	gchar * name;
	gint16 last_column;
	gint16 width;
	gint16 height;
	QlReportColumn column[MAX_FIELDS + 2];	/** column [0] is unused */
	gint16 sort; /** which sort rule, -1 means none */
	gint16 filter; /** which filter, -1 means none */
	gchar * header;
	gchar * footer;
} QlReportInfo;

/** \brief Implements Model-View-Controller
QlFileData includes the mode enumerators and file data - model
QlViewData includes the widget and the sheet pointers
The controller is GtkSheet/quicklist toolbar.

One QlViewData and one QlFileData per file.
Each file has one Display tab and optional report tabs.

 \todo Need a ReportView as well. Then have only one fileView
and one fileData for each fileTab.
*/
typedef struct
{
	/** \todo zero is none - replace with GList */
	QlFilterInfo *filter_ptr;
	/** \todo zero is none - replace with GList */
	QlSortInfo *sort_ptr;
	/** \todo zero is none - replace with GList */
	QlReportInfo *report_ptr;
	GHashTable * fields;
	/** converts col 0 to field 2, etc \todo FIXME */
	gint16 col_to_field[MAX_FIELDS + 1];
	/** \todo replace with GList */
	QlSortInfo sorts[MAX_SORTS + 1];
	/** \todo replace with GList */
	QlFilterInfo filters[MAX_FILTERS + 1];
	/** \todo replace with GList */
	QlReportInfo reports[MAX_REPORTS + 1];
	/** \todo make into a list */
	QlFileType current_file; 
	/** basename without path */
	gchar *file_name;
	/** vfs support */
	GnomeVFSHandle * vfshandle;
	/** the complete filename and path */
	gchar *file_path;
	/** \todo replace these with functions */
	gint16 last_field; /** IF 4 fields, value will be 3 */
	gint16 sort_ct;  /** IF 4 sorts, value will be 4 */
	gint16 filter_ct; /** if 4 filters, value will be 4 */
	gint16 report_ct;  /** if 4 reports, value will be 4 */
	gint32 last_row;
	gboolean changed;
	gint report_no;
	QlFileType file_type; /** .qlf for example */
} QlFileData;

/** \todo Split monolithic QlViewData into views for reports, sort and filters 
wherever possible make the widget pointers local.
*/
typedef struct 
{
	gulong activate_signal;
	gulong new_column_width_signal;
	gulong select_range_signal;
	QlDialogMode dialog_mode;
	/** List or Report */
	QlDisplayMode display_mode;	
	/** in report mode, edit or Print */
	QlDisplayMode report_mode;
	/** Column Row Block Entry */
	QlSelectMode sel_type; 
	GtkSheet *sheet;
	GtkSheet *report_sheet;
	GtkWidget *report_win;
	/** just used from a lot of places - rationalise */
	GtkWidget *text_box;
	/** entry boxes that might be open */
	GtkWidget *entry1;
	GtkWidget *entry2;
	GtkWidget *entry3;
	GtkWidget *entry4;
	GtkWidget *dec_places_label;
	GtkTreeView * tview_from;
	GtkTreeView * tview_to;
	GtkComboBox *sm_numeric_box;
	GtkComboBox *sm_date_box;
	GtkComboBox *sm_time_box;
  
  /** keep track of last cell activated.  It's the only way 
  to tell if it has been changed */
	gint activate_row;
	gint activate_col;
	gchar *activate_text;
	/** \todo put width, height, x and y in gconf */
	gint16 width;
	gint16 height;
	gint16 x;
	gint16 y;
	gchar *current_compare;		/** for find and match */
	gboolean match_on;
	gboolean find_on;
	GtkSheetRange sel_range;
	/** \todo make local to report.c (currently checked by menus) */
	gint report_sel_col;
	gint report_sel_field; /** field that goes with sel_col */
	gint adjust_rows[8];   /** for report adjust window */
	/** \todo find a substitute */
	gchar *cb[MAX_CLIPBOARD];	/** Beginning of clipboard */
	gchar cb_sel_type;
	gint cb_rows;
	gint16 cb_cols;
} QlViewData;

#endif /* _TYPES_H */
