/*
 * QuickPPP by Claudio Leite <static@staticky.com>
 * Modified by Rob Bradford <rbradford@wellington-school.org.uk>
 * Licensed under the GPL
 */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>

void create_chat (void);
void create_options (void);
void finish (void);
void set_nameserver (void);
void test_connection (void);
char buf[4096];

#define MENU "\nPlease choose an option:\n  1 - Create chatscript\n  2 - Create options\n  3 - Set Nameserver\n  4 - Copy files and finish\n  5 - Test connection\n  q - Quit program\n"
int
main (void)
{
  int x;

  if (getuid() != 0)
    {
      fprintf (stderr, "Please run this program only as root!\n");
      return -1;
    }
  setvbuf (stdin, NULL, _IONBF, 0);
  setvbuf (stdout, NULL, _IONBF, 0);
  system ("clear");
  printf ("Welcome to QuickPPP...\n\n");
  printf ("Original QuickPPP by Claudio Leite <static@staticky.com>\n");
  printf ("Modified by Rob Bradford <rbradford@wellington-school.org.uk>");
  printf ("\n");

  printf ("%s", MENU);

  while (1)
    {
      printf ("\nChoice [1/2/3/4/5/h/q]: ");
      fflush (stdout);
      fflush (stdin);
      memset (buf, 0, 4096);
      fgets (buf, 4096, stdin);

      switch (buf[0])
	{
	case '1':
	  create_chat ();
	  break;
	case '2':
	  create_options ();
	  break;
	case '3':
	  set_nameserver ();
	  break;
	case '4':
	  finish ();
	  break;
	case '5':
	  test_connection ();
	  break;
	case 'q':
	case 'Q':
	  exit (0);
	  break;
	case 'h':
	case 'H':
	  printf ("%s", MENU);
	  break;
	}
    }

  return -1;
}

void
create_chat (void)
{
  char *initstr, *phonenum;
  FILE *chatscript;

  printf ("\nChatscript Creator\n\n");
  printf ("Modem's init string (use ATZ if you are unsure): ");
  memset (buf, 0, 4096);
  fgets (buf, 4096, stdin);
  buf[strlen (buf) - 1] = '\0';
  initstr = malloc (strlen (buf) + 1);
  strcpy (initstr, buf);
  printf ("\nNow I need your ISP's phone number.\n");
  printf ("Prefix with a P for pulse dialing, or a T for tone.\n");
  printf ("For example, P222-5555 to dial 222-5555 with pulse.\n");
  printf ("Phone number: ");
  memset (buf, 0, 4096);
  fgets (buf, 4096, stdin);
  buf[strlen (buf) - 1] = '\0';
  phonenum = malloc (strlen (buf) + 1);
  strcpy (phonenum, buf);

  if ((chatscript = fopen ("chatscript", "w")) == NULL)
    {
      fprintf (stderr, "Something is wrong!\n");
      fprintf (stderr, "I can't write to the current directory.\n");
      exit (-1);
    }

  fprintf (chatscript, "ABORT BUSY\nABORT 'NO CARRIER'\n");
  fprintf (chatscript, "'' \"%s\"\n", initstr);
  fprintf (chatscript, "OK \"ATD%s\"\n", phonenum);
  fprintf (chatscript, "CONNECT '\\d\\c'\n");
  fclose (chatscript);
  printf ("File 'chatscript' written to current directory.\n");
  return;
}

void
create_options (void)
{
  FILE *papsecrets, *options;
  char *username, *password, *modem, *chat;

  printf ("\nOptions/pap-secrets Generator\n\n");
  printf ("Your ISP login: ");
  memset (buf, 0, 4096);
  fgets (buf, 4096, stdin);
  buf[strlen (buf) - 1] = '\0';
  username = malloc (strlen (buf) + 1);
  strcpy (username, buf);
  printf ("Your ISP password (will not echo): ");
  memset (buf, 0, 4096);
  password = getpass ("");

  if ((papsecrets = fopen ("pap-secrets", "w")) == NULL)
    {
      fprintf (stderr, "Something is wrong!\n");
      fprintf (stderr, "I can't write to the current directory.\n");
      exit (-1);
    }

  fprintf (papsecrets, "%s\t*\t%s\n", username, password);
  fclose (papsecrets);
  printf ("File 'pap-secrets' written to current directory.\n");

  printf ("\nI need the modem device name now.\n");
  printf ("DOS device\tLinux device\n");
  printf ("COM1\t\t/dev/ttyS0\n");
  printf ("COM2\t\t/dev/ttyS1\n");
  printf ("COM3\t\t/dev/ttyS2\n");
  printf ("COM4\t\t/dev/ttyS3\n\n");
  printf ("Modem device name (ex. /dev/ttyS0): ");
  fgets (buf, 4096, stdin);
  buf[strlen (buf) - 1] = '\0';
  modem = malloc (strlen (buf) + 1);
  strcpy (modem, buf);
  printf ("\nSearching for chat...\n");
  system ("which chat");
  printf ("Path to chat (shown above): ");
  fgets (buf, 4096, stdin);
  buf[strlen (buf) - 1] = '\0';
  chat = malloc (strlen (buf) + 1);
  strcpy (chat, buf);

  if ((options = fopen ("options", "w")) == NULL)
    {
      fprintf (stderr, "Something is wrong!\n");
      fprintf (stderr, "I can't write to the current directory.\n");
      exit (-1);
    }

  fprintf (options, "lock\n");
  fprintf (options, "asyncmap 0\n");
  fprintf (options, "crtscts\n");
  fprintf (options, "modem\n");
  fprintf (options, "defaultroute\n");
  fprintf (options, "user %s\n", username);
  fprintf (options, "%s 115200\n", modem);
  fprintf (options, "connect '%s -t 60 -f /etc/ppp/chatscript'\n", chat);
  fclose (options);
  printf ("File 'options' written to current directory.\n");
  return;
}

void
set_nameserver (void)
{
  FILE *resolvconf;
  char *dnsip;
  int again = 1;


  if ((resolvconf = fopen ("resolv.conf", "w")) == NULL)
    {
      fprintf (stderr, "Something is wrong!\n");
      fprintf (stderr, "I can't write to the current directory.\n");
      exit (-1);
    }

  printf ("\nSetting up DNS server.\n\n");
  do
    {
      printf ("Enter your ISP's nameserver IP: ");
      fgets (buf, 4096, stdin);
      buf[strlen (buf) - 1] = '\0';
      dnsip = malloc (strlen (buf) + 1);
      strcpy (dnsip, buf);

      fprintf (resolvconf, "nameserver %s\n", dnsip);

      printf ("Enter another [y/N]? ");
      fgets (buf, 10, stdin);
      if (buf[0] == 'Y' || buf[0] == 'y')
	again = 1;
      else
	again = 0;
    }
  while (again == 1);

  fclose (resolvconf);
  printf ("File 'resolv.conf' written to current directory.\n");
  return;
}

// Code moved from set_nameserver() to new function

void
finish (void)
{

  printf ("\nCopying files to /etc/ppp...");
  system ("mkdir -p /etc/ppp");
  system ("mv -f chatscript options pap-secrets /etc/ppp");
  system ("cp -f /etc/ppp/pap-secrets /etc/ppp/chap-secrets");
  system ("mv -f resolv.conf /etc/resolv.conf");
  system ("chmod 600 /etc/ppp/pap-secrets /etc/ppp/chap-secrets");
  printf (" done.\n");
  printf ("You may now select test connection from the menu and run pppd.\n");
  return;
}

void
test_connection (void)
{

  printf ("\nTesting connection, (running pppd)");
  printf ("\nIf not connected in 60 seconds, check your parameters.\n");
  system ("pppd");

}
