/*
 * Mike Glover
 * mpg4@duluoz.net
 *
 * Johan Ekenberg
 * johan@ekenberg.nu
 *
 * quota.h
 * middle layer to talk to quotactl
 */
#ifndef INCLUDE_QUOTATOOL_QUOTA
#define INCLUDE_QUOTATOOL_QUOTA

#include <config.h>

#if HAVE_LINUX_VERSION_H
#include <linux/version.h>
#  if LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,0)
#    define LINUX_2_4
#  endif
#endif

#if HAVE_LINUX_QUOTA_H
#  include <linux/types.h>
#  include <linux/quota.h>
#  define QUOTA_USER  USRQUOTA + 1
#  define QUOTA_GROUP GRPQUOTA + 1
#elif HAVE_SYS_FS_UFS_QUOTA_H
#  include <sys/types.h>
#  include <sys/fs/ufs_quota.h>
#  define QUOTA_USER 1
#  define QUOTA_GROUP 2
#elif HAVE_JFS_QUOTA_H
#  include <sys/types.h>
#  include <jfs/quota.h>
#  define QUOTA_USER  USRQUOTA + 1
#  define QUOTA_GROUP GRPQUOTA + 1
#else
#  error "no quota headers found"
#endif

#ifdef LINUX_2_4
struct _quota_t {
  uint    inode_hard;
  uint    inode_soft;
  uint    inode_used;
  uint    block_hard;
  uint    block_soft;
  qsize_t block_used;
  time_t  block_grace;
  time_t  inode_grace;
  int     _id;
  int     _id_type;
  char *  _qfile;
};
#else
struct _quota_t {
  uint    block_hard;
  uint    block_soft;
  uint    block_used;
  uint    inode_hard;
  uint    inode_soft;
  uint    inode_used;
  time_t  block_grace;
  time_t  inode_grace;
  int     _id;
  int     _id_type;
  char *  _qfile;
};
#endif
typedef struct _quota_t quota_t;


quota_t *   quota_new     (int q_type, int id, char *device);
void        quota_delete  (quota_t *myquota);

int         quota_get     (quota_t *myquota);
int         quota_set     (quota_t *myquota);



#endif /* INCLUDE_QUOTATOOL_QUOTA */


