/*
 * Parser input using a buffer as input
 *
 * Copyright (C) 2003-2006  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <tagcoll/MemParserInput.h>

using namespace std;

namespace Tagcoll {

MemParserInput::MemParserInput(const std::string& fname, const char* buf, int len) throw ()
	: fname(fname), buf(buf), pos(0), len(len), _line(1) {}

MemParserInput::MemParserInput(const char* buf, int len) throw ()
	: fname("<memory>"), buf(buf), pos(0), len(len), _line(1) {}

int MemParserInput::nextChar() throw ()
{
	if (pos == len)
		return ParserInput::Eof;
	
	if (buf[pos] == '\n')
		_line++;
	return buf[pos++];
}

void MemParserInput::pushChar(int c) throw ()
{
	pos--;
}

}

// vim:set ts=4 sw=4:
