#!/usr/bin/env wish

# Script to install taglog - this is under development.
# Inoke as wish install.tcl (for Unix) or by clicking on the install icon
#  (for Windows)

proc do_install {} {
global bindir taglogbin libfiles libdir docdir helpfiles msgfiles mandir man1files man3files removeold

#
if { ! [ file isdirectory $bindir ] } {
  file mkdir $bindir
}

file copy -force taglog $taglogbin
#puts "Installed taglog into $taglogbin"

if { ! [ file isdirectory $libdir ] } {
  file mkdir $libdir
}

foreach libfile $libfiles {
 file copy -force $libfile $libdir
}
#puts "Installed library files into $libdir"

# set up package index
file copy -force pkgIndex.tcl $libdir

if { $removeold } {
 file delete $bindir/taglog_help.tcl
 # we might want to delete other old library files
 }

foreach helpfile $helpfiles {
 file copy -force $helpfile $libdir
}

foreach msgfile $msgfiles {
 file copy -force $msgfile $libdir
 }

if { $mandir != "" } {
 foreach man1file $man1files {
 file copy -force $man1file $mandir/man1
 }
 foreach man3file $man3files {
 file copy -force $man3file $mandir/man3
 }
}

# Copy the documentation files (everything in the doc directory)

foreach docfile [ glob doc/* ] {
 if { $docfile != "INSTALL" } {
file copy -force $docfile $docdir
 }
}

exit
}

proc setup_display {} {
global bindir taglogbin libfiles libdir docdir removeold

wm title . "Install Taglog"


frame .bindir
label .bindir.l -text "Binary Directory"
entry .bindir.e -textvariable bindir -width 20
pack .bindir.l .bindir.e -side left -in .bindir
pack .bindir

frame .taglogbin
label .taglogbin.l -text "Taglog executable"
entry .taglogbin.e -textvariable taglogbin -width 30
pack .taglogbin.l .taglogbin.e -side left -in .taglogbin
pack .taglogbin

frame .libdir
label .libdir.l -text "Library Directory"
entry .libdir.e -textvariable  libdir -width 30
pack .libdir.l .libdir.e -side left -in .libdir
pack .libdir

frame .docdir
label .docdir.l -text "Documentation Directory"
entry .docdir.e -textvariable docdir -width 30
pack .docdir.l .docdir.e -side left -in .docdir

# For the case where the library files have moved we want to issue a
# warning (and remove the old files
set removeold 0
if { $bindir != $libdir } {
  if { [file readable $bindir/taglog_help.tcl] } {

if {[tk_messageBox -icon warning -title "Library has moved" -message \
 "The library files are now in $libdir - the old taglog_help.tcl has been removed - you may wish to tidy up the other files in $bindir" \
 -type yesno] == "yes"} {
 set removeold 1
 } else {
 exit
 }

}
}


frame .bot
button .bot.ok -text OK -command do_install
button .bot.cancel -text Cancel -command exit
pack .bot.ok .bot.cancel -in .bot -side left
pack .bot

tkwait window .
}


global bindir taglogbin libfiles libdir argv docdir helpfiles destdir mandir removeold

set quiet 0
set debian 0
set system 0
set destdir ""
set mandir ""


for { set i 0 } { $i < [llength $argv] } { incr i } {
set arg [lindex $argv $i]
 if { $arg == "-quiet" } {
	set quiet 1
 } elseif { $arg == "-debian" } {
	set debian 1
	set quiet 1
	incr i
	set destdir [lindex $argv $i]

 } elseif { $arg == "-system" } {
 	set system 1
 	set quiet 1
 } else {
 	error "Unknown argument $arg"
} 	
}


# It only deals with the install as normal user under Unix at present.
# amd possibly under Windows.

set removeold 0

if { $tcl_platform(platform) == "unix" } {
# Work out where the wish executable is.

set wishexec [info nameofexecutable]
# if { $tcl_platform(user) == "root" } 
 if { $system } {

 # Install into /usr/local by default
 set instroot "/usr/local"
 set libdir "$instroot/lib/taglog"
 set bindir "$instroot/bin"
 set docdir "$instroot/doc/taglog"
 set mandir "$instroot/man"
set taglogbin $bindir/taglog
  } elseif { $debian } {
  set libdir "$destdir/usr/lib/taglog"
  set bindir "$destdir/usr/bin"
  set docdir "$destdir/usr/share/doc/taglog"
  set mandir "$destdir/usr/share/man"
  set taglogbin $destdir/usr/bin/taglog

  } else {
# Unix non-root install

set libdir "~/lib/taglog"
set bindir "~/bin"
set docdir "~/bin"

set mandir "~/bin"
set taglogbin $bindir/taglog
}

} elseif { $tcl_platform(platform) == "windows" } {

set libdir "C:/Program Files/taglog"
set bindir $libdir
set docdir $libdir
set mandir $libdir

set taglogbin $bindir/taglog.tcl

} else {
 error "Unknown platform $tcl_platform(platform) - cant automatically install"
}

set libfiles { tag.tcl taglog_action.tcl taglog_report.tcl taglog_init.tcl smtp.tcl taglog_help.tcl taglog_contact.tcl taglog_util.tcl taglog_project.tcl cal2.xbm logEdit.tcl taglog_widgets.tcl mainwin.tcl }
set binfiles { taglog }
set helpfiles { taglog_help_en.tag taglog_help_de.tag }
set msgfiles { de.msg }
set man1files { taglog.1 }
set man3files { tag.3 }


if { $quiet } {
 do_install
 } else {
 setup_display
 }

exit
