#!/usr/bin/env python

#############################################################################
##
## This file is part of Taurus, a Tango User Interface Library
##
## http://www.tango-controls.org/static/taurus/latest/doc/html/index.html
##
## Copyright 2011 CELLS / ALBA Synchrotron, Bellaterra, Spain
##
## Taurus is free software: you can redistribute it and/or modify
## it under the terms of the GNU Lesser General Public License as published by
## the Free Software Foundation, either version 3 of the License, or
## (at your option) any later version.
##
## Taurus is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU Lesser General Public License for more details.
##
## You should have received a copy of the GNU Lesser General Public License
## along with Taurus.  If not, see <http://www.gnu.org/licenses/>.
##
#############################################################################

"""This module provides base table widget"""

__all__ = ["QBaseTableWidget"]

__docformat__ = 'restructuredtext'

from taurus.external.qt import Qt
from taurus.qt.qtgui.model import QBaseModelWidget


class QBaseTableWidget(QBaseModelWidget):

    def tableView(self):
        return self.viewWidget()

    def createViewWidget(self, klass=None):
        if klass is None:
            klass = Qt.QTableView
        table = klass()
        table.setSortingEnabled(True)
        table.sortByColumn(0, Qt.Qt.AscendingOrder)
        table.setAlternatingRowColors(True)
        table.setSelectionBehavior(Qt.QAbstractItemView.SelectRows)
        table.setSelectionMode(Qt.QAbstractItemView.ExtendedSelection)
        return table
