#ifndef TEATIME_H__
#define TEATIME_H__

#include <gtk/gtk.h>
#include <pango/pango.h>
#include <panel-applet.h>
#include <gst/gst.h>
#include <gst/gconf/gconf.h>

#define FRAMES  3
#define TEACUPS 3

#define ROT_FRAMES  24
#define CUP_WIDTH  128
#define CUP_HEIGHT  96


static gchar *teacups[] = {
  "cup_classic",
  "cup_glass",
  "mug_soeren"
};

typedef struct{
  gboolean visible;
  
  /* label vars */
  GtkWidget *label_window;
  PangoLayout *layout;
  gint label_width;
  gint label_height;
  
  /*cup vars */
  GtkWidget *cup_window;
  GtkWidget *image[ROT_FRAMES];
  GdkBitmap *bitmap[ROT_FRAMES];
  guint timer_handle;
  gint frame;
}TeatimePopup;

typedef struct{
  GstElement *thread;
  GstElement *input;
  GstElement *decoder;
  GstElement *output;
}TeatimeSound;

typedef struct{
  GSList *teas ;
  GSList *times;
  gint num_teas;
  gint *drawing_times;
  gchar **tea_names;

  gboolean popup;
  gboolean show_clock;
  gint last_tea;
  
  gint cup;
  GdkPixbuf *teacups[TEACUPS];

  gboolean play_sound;
  gchar *sound;
}TeatimeProperties;

typedef struct{
  PanelApplet *applet;
  GtkWidget *border;
  GtkWidget *area;
  gint size;
  gboolean orient_vert;
  GtkTooltips *tooltip;
  GdkPixbuf *cup_empty;
  GdkPixbuf *cup_empty_hl;
  GdkPixbuf *cup_full[FRAMES];
  GdkPixbuf *cup_full_hl[FRAMES];

  GdkGC *clock_gc;

  gboolean full;
  gboolean highlight;
  gint frame;
  gint time_left;
  guint timer_handle;

  gint last_tea;
  gint drawing_time;
  
  gchar *icon_path;

  GtkWidget *pref_dialog;
  GtkWidget *pref_cup[TEACUPS];
  GtkWidget *pref_cup_button[TEACUPS];
  
  TeatimeProperties properties;
  TeatimeSound sound;
  TeatimePopup popup;
}Teatime;


void teatime_applet_redraw (Teatime *teatime);
void teatime_set_menu      (Teatime *teatime);

#endif

