/************************************************************************/
/*									*/
/*  Calculate 'Symbol' fields.						*/
/*									*/
/************************************************************************/

#   include	"tedConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<appDebugon.h>

#   include	<appUnit.h>
#   include	"docBuf.h"
#   include	"docEvalField.h"

/************************************************************************/
/*									*/
/*  Format the value of a 'symbol' field.				*/
/*									*/
/************************************************************************/

int docCalculateSymbolFieldString(	int *			pCalculated,
					int *			pNewSize,
					unsigned char *		target,
					int			targetSize,
					BufferDocument *	bd,
					const BufferItem *	paraBi,
					int			part,
					int			partCount,
					const DocumentField *	df )
    {
    const char *	fontName;
    int			fontSize;
    const char *	symbName;
    int			symbSize;
    const char *	sizeString;
    int			sizeSize;

    char *		past;
    int			symb;

    if  ( docFieldGetSymbol( df, &fontName, &fontSize,
			    &symbName, &symbSize, &sizeString, &sizeSize ) )
	{ LDEB(1); *pCalculated= 0; return 0;	}

    if  ( symbSize < 1 )
	{ LDEB(symbSize); *pCalculated= 0; return 0;	}

    symb= strtol( symbName, &past, 0 );

    if  ( symb < 1 || symb > 255 )
	{ LDEB(symb); *pCalculated= 0; return 0;	}

    target[0]= symb;
    target[1]= '\0';

    *pNewSize= strlen( (char *)target );
    *pCalculated= 1;
    return 0;
    }

/************************************************************************/
/*									*/
/*  Evaluate Footnote number fields.					*/
/*									*/
/************************************************************************/

int docRecalculateParaSymbolTextParticules(
				int *				pCalculated,
				BufferDocument *		bd,
				int *				pPartShift,
				int *				pStroffShift,
				BufferItem *			bi,
				int				part,
				int				partCount,
				DocumentField *			df,
				void *				voidadd,
				DOC_CLOSE_OBJECT		closeObject )
    {
    int				ret;

    const char *		fontName;
    int				fontSize;
    const char *		symbName;
    int				symbSize;
    const char *		sizeString;
    int				sizeSize;

    char *			allocated= (char *)0;

    int				fontNumber= -1;
    int				fontSizeHalfPoints= -1;

    DocumentProperties *	dp= &(bd->bdProperties);

    if  ( docFieldGetSymbol( df, &fontName, &fontSize,
			    &symbName, &symbSize, &sizeString, &sizeSize ) )
	{ LDEB(1); *pCalculated= 0; return 0;	}

    ret= docRecalculateParaStringTextParticules( pCalculated, bd,
			    pPartShift, pStroffShift, bi, part, partCount,
			    df, voidadd, closeObject );

    if  ( ret )
	{ LDEB(ret); return ret;	}

    if  ( *pCalculated )
	{
	TextParticule *		tp;
	int			i;

	const int		encoding= -1;
	const int		encodingIsDefault= 1;

	if  ( fontSize > 0 )
	    {
	    allocated= malloc( fontSize+ 1 );
	    if  ( ! allocated )
		{ LXDEB(fontSize,allocated); return -1;	}

	    strncpy( allocated, fontName, fontSize )[fontSize]= '\0';

	    fontNumber= docGetFontByName( &(dp->dpFontList), allocated, 
						encoding, encodingIsDefault );
	    if  ( fontNumber < 0 )
		{ SLDEB(allocated,fontNumber);	}
	    }

	if  ( sizeSize > 0 )
	    {
	    char *	past;

	    fontSizeHalfPoints= strtol( sizeString, &past, 10 );

	    if  ( fontSizeHalfPoints > 0 )
		{ fontSizeHalfPoints *= 2;	}
	    }

	tp= bi->biParaParticules+ part+ 1;
	for ( i= 0; i < partCount+ *pPartShift; tp++, i++ )
	    {
	    if  ( fontNumber >= 0 )
		{
		tp->tpTextAttribute.taFontNumber= fontNumber;
		tp->tpPhysicalFont= -1;
		}
	    if  ( fontSizeHalfPoints >= 0 )
		{
		tp->tpTextAttribute.taFontSizeHalfPoints= fontSizeHalfPoints;
		tp->tpPhysicalFont= -1;
		}
	    }
	}

    if  ( allocated )
	{ free( allocated );	}

    return ret;
    }
