#   include	"appFrameConfig.h"

#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<appDebugon.h>

#   include	"appFrame.h"
#   include	"appSystem.h"
#   include	<appGeoString.h>

#   ifdef USE_MOTIF

#   include	<Xm/PanedW.h>
#   include	<Xm/Form.h>

void appInspectorMakePageParent(	AppInspector *	ai )
    {
    Arg			al[20];
    int			ac= 0;

    ac= 0;
    XtSetArg( al[ac],	XmNallowResize,		True ); ac++;
    XtSetArg( al[ac],	XmNskipAdjust,		False ); ac++;
    ai->aiPageParent= XmCreateForm( ai->aiPaned, WIDGET_NAME, al, ac );

    XtManageChild( ai->aiPageParent );

    appMotifTurnOfSashTraversal( ai->aiPaned );

    return;
    }

void appInspectorChoosePage(	AppInspector *		ai,
				int			andMenu,
				int			pageNumber )
    {
    WidgetList		children;
    Cardinal		childCount= 0;

    int			i;

    childCount= 0;
    XtVaGetValues( ai->aiPageParent,
		    XmNchildren,	&children,
		    XmNnumChildren,	&childCount,
		    NULL );

    for ( i= 0; i < childCount; i++ )
	{
	XtVaSetValues( children[i],
			XmNmappedWhenManaged, i == pageNumber,
			NULL );
	}

    if  ( andMenu )
	{ appSetOptionmenu( &(ai->aiSubjectOptionmenu), pageNumber );	}

    return;
    }

static void appInspectorPageChosen(	APP_WIDGET	w,
					void *		vai,
					void *		call_data )
    {
    AppInspector *	ai= (AppInspector *)vai;

    short		pageNumber= -1;

    const int		andMenu= False;

    XtVaGetValues( w,
		    XmNpositionIndex,	&pageNumber,
		    NULL );

    if  ( pageNumber < 0 )
	{ LDEB(pageNumber); return;	}

    appInspectorChoosePage( ai, andMenu, pageNumber );

    ai->aiCurrentSubject= pageNumber;

    return;
    }

void appMakeVerticalInspectorPage(	APP_WIDGET *	pPage,
					APP_WIDGET *	pMenuitem,
					AppInspector *	ai,
					const char *	label )
    {
    Widget		item;
    Widget		page;

    Arg			al[20];
    int			ac= 0;

    ac= 0;
    XtSetArg( al[ac],	XmNleftAttachment,	XmATTACH_FORM ); ac++;
    XtSetArg( al[ac],	XmNrightAttachment,	XmATTACH_FORM ); ac++;
    XtSetArg( al[ac],	XmNtopAttachment,	XmATTACH_FORM ); ac++;
    XtSetArg( al[ac],	XmNbottomAttachment,	XmATTACH_FORM ); ac++;

    XtSetArg( al[ac],	XmNsashWidth,		1 ); ac++;
    XtSetArg( al[ac],	XmNsashHeight,		1 ); ac++;
    XtSetArg( al[ac],	XmNseparatorOn,		False ); ac++;
    XtSetArg( al[ac],	XmNmarginWidth,		5 ); ac++;
    XtSetArg( al[ac],	XmNmarginHeight,	5 ); ac++;
    XtSetArg( al[ac],	XmNspacing,		5 ); ac++;

    page= XmCreatePanedWindow( ai->aiPageParent, WIDGET_NAME, al, ac );
    XtManageChild( page );

    item= appAddItemToOptionmenu( &(ai->aiSubjectOptionmenu), label,
				    appInspectorPageChosen, (void *)ai );

    *pPage= page; *pMenuitem= item; return;
    }

void appInspectorEnablePage(	AppInspector *	ai,
				int		pageNumber,
				int		enabled )
    {
    WidgetList		children;
    Cardinal		childCount= 0;

    childCount= 0;
    XtVaGetValues( ai->aiSubjectOptionmenu.aomPulldown,
		    XmNchildren,	&children,
		    XmNnumChildren,	&childCount,
		    NULL );

    if  ( pageNumber < 0 || pageNumber >= childCount )
	{ LLDEB(pageNumber,childCount);				}
    else{ XtSetSensitive( children[pageNumber], enabled != 0 );	}

    childCount= 0;
    XtVaGetValues( ai->aiPageParent,
		    XmNchildren,	&children,
		    XmNnumChildren,	&childCount,
		    NULL );

    if  ( pageNumber < 0 || pageNumber >= childCount )
	{ LLDEB(pageNumber,childCount);				}
    else{ XtSetSensitive( children[pageNumber], enabled != 0 );	}

    return;
    }

#   endif /*  USE_MOTIF	*/
