/*	$Id: g_scores.c,v 1.6 2001/12/21 22:10:01 riq Exp $	*/
/* Tenes Empanadas Graciela
 *
 * Copyright (C) 2000 Ricardo Quesada
 *
 * Author: Ricardo Calixto Quesada <rquesada@core-sdi.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; only version 2 of the License
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
/**
 * @file gui_scores.c
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <assert.h>
#include <gnome.h>

#include "gui.h"
#include "client.h"
#include "support.h"
#include "interface.h"
#include "callbacks.h"
#include "g_scores.h"
#include "colors.h"


#define HELVETICA_20_BFONT "-adobe-helvetica-bold-r-normal-*-20-*-*-*-*-*-*-*"
#define HELVETICA_18_FONT  "-adobe-helvetica-medium-r-normal-*-18-*-*-*-*-*-*-*"
#define HELVETICA_16_FONT  "-adobe-helvetica-medium-r-normal-*-16-*-*-*-*-*-*-*"
#define HELVETICA_14_BFONT "-adobe-helvetica-bold-r-normal-*-14-*-*-*-*-*-*-*"
#define HELVETICA_14_FONT  "-adobe-helvetica-medium-r-normal-*-14-*-*-*-*-*-*-*"
#define HELVETICA_12_BFONT "-adobe-helvetica-bold-r-normal-*-12-*-*-*-*-*-*-*"
#define HELVETICA_12_FONT  "-adobe-helvetica-medium-r-normal-*-12-*-*-*-*-*-*-*"
#define HELVETICA_10_FONT  "-adobe-helvetica-medium-r-normal-*-10-*-*-*-*-*-*-*"


static GtkWidget *gui_scores_dialog=NULL;
static int linesindisplay=0;

enum {
	SCORE_CLIST_POS,
	SCORE_CLIST_SCORE,
	SCORE_CLIST_NAME,
	SCORE_CLIST_DATE,
	SCORE_CLIST_COLOR,
	SCORE_CLIST_HUMAN,

	SCORE_CLIST_LAST
};

static gint boton_clicked_refresh(GtkWidget *area, GdkEventExpose *event, gpointer user_data)
{
	out_scores();
	return FALSE;
}

/*
 * helper funcion used by mini_scores & big score
 */
static TEG_STATUS paint_color( GtkWidget *dialog, int color, GdkPixmap **pixmap )
{
	int i, h, w;

	assert( pixmap );

	i = (color<0 || color>=TEG_MAX_PLAYERS) ? TEG_MAX_PLAYERS : color;

	*pixmap = gdk_pixmap_new( dialog->window,
		48, 16, gtk_widget_get_visual( dialog)->depth);

	if( *pixmap == NULL )
		return TEG_STATUS_ERROR;

	gdk_gc_set_foreground(g_colors_gc, colors_get_player_from_color(color));
	gdk_draw_rectangle( *pixmap, g_colors_gc, TRUE, 0, 0, 47, 15);

	gdk_gc_set_foreground(g_colors_gc, colors_get_common(COLORS_BLACK));
	gdk_draw_rectangle( *pixmap, g_colors_gc, FALSE, 0, 0, 47, 15);

	gdk_gc_set_foreground(g_colors_gc, colors_get_player_ink_from_color(color));


	h = gdk_string_height (g_pixmap_font10, _(g_colores[i]) );
	w = gdk_string_width  (g_pixmap_font10, _(g_colores[i]) );

	gdk_draw_string( *pixmap, g_pixmap_font10, g_colors_gc, 
			((48 - w )/2),
			((16 - h)/2) + h, _(g_colores[i]));
	return TEG_STATUS_SUCCESS;
}


static TEG_STATUS update_clist( GtkWidget *clist )
{
#define S_CLIST_MAX (100)
	PLIST_ENTRY list = scores_get_list();
	PLIST_ENTRY l = list->Flink;
	PSCORES pS;
	char clist_text[SCORE_CLIST_LAST][S_CLIST_MAX];
	char *clist_texts[SCORE_CLIST_LAST];
	int i, row;
	GdkPixmap *pixmap;

	gtk_clist_freeze(GTK_CLIST(clist));

	for(i=0;i<SCORE_CLIST_LAST;i++) {
		clist_texts[i] = clist_text[i];
		memset( clist_text[i],0,S_CLIST_MAX);
	}

	row = 0;
	while( !IsListEmpty( list )&& (l != list ) ) {
		pS = (PSCORES) l;

		/* sprintf(clist_texts[0],"%s",g_colores[j->color]); */
		snprintf(clist_texts[SCORE_CLIST_POS],S_CLIST_MAX-1,"%d",row+1);
		snprintf(clist_texts[SCORE_CLIST_SCORE],S_CLIST_MAX-1,"%d",pS->stats.score);
		snprintf(clist_texts[SCORE_CLIST_NAME],S_CLIST_MAX-1,"%s",pS->name);
		snprintf(clist_texts[SCORE_CLIST_DATE],S_CLIST_MAX-1,"%s",pS->date);
		snprintf(clist_texts[SCORE_CLIST_HUMAN],S_CLIST_MAX-1,"%s",(pS->human ? _("yes") : _("no")));

		if (linesindisplay-1 < row) {
			gtk_clist_append (GTK_CLIST (clist), clist_texts);
			linesindisplay++;
		}
		else {
	 		for(i=1;i<SCORE_CLIST_LAST;i++)
	   			gtk_clist_set_text(GTK_CLIST (clist), row, i, clist_texts[i]);
		}

		if( paint_color( gui_scores_dialog, pS->color, &pixmap ) == TEG_STATUS_SUCCESS )
			gtk_clist_set_pixmap(GTK_CLIST(clist), row, SCORE_CLIST_COLOR, pixmap, NULL);

		l = LIST_NEXT(l);
		row ++;
	}
	while (linesindisplay > row)
		gtk_clist_remove(GTK_CLIST(clist), --linesindisplay);
	gtk_clist_thaw(GTK_CLIST(clist));

	gtk_widget_show (clist);

	return TEG_STATUS_SUCCESS;
}

static TEG_STATUS update_dialog()
{
	int i;
	static GtkWidget *scores_clist=NULL;
	char *titles[SCORE_CLIST_LAST] = {
		_("Number"), _("Score"),_("Name"),_("Date"), _("Color"), _("Human")
	};

	if( gui_scores_dialog == NULL )
		return TEG_STATUS_ERROR;


	if( scores_clist == NULL ) {
		scores_clist = gtk_clist_new_with_titles (SCORE_CLIST_LAST, titles);

		gtk_clist_set_selection_mode (GTK_CLIST (scores_clist), GTK_SELECTION_EXTENDED);
		for (i = 0; i < SCORE_CLIST_LAST; i++) {
			gtk_clist_set_column_justification (GTK_CLIST (scores_clist), i, GTK_JUSTIFY_CENTER);
			gtk_clist_set_column_auto_resize (GTK_CLIST (scores_clist), i, TRUE);
		}
		linesindisplay = 0;

		gtk_box_pack_start_defaults( GTK_BOX(GNOME_DIALOG(gui_scores_dialog)->vbox), GTK_WIDGET(scores_clist));
	}

	update_clist( scores_clist);


	return TEG_STATUS_SUCCESS;
}

void gui_scores_view()
{
	if( gui_scores_dialog == NULL) {

		gui_scores_dialog = teg_dialog_new(_("High Scores"),_("High Scores")); 
		gnome_dialog_append_buttons(GNOME_DIALOG(gui_scores_dialog),
				GNOME_STOCK_PIXMAP_REFRESH,
				GNOME_STOCK_BUTTON_CLOSE,
				NULL );
		gnome_dialog_close_hides( GNOME_DIALOG(gui_scores_dialog), TRUE );
		gnome_dialog_set_default(GNOME_DIALOG(gui_scores_dialog),1);

		/* signals de los botones */
		gnome_dialog_button_connect (GNOME_DIALOG(gui_scores_dialog),
						0, GTK_SIGNAL_FUNC(boton_clicked_refresh),gui_scores_dialog);
		gnome_dialog_button_connect (GNOME_DIALOG(gui_scores_dialog),
						1, GTK_SIGNAL_FUNC(dialog_close), gui_scores_dialog );

		gnome_dialog_set_default( GNOME_DIALOG(gui_scores_dialog),1);
	}

	update_dialog();

	gtk_widget_show_all( gui_scores_dialog);
	raise_and_focus( gui_scores_dialog);
}


/*******************************
 *                             *
 *       embeded scores        *
 *                             *
 *******************************/

enum {
	MINISCORE_CLIST_NAME,
	MINISCORE_CLIST_SCORE,
	MINISCORE_CLIST_COLOR,

	MINISCORE_CLIST_LAST
};
static TEG_STATUS update_mini_clist( GtkWidget *dialog, GtkWidget *clist )
{
	PLIST_ENTRY list = &g_list_jugador;
	PLIST_ENTRY l = list->Flink;
	PJUGADOR pJ;
	char clist_text[MINISCORE_CLIST_LAST][S_CLIST_MAX];
	char *clist_texts[MINISCORE_CLIST_LAST];
	int i, row;
	GdkPixmap *pixmap;

	gtk_clist_freeze(GTK_CLIST(clist));

	for(i=0;i<MINISCORE_CLIST_LAST;i++) {
		clist_texts[i] = clist_text[i];
		memset( clist_text[i],0,S_CLIST_MAX);
	}

	row = 0;
	while( !IsListEmpty( list )&& (l != list ) ) {
		pJ = (PJUGADOR) l;

		snprintf(clist_texts[MINISCORE_CLIST_NAME],S_CLIST_MAX-1,"%s",pJ->nombre);
		snprintf(clist_texts[MINISCORE_CLIST_SCORE],S_CLIST_MAX-1,"%d",pJ->score);

		gtk_clist_append (GTK_CLIST (clist), clist_texts);

		if( paint_color( dialog, pJ->color, &pixmap ) == TEG_STATUS_SUCCESS )
			gtk_clist_set_pixmap(GTK_CLIST(clist), row, MINISCORE_CLIST_COLOR, pixmap, NULL);

		l = LIST_NEXT(l);
		row ++;
	}
	gtk_clist_thaw(GTK_CLIST(clist));

	gtk_widget_show (clist);

	return TEG_STATUS_SUCCESS;
}

void gui_scores_embed( GtkWidget *frame )
{
	int i;
	static GtkWidget *mini_scores_clist=NULL;
	char *titles[MINISCORE_CLIST_LAST] = {
		_("Name"), _("Score"), _("Color"),
	};

	mini_scores_clist = gtk_clist_new_with_titles (MINISCORE_CLIST_LAST, titles);

	gtk_clist_set_selection_mode (GTK_CLIST (mini_scores_clist), GTK_SELECTION_EXTENDED);
	for (i = 0; i < MINISCORE_CLIST_LAST; i++) {
		gtk_clist_set_column_justification (GTK_CLIST (mini_scores_clist), i, GTK_JUSTIFY_CENTER);
		gtk_clist_set_column_auto_resize (GTK_CLIST (mini_scores_clist), i, TRUE);
	}

	update_mini_clist( frame, mini_scores_clist );

	gtk_container_add (GTK_CONTAINER (frame),GTK_WIDGET(mini_scores_clist));
}
