#ifdef __GNUC__
#  pragma implementation "image.H"
#endif

#include <string.h>
#include <iostream.h>
#include <fstream.h>
#include <strstream.h>
#include <stdlib.h>
#include <stdio.h>
#include "image.H"

void Timage::from(int W, int H)
{
	w = W;
	h = H;
	const int n = w*h;
	ptr = new unsigned int [n];
}

void Timage::from(const Timage& X)
{
	w = X.w;
	h = X.h;
	if (X.ptr) {
		const int n = w*h;
		ptr = new unsigned int [n];
		memcpy(ptr,X.ptr,sizeof(unsigned int)*n);
	} else {
		ptr = 0;
	}
}

void Timage::xv() const
{
	if (!ptr) return;
	char fn[FILENAME_MAX];
	tmpnam(fn);
	ofstream o(fn);
	cout << "Doing xv with h=" << h << ", w=" << w << "\n";
	o << "P6\n" << "# Created by image.C\n" << w << " " << h << " 255\n";
	int i,j;
	for (i=0; i<h; i++) for (j=0; j<w; j++) {
		const int p = flatindex(i,j);
		o.put(red(i,j));
		o.put(green(i,j));
		o.put(blue(i,j));
	}
	o.close();
	strstream s;
	s << "(xv " << fn << "; rm -f " << fn << ")& " << ends;
	char *charptr = s.str();
	system(charptr);
	delete [] charptr;
}

void Timage::free()
{
	if (ptr) {
		delete [] ptr;
	}
	w = h = 0;
	ptr = 0;
}


