
/*
 * stream-engine.h - proxy for telepathy-stream-engine's D-Bus API
 *
 * Copyright (C) 2007-2008 Collabora Ltd. <http://www.collabora.co.uk/>
 * Copyright (C) 2007-2008 Nokia Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TI_STREAM_ENGINE_H__
#define __TI_STREAM_ENGINE_H__

#include <telepathy-glib/proxy.h>

G_BEGIN_DECLS

#define TI_STREAM_ENGINE_BUS_NAME \
  "org.freedesktop.Telepathy.StreamEngine"
#define TI_STREAM_ENGINE_OBJECT_PATH \
  "/org/freedesktop/Telepathy/StreamEngine"

typedef struct _TIStreamEngine TIStreamEngine;
typedef struct _TIStreamEngineClass TIStreamEngineClass;
typedef struct _TIStreamEnginePrivate TIStreamEnginePrivate;

struct _TIStreamEngine {
    TpProxy parent;
    /*<private>*/
    TIStreamEnginePrivate *priv;
};

struct _TIStreamEngineClass {
    TpProxyClass parent_class;
    /*<private>*/
    gpointer priv;
};

GType ti_stream_engine_get_type (void);

#define TI_TYPE_STREAM_ENGINE \
  (ti_stream_engine_get_type ())
#define TI_STREAM_ENGINE(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), TI_TYPE_STREAM_ENGINE, \
                               TIStreamEngine))
#define TI_STREAM_ENGINE_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), TI_TYPE_STREAM_ENGINE, \
                            TIStreamEngineClass))
#define TI_IS_STREAM_ENGINE(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TI_TYPE_STREAM_ENGINE))
#define TI_IS_STREAM_ENGINE_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), TI_TYPE_STREAM_ENGINE))
#define TI_STREAM_ENGINE_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), TI_TYPE_STREAM_ENGINE, \
                              TIStreamEngineClass))

TIStreamEngine *ti_stream_engine_new (TpDBusDaemon *dbus);

G_END_DECLS

#include "extensions/_gen/cli-stream-engine.h"

#endif
