/*
 * Telepathy Inspector - A Telepathy client which exposes Telepathy interfaces.
 *                       Meant to inspect and/or test connection managers.
 *
 * ti-dlg-hold-handles.h:
 * Dialog for [...].Telepathy.Connection.HoldHandles() method.
 *
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia
 * Author - Daniel d'Andrada T. de Carvalho <daniel.carvalho@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef __TI_DLG_HOLD_HANDLES_H__
#define __TI_DLG_HOLD_HANDLES_H__

#include <gtk/gtk.h>

/*
 * Type macros.
 */

typedef struct _TIDlgHoldHandles TIDlgHoldHandles;
typedef struct _TIDlgHoldHandlesClass TIDlgHoldHandlesClass;

#define TI_TYPE_DLG_HOLD_HANDLES               ti_dlg_hold_handles_get_type()
#define TI_DLG_HOLD_HANDLES(object)            (G_TYPE_CHECK_INSTANCE_CAST ((object), TI_TYPE_DLG_HOLD_HANDLES, TIDlgHoldHandles))
#define TI_DLG_HOLD_HANDLES_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), TI_TYPE_DLG_HOLD_HANDLES, TIDlgHoldHandlesClass))
#define TI_IS_DLG_HOLD_HANDLES(object)         (G_TYPE_CHECK_INSTANCE_TYPE ((object), TI_TYPE_DLG_HOLD_HANDLES))
#define TI_IS_DLG_HOLD_HANDLES_CLASS(klass)    (G_TYPE_CHECK_CLASS_TYPE ((klass), TI_TYPE_DLG_HOLD_HANDLES))
#define TI_DLG_HOLD_HANDLES_GET_CLASS(object)  (G_TYPE_INSTANCE_GET_CLASS ((object), TI_TYPE_DLG_HOLD_HANDLES, TIDlgHoldHandlesClass))

struct _TIDlgHoldHandles
{
    GObject parent;
};

struct _TIDlgHoldHandlesClass
{
    GObjectClass parent;
};

GType ti_dlg_hold_handles_get_type (void);

TIDlgHoldHandles *ti_dlg_hold_handles_new (GtkWindow *parent);

/**
 * Shows the "Hold Handles" dialog.
 *
 * @param handles Entered handles. An array of guint. Must be freed after use.
 * @return TRUE if the user clicked "OK" and FALSE otherwise.
 */
gboolean ti_dlg_hold_handles_run (TIDlgHoldHandles *dlg_hold_handles, guint *handle_type, GArray **handles);

#endif
