/*
    		 Crown Copyright (c) 1997, 1998
    
    This TenDRA(r) Computer Program is subject to Copyright
    owned by the United Kingdom Secretary of State for Defence
    acting through the Defence Evaluation and Research Agency
    (DERA).  It is made available to Recipients with a
    royalty-free licence for its use, reproduction, transfer
    to other parties and amendment for any purpose not excluding
    product development provided that any such use et cetera
    shall be deemed to be acceptance of the following conditions:-
    
        (1) Its Recipients shall ensure that this Notice is
        reproduced upon any copies or amended versions of it;
    
        (2) Any amended version of it shall be clearly marked to
        show both the nature of and the organisation responsible
        for the relevant amendment or amendments;
    
        (3) Its onward transfer from a recipient to another
        party shall be deemed to be that party's acceptance of
        these conditions;
    
        (4) DERA gives no warranty or assurance as to its
        quality or suitability for any purpose and DERA accepts
        no liability whatsoever in relation to any use to which
        it may be put.
*/

/* AUTOMATICALLY GENERATED BY make_err FROM cpp */


#ifndef ERR_INCLUDED
#define ERR_INCLUDED


/* Error data structure */

#ifndef ERR_CONST
#define ERR_CONST
#endif

typedef unsigned ERR_PROPS ;

typedef struct {
    ERR_CONST char *name ;
    ERR_CONST char *signature ;
    int usage ;
    ERR_PROPS props ;
    ERR_CONST char *key_ISO ;
    ERR_CONST char *key_STD ;
} ERR_DATA ;

extern ERR_DATA ERR_CATALOG [] ;
extern ERR_CONST char *ERR_NAME ;


/* Error type keys */

#define ERR_KEY_ACCESS '0'
#define ERR_KEY_BASE_TYPE '1'
#define ERR_KEY_CLASS_TYPE '2'
#define ERR_KEY_CV_SPEC '3'
#define ERR_KEY_DECL_SPEC '4'
#define ERR_KEY_FLOAT '5'
#define ERR_KEY_HASHID '6'
#define ERR_KEY_IDENTIFIER '7'
#define ERR_KEY_LEX '8'
#define ERR_KEY_LONG_ID '9'
#define ERR_KEY_NAMESPACE 'A'
#define ERR_KEY_NAT 'B'
#define ERR_KEY_PPTOKEN_P 'C'
#define ERR_KEY_PTR_LOC 'D'
#define ERR_KEY_QUALIFIER 'E'
#define ERR_KEY_STRING 'F'
#define ERR_KEY_TYPE 'G'
#define ERR_KEY_cint 'H'
#define ERR_KEY_cstring 'I'
#define ERR_KEY_string 'J'
#define ERR_KEY_ucint 'K'
#define ERR_KEY_ulong 'L'
#define ERR_KEY_unsigned 'M'
#define ERR_KEY_plural 'N'


/* Error usage keys */

#ifndef ERR_USE
#define OPT_error 0
#define OPT_warning 1
#define OPT_none 2
#define OPT_whatever 3
#define OPT_new 4
#define OPT_wall 5
#define OPT_cpp_error 6
#define OPT_c_error 7
#define OPT_addr_register 8
#define OPT_bitf_overflow 9
#define OPT_bitf_type 10
#define OPT_bool_assign 11
#define OPT_case_fall 12
#define OPT_cast_explicit 13
#define OPT_class_scope 14
#define OPT_comma_extra 15
#define OPT_complete_struct 16
#define OPT_concat_string 17
#define OPT_cond_default 18
#define OPT_cond_lvalue 19
#define OPT_const_cond 20
#define OPT_const_internal 21
#define OPT_const_string 22
#define OPT_conv 23
#define OPT_conv_int_int 24
#define OPT_conv_int_int_expl 25
#define OPT_conv_int_int_impl 26
#define OPT_conv_int_enum 27
#define OPT_conv_int_ptr 28
#define OPT_conv_int_ptr_expl 29
#define OPT_conv_int_ptr_impl 30
#define OPT_conv_ptr_ptr 31
#define OPT_conv_ptr_ptr_expl 32
#define OPT_conv_ptr_ptr_impl 33
#define OPT_conv_ptr_ptr_void 34
#define OPT_conv_ptr_void_ptr 35
#define OPT_conv_ptr_func 36
#define OPT_cpplus_comment 37
#define OPT_decl_cond 38
#define OPT_decl_empty 39
#define OPT_decl_hide 40
#define OPT_decl_none 41
#define OPT_decl_struct_anon 42
#define OPT_decl_unify 43
#define OPT_decl_volatile 44
#define OPT_delete_over 45
#define OPT_digraph 46
#define OPT_discard 47
#define OPT_discard_exp 48
#define OPT_discard_func 49
#define OPT_discard_static 50
#define OPT_discard_value 51
#define OPT_dollar_ident 52
#define OPT_dspec_none 53
#define OPT_dspec_none_func 54
#define OPT_ellipsis_extra 55
#define OPT_ellipsis_ident 56
#define OPT_empty_body 57
#define OPT_enum_decl 58
#define OPT_enum_switch 59
#define OPT_eof_nline 60
#define OPT_escape_overflow 61
#define OPT_escape_unknown 62
#define OPT_for_scope 63
#define OPT_func_block 64
#define OPT_func_impl 65
#define OPT_func_incompat 66
#define OPT_func_linkage 67
#define OPT_func_proto 68
#define OPT_func_ret_void 69
#define OPT_func_token_undef 70
#define OPT_func_weak 71
#define OPT_gen_ptr_char 72
#define OPT_hash_ident 73
#define OPT_include_full 74
#define OPT_include_verbose 75
#define OPT_infer_int 76
#define OPT_infer_int_cv 77
#define OPT_init_aggregate 78
#define OPT_init_dynamic 79
#define OPT_init_struct 80
#define OPT_inline_internal 81
#define OPT_int_operator 82
#define OPT_int_overflow 83
#define OPT_interf_incompat 84
#define OPT_iso_keyword 85
#define OPT_link_incompat 86
#define OPT_link_internal 87
#define OPT_link_resolve 88
#define OPT_lint_comment 89
#define OPT_longlong 90
#define OPT_macro_arg_dir 91
#define OPT_macro_nest 92
#define OPT_macro_redef 93
#define OPT_macro_weak 94
#define OPT_member_incompat 95
#define OPT_name_limit 96
#define OPT_nest_comment 97
#define OPT_new_array 98
#define OPT_overload_ambig 99
#define OPT_overload_dep 100
#define OPT_overload_expl 101
#define OPT_overload_res 102
#define OPT_overload_strict 103
#define OPT_param_impl 104
#define OPT_paren 105
#define OPT_ppdir_id 106
#define OPT_ppdir_null 107
#define OPT_ppdir_text 108
#define OPT_ppdir_unknown 109
#define OPT_ppdir_assert 110
#define OPT_ppdir_assert_ignore 111
#define OPT_ppdir_file 112
#define OPT_ppdir_file_ignore 113
#define OPT_ppdir_ident 114
#define OPT_ppdir_ident_ignore 115
#define OPT_ppdir_import 116
#define OPT_ppdir_import_ignore 117
#define OPT_ppdir_indent 118
#define OPT_ppdir_indent_dir 119
#define OPT_ppdir_unassert 120
#define OPT_ppdir_unassert_ignore 121
#define OPT_ppdir_warning 122
#define OPT_ppdir_warning_ignore 123
#define OPT_ppdir_weak 124
#define OPT_ppdir_weak_ignore 125
#define OPT_pragma_unknown 126
#define OPT_preproc_old 127
#define OPT_printf_string 128
#define OPT_proto_scope 129
#define OPT_ptr_operator 130
#define OPT_ptr_void 131
#define OPT_reached 132
#define OPT_semicolon_extra 133
#define OPT_templ_export 134
#define OPT_templ_undecl 135
#define OPT_this_lvalue 136
#define OPT_throw_bad 137
#define OPT_token_const 138
#define OPT_token_redef 139
#define OPT_token_undef 140
#define OPT_trigraph 141
#define OPT_type_obj_incompl 142
#define OPT_type_qual_incompat 143
#define OPT_type_redef 144
#define OPT_type_tag_ignore 145
#define OPT_unmatched 146
#define OPT_variable 147
#define OPT_weak 148
#endif


/* Error property keys */

#ifndef ERR_PROP
#define ERR_PROP_non_iso ( ( ERR_PROPS ) 0x1 )
#define ERR_PROP_compiler ( ( ERR_PROPS ) 0x2 )
#define ERR_PROP_pragma ( ( ERR_PROPS ) 0x4 )
#define ERR_PROP_printf ( ( ERR_PROPS ) 0x8 )
#define ERR_PROP_syntax ( ( ERR_PROPS ) 0x10 )
#define ERR_PROP_token ( ( ERR_PROPS ) 0x20 )
#define ERR_PROP_dummy ( ( ERR_PROPS ) 0x40 )
#endif


/* Error type checking */

#if defined ( ERR_CHECK ) && defined ( __STDC__ )
extern ACCESS chk_0 ( ACCESS ) ;
extern BASE_TYPE chk_1 ( BASE_TYPE ) ;
extern CLASS_TYPE chk_2 ( CLASS_TYPE ) ;
extern CV_SPEC chk_3 ( CV_SPEC ) ;
extern DECL_SPEC chk_4 ( DECL_SPEC ) ;
extern FLOAT chk_5 ( FLOAT ) ;
extern HASHID chk_6 ( HASHID ) ;
extern IDENTIFIER chk_7 ( IDENTIFIER ) ;
extern LEX chk_8 ( LEX ) ;
extern LONG_ID chk_9 ( LONG_ID ) ;
extern NAMESPACE chk_A ( NAMESPACE ) ;
extern NAT chk_B ( NAT ) ;
extern PPTOKEN_P chk_C ( PPTOKEN_P ) ;
extern PTR_LOC chk_D ( PTR_LOC ) ;
extern QUALIFIER chk_E ( QUALIFIER ) ;
extern STRING chk_F ( STRING ) ;
extern TYPE chk_G ( TYPE ) ;
extern cint chk_H ( cint ) ;
extern cstring chk_I ( cstring ) ;
extern string chk_J ( string ) ;
extern ucint chk_K ( ucint ) ;
extern ulong chk_L ( ulong ) ;
extern unsigned chk_M ( unsigned ) ;
extern plural chk_N ( plural ) ;
#else
#define chk_0( A ) ( A )
#define chk_1( A ) ( A )
#define chk_2( A ) ( A )
#define chk_3( A ) ( A )
#define chk_4( A ) ( A )
#define chk_5( A ) ( A )
#define chk_6( A ) ( A )
#define chk_7( A ) ( A )
#define chk_8( A ) ( A )
#define chk_9( A ) ( A )
#define chk_A( A ) ( A )
#define chk_B( A ) ( A )
#define chk_C( A ) ( A )
#define chk_D( A ) ( A )
#define chk_E( A ) ( A )
#define chk_F( A ) ( A )
#define chk_G( A ) ( A )
#define chk_H( A ) ( A )
#define chk_I( A ) ( A )
#define chk_J( A ) ( A )
#define chk_K( A ) ( A )
#define chk_L( A ) ( A )
#define chk_M( A ) ( A )
#define chk_N( A ) ( A )
#endif


/* Error message macros */

#ifdef ERR_GEN

#define ERR_fail_input( A )\
	ERR_GEN ( 0, chk_J ( A ) )

#define ERR_fail_output( A )\
	ERR_GEN ( 1, chk_J ( A ) )

#define ERR_fail_dump( A )\
	ERR_GEN ( 2, chk_J ( A ) )

#define ERR_fail_spec( A )\
	ERR_GEN ( 3, chk_J ( A ) )

#define ERR_fail_spec_bad( A, B )\
	ERR_GEN ( 4, chk_J ( A ), chk_J ( B ) )

#define ERR_fail_port( A )\
	ERR_GEN ( 5, chk_J ( A ) )

#define ERR_fail_too_many( A )\
	ERR_GEN ( 6, chk_L ( A ) )

#define ERR_fail_error( A )\
	ERR_GEN ( 7, chk_I ( A ) )

#define ERR_fail_warning( A )\
	ERR_GEN ( 8, chk_I ( A ) )

#define ERR_fail_list_item( A, B, C )\
	ERR_GEN ( 9, chk_M ( A ), chk_9 ( B ), chk_D ( C ) )

#define ERR_fail_list_end( A )\
	ERR_GEN ( 10, chk_M ( A ) )

#define ERR_lex_parse( A )\
	ERR_GEN ( 11, chk_C ( A ) )

#define ERR_lex_expect( A )\
	ERR_GEN ( 12, chk_8 ( A ) )

#define ERR_lex_extra_comma()\
	ERR_GEN ( 13 )

#define ERR_lex_abort()\
	ERR_GEN ( 14 )

#define ERR_lex_phases_eof()\
	ERR_GEN ( 15 )

#define ERR_lex_phases_comm_eof()\
	ERR_GEN ( 16 )

#define ERR_lex_phases_str_eof()\
	ERR_GEN ( 17 )

#define ERR_lex_charset_len( A, B )\
	ERR_GEN ( 18, chk_H ( A ), chk_M ( B ) )

#define ERR_lex_charset_replace( A )\
	ERR_GEN ( 19, chk_K ( A ) )

#define ERR_lex_charset_bad( A )\
	ERR_GEN ( 20, chk_K ( A ) )

#define ERR_lex_trigraph_replace( A, B )\
	ERR_GEN ( 21, chk_H ( A ), chk_H ( B ) )

#define ERR_lex_pptoken_unknown( A )\
	ERR_GEN ( 22, chk_H ( A ) )

#define ERR_lex_pptoken_unicode( A )\
	ERR_GEN ( 23, chk_K ( A ) )

#define ERR_lex_digraph_replace( A, B )\
	ERR_GEN ( 24, chk_8 ( A ), chk_8 ( B ) )

#define ERR_lex_digraph_iso( A, B )\
	ERR_GEN ( 25, chk_6 ( A ), chk_8 ( B ) )

#define ERR_lex_comment_nest()\
	ERR_GEN ( 26 )

#define ERR_lex_name_limit( A, B, C )\
	ERR_GEN ( 27, chk_6 ( A ), chk_L ( B ), chk_L ( C ) )

#define ERR_lex_name_extendid( A )\
	ERR_GEN ( 28, chk_K ( A ) )

#define ERR_lex_key_word( A )\
	ERR_GEN ( 29, chk_8 ( A ) )

#define ERR_lex_key_iso( A )\
	ERR_GEN ( 30, chk_6 ( A ) )

#define ERR_lex_key_reserve( A )\
	ERR_GEN ( 31, chk_6 ( A ) )

#define ERR_lex_op_old_assign( A, B )\
	ERR_GEN ( 32, chk_H ( A ), chk_H ( B ) )

#define ERR_lex_literal_bad( A )\
	ERR_GEN ( 33, chk_J ( A ) )

#define ERR_lex_icon_octal( A )\
	ERR_GEN ( 34, chk_J ( A ) )

#define ERR_lex_icon_large( A, B )\
	ERR_GEN ( 35, chk_J ( A ), chk_B ( B ) )

#define ERR_lex_icon_llong( A )\
	ERR_GEN ( 36, chk_J ( A ) )

#define ERR_lex_ccon_multibyte()\
	ERR_GEN ( 37 )

#define ERR_lex_ccon_empty()\
	ERR_GEN ( 38 )

#define ERR_lex_ccon_multi( A )\
	ERR_GEN ( 39, chk_F ( A ) )

#define ERR_lex_ccon_escape( A )\
	ERR_GEN ( 40, chk_H ( A ) )

#define ERR_lex_ccon_hex( A )\
	ERR_GEN ( 41, chk_H ( A ) )

#define ERR_lex_ccon_large()\
	ERR_GEN ( 42 )

#define ERR_lex_fcon_large( A )\
	ERR_GEN ( 43, chk_5 ( A ) )

#define ERR_lex_string_nl( A, B )\
	ERR_GEN ( 44, chk_M ( A ), chk_N ( B ) )

#define ERR_lex_string_pp_nl()\
	ERR_GEN ( 45 )

#define ERR_lex_string_concat()\
	ERR_GEN ( 46 )

#define ERR_basic_odr_decl( A, B )\
	ERR_GEN ( 47, chk_7 ( A ), chk_D ( B ) )

#define ERR_basic_odr_diff( A, B )\
	ERR_GEN ( 48, chk_7 ( A ), chk_D ( B ) )

#define ERR_basic_odr_typedef( A, B )\
	ERR_GEN ( 49, chk_7 ( A ), chk_D ( B ) )

#define ERR_basic_odr_def( A, B )\
	ERR_GEN ( 50, chk_7 ( A ), chk_D ( B ) )

#define ERR_basic_odr_def_func( A, B )\
	ERR_GEN ( 51, chk_9 ( A ), chk_D ( B ) )

#define ERR_basic_odr_undef( A )\
	ERR_GEN ( 52, chk_9 ( A ) )

#define ERR_basic_odr_inline( A )\
	ERR_GEN ( 53, chk_9 ( A ) )

#define ERR_basic_odr_unused( A )\
	ERR_GEN ( 54, chk_9 ( A ) )

#define ERR_basic_odr_redundant( A )\
	ERR_GEN ( 55, chk_9 ( A ) )

#define ERR_basic_odr_tentative( A, B )\
	ERR_GEN ( 56, chk_7 ( A ), chk_D ( B ) )

#define ERR_basic_odr_def_type( A, B )\
	ERR_GEN ( 57, chk_9 ( A ), chk_D ( B ) )

#define ERR_basic_scope_pdecl_param( A )\
	ERR_GEN ( 58, chk_9 ( A ) )

#define ERR_basic_scope_hide( A, B )\
	ERR_GEN ( 59, chk_6 ( A ), chk_D ( B ) )

#define ERR_basic_scope_hide_mem( A, B )\
	ERR_GEN ( 60, chk_6 ( A ), chk_7 ( B ) )

#define ERR_lookup_ambig_id( A )\
	ERR_GEN ( 61, chk_7 ( A ) )

#define ERR_lookup_ambig_mem( A )\
	ERR_GEN ( 62, chk_7 ( A ) )

#define ERR_lookup_ambig_list()\
	ERR_GEN ( 63 )

#define ERR_lookup_unqual_undef( A )\
	ERR_GEN ( 64, chk_6 ( A ) )

#define ERR_lookup_unqual_vis( A )\
	ERR_GEN ( 65, chk_7 ( A ) )

#define ERR_lookup_qual_undef( A, B )\
	ERR_GEN ( 66, chk_6 ( A ), chk_A ( B ) )

#define ERR_lookup_qual_bad( A, B )\
	ERR_GEN ( 67, chk_7 ( A ), chk_A ( B ) )

#define ERR_lookup_qual_decl( A, B )\
	ERR_GEN ( 68, chk_7 ( A ), chk_A ( B ) )

#define ERR_lookup_elab_alias( A, B )\
	ERR_GEN ( 69, chk_1 ( A ), chk_7 ( B ) )

#define ERR_lookup_elab_invalid( A, B )\
	ERR_GEN ( 70, chk_1 ( A ), chk_7 ( B ) )

#define ERR_lookup_elab_enum( A )\
	ERR_GEN ( 71, chk_9 ( A ) )

#define ERR_lookup_classref_ambig( A )\
	ERR_GEN ( 72, chk_7 ( A ) )

#define ERR_basic_link_mem_extern( A )\
	ERR_GEN ( 73, chk_9 ( A ) )

#define ERR_basic_link_none( A, B )\
	ERR_GEN ( 74, chk_G ( A ), chk_9 ( B ) )

#define ERR_basic_link_qual( A, B )\
	ERR_GEN ( 75, chk_3 ( A ), chk_3 ( B ) )

#define ERR_basic_link_incompat( A, B )\
	ERR_GEN ( 76, chk_G ( A ), chk_G ( B ) )

#define ERR_basic_link_decl_type( A, B )\
	ERR_GEN ( 77, chk_7 ( A ), chk_D ( B ) )

#define ERR_basic_link_typedef( A, B )\
	ERR_GEN ( 78, chk_7 ( A ), chk_D ( B ) )

#define ERR_basic_link_unmatch( A, B )\
	ERR_GEN ( 79, chk_G ( A ), chk_7 ( B ) )

#define ERR_basic_start_main_over( A )\
	ERR_GEN ( 80, chk_7 ( A ) )

#define ERR_basic_start_main_ret( A, B )\
	ERR_GEN ( 81, chk_G ( A ), chk_6 ( B ) )

#define ERR_basic_start_main_proto( A, B )\
	ERR_GEN ( 82, chk_G ( A ), chk_6 ( B ) )

#define ERR_basic_start_main_link( A, B )\
	ERR_GEN ( 83, chk_6 ( A ), chk_4 ( B ) )

#define ERR_basic_start_main_call( A )\
	ERR_GEN ( 84, chk_7 ( A ) )

#define ERR_basic_start_main_addr( A )\
	ERR_GEN ( 85, chk_7 ( A ) )

#define ERR_basic_start_main_fall( A, B )\
	ERR_GEN ( 86, chk_7 ( A ), chk_G ( B ) )

#define ERR_basic_stc_alloc_ret( A, B )\
	ERR_GEN ( 87, chk_6 ( A ), chk_G ( B ) )

#define ERR_basic_stc_alloc_p1( A, B )\
	ERR_GEN ( 88, chk_6 ( A ), chk_G ( B ) )

#define ERR_basic_stc_alloc_d1( A )\
	ERR_GEN ( 89, chk_6 ( A ) )

#define ERR_basic_stc_alloc_p2( A, B )\
	ERR_GEN ( 90, chk_6 ( A ), chk_G ( B ) )

#define ERR_basic_stc_alloc_pn( A )\
	ERR_GEN ( 91, chk_6 ( A ) )

#define ERR_basic_stc_alloc_templ( A )\
	ERR_GEN ( 92, chk_6 ( A ) )

#define ERR_basic_stc_alloc_nspace( A )\
	ERR_GEN ( 93, chk_7 ( A ) )

#define ERR_basic_stc_alloc_link( A )\
	ERR_GEN ( 94, chk_7 ( A ) )

#define ERR_basic_stc_dealloc_over( A )\
	ERR_GEN ( 95, chk_7 ( A ) )

#define ERR_basic_types_def_incompl( A )\
	ERR_GEN ( 96, chk_7 ( A ) )

#define ERR_basic_types_par_incompl( A )\
	ERR_GEN ( 97, chk_7 ( A ) )

#define ERR_basic_types_tent_incompl( A )\
	ERR_GEN ( 98, chk_7 ( A ) )

#define ERR_basic_types_obj_func( A )\
	ERR_GEN ( 99, chk_G ( A ) )

#define ERR_basic_types_obj_ref( A )\
	ERR_GEN ( 100, chk_G ( A ) )

#define ERR_basic_types_incompl( A )\
	ERR_GEN ( 101, chk_G ( A ) )

#define ERR_basic_types_completed( A )\
	ERR_GEN ( 102, chk_G ( A ) )

#define ERR_basic_types_obj_incompl()\
	ERR_GEN ( 103 )

#define ERR_basic_types_obj_void( A )\
	ERR_GEN ( 104, chk_G ( A ) )

#define ERR_basic_fund_void_decl( A, B )\
	ERR_GEN ( 105, chk_7 ( A ), chk_G ( B ) )

#define ERR_basic_fund_void_mem( A, B )\
	ERR_GEN ( 106, chk_7 ( A ), chk_G ( B ) )

#define ERR_basic_fund_void_exp( A )\
	ERR_GEN ( 107, chk_G ( A ) )

#define ERR_basic_lval_not()\
	ERR_GEN ( 108 )

#define ERR_basic_lval_mod_rvalue()\
	ERR_GEN ( 109 )

#define ERR_basic_lval_mod_array()\
	ERR_GEN ( 110 )

#define ERR_basic_lval_mod_func()\
	ERR_GEN ( 111 )

#define ERR_basic_lval_mod_incompl()\
	ERR_GEN ( 112 )

#define ERR_basic_lval_mod_const()\
	ERR_GEN ( 113 )

#define ERR_basic_lval_mod_member( A )\
	ERR_GEN ( 114, chk_G ( A ) )

#define ERR_conv_lval_incompl()\
	ERR_GEN ( 115 )

#define ERR_conv_array_string()\
	ERR_GEN ( 116 )

#define ERR_conv_array_str_mod()\
	ERR_GEN ( 117 )

#define ERR_conv_qual_cast( A )\
	ERR_GEN ( 118, chk_3 ( A ) )

#define ERR_conv_qual_multi()\
	ERR_GEN ( 119 )

#define ERR_conv_integral_cast( A, B )\
	ERR_GEN ( 120, chk_G ( A ), chk_G ( B ) )

#define ERR_conv_double_cast( A, B )\
	ERR_GEN ( 121, chk_G ( A ), chk_G ( B ) )

#define ERR_conv_fpint_trunc( A, B )\
	ERR_GEN ( 122, chk_G ( A ), chk_G ( B ) )

#define ERR_conv_fpint_float( A, B )\
	ERR_GEN ( 123, chk_G ( A ), chk_G ( B ) )

#define ERR_conv_fpint_large( A )\
	ERR_GEN ( 124, chk_5 ( A ) )

#define ERR_conv_ptr_null_complex()\
	ERR_GEN ( 125 )

#define ERR_conv_ptr_nonzero( A, B )\
	ERR_GEN ( 126, chk_G ( A ), chk_G ( B ) )

#define ERR_conv_ptr_cast( A, B )\
	ERR_GEN ( 127, chk_G ( A ), chk_G ( B ) )

#define ERR_conv_ptr_incompat()\
	ERR_GEN ( 128 )

#define ERR_conv_ptr_ambiguous()\
	ERR_GEN ( 129 )

#define ERR_conv_ptr_access()\
	ERR_GEN ( 130 )

#define ERR_conv_ptr_common()\
	ERR_GEN ( 131 )

#define ERR_conv_ptr_gen( A )\
	ERR_GEN ( 132, chk_G ( A ) )

#define ERR_conv_mem_nonzero( A, B )\
	ERR_GEN ( 133, chk_G ( A ), chk_G ( B ) )

#define ERR_conv_mem_cast( A, B )\
	ERR_GEN ( 134, chk_G ( A ), chk_G ( B ) )

#define ERR_conv_mem_ambiguous()\
	ERR_GEN ( 135 )

#define ERR_conv_mem_virtual()\
	ERR_GEN ( 136 )

#define ERR_conv_mem_common()\
	ERR_GEN ( 137 )

#define ERR_conv_bool_cast( A )\
	ERR_GEN ( 138, chk_G ( A ) )

#define ERR_conv_bool_assign()\
	ERR_GEN ( 139 )

#define ERR_expr_paren_left( A, B )\
	ERR_GEN ( 140, chk_8 ( A ), chk_8 ( B ) )

#define ERR_expr_paren_right( A, B )\
	ERR_GEN ( 141, chk_8 ( A ), chk_8 ( B ) )

#define ERR_expr_convert_op( A, B )\
	ERR_GEN ( 142, chk_M ( A ), chk_8 ( B ) )

#define ERR_expr_prim_this()\
	ERR_GEN ( 143 )

#define ERR_expr_prim_mem( A )\
	ERR_GEN ( 144, chk_9 ( A ) )

#define ERR_expr_prim_type( A )\
	ERR_GEN ( 145, chk_9 ( A ) )

#define ERR_expr_sub_ptr_op( A, B )\
	ERR_GEN ( 146, chk_G ( A ), chk_G ( B ) )

#define ERR_expr_sub_int_op( A )\
	ERR_GEN ( 147, chk_G ( A ) )

#define ERR_expr_sub_char_op( A )\
	ERR_GEN ( 148, chk_G ( A ) )

#define ERR_expr_sub_incompl()\
	ERR_GEN ( 149 )

#define ERR_expr_call_func( A )\
	ERR_GEN ( 150, chk_9 ( A ) )

#define ERR_expr_call_op( A )\
	ERR_GEN ( 151, chk_G ( A ) )

#define ERR_expr_call_ret()\
	ERR_GEN ( 152 )

#define ERR_expr_call_mem( A )\
	ERR_GEN ( 153, chk_9 ( A ) )

#define ERR_expr_call_undecl( A )\
	ERR_GEN ( 154, chk_9 ( A ) )

#define ERR_expr_call_arg( A )\
	ERR_GEN ( 155, chk_M ( A ) )

#define ERR_expr_call_ellipsis( A )\
	ERR_GEN ( 156, chk_M ( A ) )

#define ERR_expr_call_weak_arg( A, B )\
	ERR_GEN ( 157, chk_M ( A ), chk_D ( B ) )

#define ERR_expr_call_args_exact( A, B, C )\
	ERR_GEN ( 158, chk_M ( A ), chk_N ( B ), chk_M ( C ) )

#define ERR_expr_call_args_range( A, B, C, D )\
	ERR_GEN ( 159, chk_M ( A ), chk_N ( B ), chk_M ( C ), chk_M ( D ) )

#define ERR_expr_call_args_min( A, B, C )\
	ERR_GEN ( 160, chk_M ( A ), chk_N ( B ), chk_M ( C ) )

#define ERR_expr_call_struct( A )\
	ERR_GEN ( 161, chk_G ( A ) )

#define ERR_expr_call_ell_func()\
	ERR_GEN ( 162 )

#define ERR_expr_call_ell_exp()\
	ERR_GEN ( 163 )

#define ERR_expr_type_conv_incompl()\
	ERR_GEN ( 164 )

#define ERR_expr_type_conv_array( A )\
	ERR_GEN ( 165, chk_G ( A ) )

#define ERR_expr_type_conv_bad()\
	ERR_GEN ( 166 )

#define ERR_expr_type_conv_many( A )\
	ERR_GEN ( 167, chk_G ( A ) )

#define ERR_expr_pseudo_type( A, B )\
	ERR_GEN ( 168, chk_G ( A ), chk_G ( B ) )

#define ERR_expr_pseudo_scalar( A )\
	ERR_GEN ( 169, chk_G ( A ) )

#define ERR_expr_pseudo_obj( A, B )\
	ERR_GEN ( 170, chk_6 ( A ), chk_G ( B ) )

#define ERR_expr_pseudo_args( A )\
	ERR_GEN ( 171, chk_6 ( A ) )

#define ERR_expr_ref_arrow_op( A, B )\
	ERR_GEN ( 172, chk_G ( A ), chk_J ( B ) )

#define ERR_expr_ref_dot_op( A, B )\
	ERR_GEN ( 173, chk_G ( A ), chk_J ( B ) )

#define ERR_expr_ref_arrow_dot( A )\
	ERR_GEN ( 174, chk_G ( A ) )

#define ERR_expr_ref_dot_arrow( A )\
	ERR_GEN ( 175, chk_G ( A ) )

#define ERR_expr_ref_incompl( A, B )\
	ERR_GEN ( 176, chk_8 ( A ), chk_1 ( B ) )

#define ERR_expr_ref_select( A, B )\
	ERR_GEN ( 177, chk_8 ( A ), chk_J ( B ) )

#define ERR_expr_ref_call()\
	ERR_GEN ( 178 )

#define ERR_expr_ref_qual( A, B )\
	ERR_GEN ( 179, chk_E ( A ), chk_7 ( B ) )

#define ERR_expr_ref_func_type( A )\
	ERR_GEN ( 180, chk_2 ( A ) )

#define ERR_expr_ref_type( A )\
	ERR_GEN ( 181, chk_7 ( A ) )

#define ERR_expr_post_incr_mod( A )\
	ERR_GEN ( 182, chk_8 ( A ) )

#define ERR_expr_post_incr_op( A, B )\
	ERR_GEN ( 183, chk_8 ( A ), chk_G ( B ) )

#define ERR_expr_post_incr_incompl( A )\
	ERR_GEN ( 184, chk_8 ( A ) )

#define ERR_expr_post_incr_bool_inc( A, B )\
	ERR_GEN ( 185, chk_8 ( A ), chk_G ( B ) )

#define ERR_expr_post_incr_bool_dec( A, B )\
	ERR_GEN ( 186, chk_8 ( A ), chk_G ( B ) )

#define ERR_expr_cast_dynam_typedef()\
	ERR_GEN ( 187 )

#define ERR_expr_cast_dynam_bad()\
	ERR_GEN ( 188 )

#define ERR_expr_cast_dynam_type( A )\
	ERR_GEN ( 189, chk_G ( A ) )

#define ERR_expr_cast_dynam_ptr( A )\
	ERR_GEN ( 190, chk_G ( A ) )

#define ERR_expr_cast_dynam_ref( A )\
	ERR_GEN ( 191, chk_G ( A ) )

#define ERR_expr_cast_dynam_poly( A )\
	ERR_GEN ( 192, chk_2 ( A ) )

#define ERR_expr_typeid_index( A )\
	ERR_GEN ( 193, chk_8 ( A ) )

#define ERR_expr_typeid_side( A )\
	ERR_GEN ( 194, chk_8 ( A ) )

#define ERR_expr_typeid_typedef( A )\
	ERR_GEN ( 195, chk_8 ( A ) )

#define ERR_expr_typeid_incompl( A )\
	ERR_GEN ( 196, chk_8 ( A ) )

#define ERR_expr_typeid_vtable( A )\
	ERR_GEN ( 197, chk_8 ( A ) )

#define ERR_expr_cast_stat_typedef()\
	ERR_GEN ( 198 )

#define ERR_expr_cast_stat_bad()\
	ERR_GEN ( 199 )

#define ERR_expr_cast_stat_int_enum( A, B )\
	ERR_GEN ( 200, chk_G ( A ), chk_G ( B ) )

#define ERR_expr_cast_stat_enum_enum( A, B )\
	ERR_GEN ( 201, chk_G ( A ), chk_G ( B ) )

#define ERR_expr_cast_stat_virt()\
	ERR_GEN ( 202 )

#define ERR_expr_cast_stat_func( A )\
	ERR_GEN ( 203, chk_G ( A ) )

#define ERR_expr_cast_reint_typedef()\
	ERR_GEN ( 204 )

#define ERR_expr_cast_reint_bad()\
	ERR_GEN ( 205 )

#define ERR_expr_cast_reint_int_ptr( A, B )\
	ERR_GEN ( 206, chk_G ( A ), chk_G ( B ) )

#define ERR_expr_cast_reint_ptr_int( A, B )\
	ERR_GEN ( 207, chk_G ( A ), chk_G ( B ) )

#define ERR_expr_cast_reint_func_ptr( A, B )\
	ERR_GEN ( 208, chk_G ( A ), chk_G ( B ) )

#define ERR_expr_cast_reint_mem_func( A, B )\
	ERR_GEN ( 209, chk_G ( A ), chk_G ( B ) )

#define ERR_expr_cast_const_typedef()\
	ERR_GEN ( 210 )

#define ERR_expr_cast_const_bad()\
	ERR_GEN ( 211 )

#define ERR_expr_unary_op_indir_op( A )\
	ERR_GEN ( 212, chk_G ( A ) )

#define ERR_expr_unary_op_indir_void( A )\
	ERR_GEN ( 213, chk_G ( A ) )

#define ERR_expr_unary_op_indir_null( A )\
	ERR_GEN ( 214, chk_8 ( A ) )

#define ERR_expr_unary_op_ref_lvalue()\
	ERR_GEN ( 215 )

#define ERR_expr_unary_op_ref_void( A )\
	ERR_GEN ( 216, chk_G ( A ) )

#define ERR_expr_unary_op_ref_incompl()\
	ERR_GEN ( 217 )

#define ERR_expr_unary_op_ref_post( A )\
	ERR_GEN ( 218, chk_7 ( A ) )

#define ERR_expr_unary_op_ref_bitf()\
	ERR_GEN ( 219 )

#define ERR_expr_unary_op_ref_register( A )\
	ERR_GEN ( 220, chk_7 ( A ) )

#define ERR_expr_unary_op_ref_paren()\
	ERR_GEN ( 221 )

#define ERR_expr_unary_op_ref_full()\
	ERR_GEN ( 222 )

#define ERR_expr_unary_op_ref_unqual()\
	ERR_GEN ( 223 )

#define ERR_expr_unary_op_uplus_op( A, B )\
	ERR_GEN ( 224, chk_8 ( A ), chk_G ( B ) )

#define ERR_expr_unary_op_uminus_op( A, B )\
	ERR_GEN ( 225, chk_8 ( A ), chk_G ( B ) )

#define ERR_expr_unary_op_compl_op( A, B )\
	ERR_GEN ( 226, chk_8 ( A ), chk_G ( B ) )

#define ERR_expr_unary_op_not_op()\
	ERR_GEN ( 227 )

#define ERR_expr_pre_incr_mod( A )\
	ERR_GEN ( 228, chk_8 ( A ) )

#define ERR_expr_pre_incr_op( A, B )\
	ERR_GEN ( 229, chk_8 ( A ), chk_G ( B ) )

#define ERR_expr_pre_incr_incompl( A )\
	ERR_GEN ( 230, chk_8 ( A ) )

#define ERR_expr_pre_incr_bool_inc( A, B )\
	ERR_GEN ( 231, chk_8 ( A ), chk_G ( B ) )

#define ERR_expr_pre_incr_bool_dec( A, B )\
	ERR_GEN ( 232, chk_8 ( A ), chk_G ( B ) )

#define ERR_expr_sizeof_func( A )\
	ERR_GEN ( 233, chk_8 ( A ) )

#define ERR_expr_sizeof_bitf( A )\
	ERR_GEN ( 234, chk_8 ( A ) )

#define ERR_expr_sizeof_incompl( A )\
	ERR_GEN ( 235, chk_8 ( A ) )

#define ERR_expr_sizeof_typedef( A )\
	ERR_GEN ( 236, chk_8 ( A ) )

#define ERR_expr_sizeof_side( A )\
	ERR_GEN ( 237, chk_8 ( A ) )

#define ERR_expr_new_typedef()\
	ERR_GEN ( 238 )

#define ERR_expr_new_incompl()\
	ERR_GEN ( 239 )

#define ERR_expr_new_abstract()\
	ERR_GEN ( 240 )

#define ERR_expr_new_dim( A )\
	ERR_GEN ( 241, chk_G ( A ) )

#define ERR_expr_new_init( A )\
	ERR_GEN ( 242, chk_8 ( A ) )

#define ERR_expr_new_array_init( A )\
	ERR_GEN ( 243, chk_8 ( A ) )

#define ERR_expr_delete_ptr( A, B )\
	ERR_GEN ( 244, chk_8 ( A ), chk_G ( B ) )

#define ERR_expr_delete_conv( A )\
	ERR_GEN ( 245, chk_8 ( A ) )

#define ERR_expr_delete_void( A, B )\
	ERR_GEN ( 246, chk_8 ( A ), chk_G ( B ) )

#define ERR_expr_delete_obj( A )\
	ERR_GEN ( 247, chk_8 ( A ) )

#define ERR_expr_delete_incompl( A )\
	ERR_GEN ( 248, chk_8 ( A ) )

#define ERR_expr_delete_post( A )\
	ERR_GEN ( 249, chk_7 ( A ) )

#define ERR_expr_delete_const( A )\
	ERR_GEN ( 250, chk_3 ( A ) )

#define ERR_expr_delete_array( A )\
	ERR_GEN ( 251, chk_8 ( A ) )

#define ERR_expr_cast_expl_used()\
	ERR_GEN ( 252 )

#define ERR_expr_cast_expl_typedef()\
	ERR_GEN ( 253 )

#define ERR_expr_cast_expl_scalar( A )\
	ERR_GEN ( 254, chk_G ( A ) )

#define ERR_expr_cast_invalid( A, B )\
	ERR_GEN ( 255, chk_G ( A ), chk_G ( B ) )

#define ERR_expr_cast_expl_bad()\
	ERR_GEN ( 256 )

#define ERR_expr_cast_ref( A, B )\
	ERR_GEN ( 257, chk_G ( A ), chk_G ( B ) )

#define ERR_expr_mptr_oper_arrow_op( A, B )\
	ERR_GEN ( 258, chk_9 ( A ), chk_G ( B ) )

#define ERR_expr_mptr_oper_dot_op( A, B )\
	ERR_GEN ( 259, chk_9 ( A ), chk_G ( B ) )

#define ERR_expr_mptr_oper_arrow_dot( A )\
	ERR_GEN ( 260, chk_G ( A ) )

#define ERR_expr_mptr_oper_dot_arrow( A )\
	ERR_GEN ( 261, chk_G ( A ) )

#define ERR_expr_mptr_oper_op2( A, B )\
	ERR_GEN ( 262, chk_8 ( A ), chk_G ( B ) )

#define ERR_expr_mptr_oper_compl( A )\
	ERR_GEN ( 263, chk_8 ( A ) )

#define ERR_expr_mptr_oper_ambig( A )\
	ERR_GEN ( 264, chk_8 ( A ) )

#define ERR_expr_mptr_oper_call()\
	ERR_GEN ( 265 )

#define ERR_expr_mptr_oper_null( A )\
	ERR_GEN ( 266, chk_8 ( A ) )

#define ERR_expr_mptr_oper_paren()\
	ERR_GEN ( 267 )

#define ERR_expr_mul_mul_op( A, B, C )\
	ERR_GEN ( 268, chk_8 ( A ), chk_G ( B ), chk_G ( C ) )

#define ERR_expr_mul_rem_op( A, B, C )\
	ERR_GEN ( 269, chk_8 ( A ), chk_G ( B ), chk_G ( C ) )

#define ERR_expr_mul_div_zero( A )\
	ERR_GEN ( 270, chk_8 ( A ) )

#define ERR_expr_mul_div_neg( A, B )\
	ERR_GEN ( 271, chk_8 ( A ), chk_B ( B ) )

#define ERR_expr_add_op( A, B, C )\
	ERR_GEN ( 272, chk_8 ( A ), chk_G ( B ), chk_G ( C ) )

#define ERR_expr_add_incompl( A )\
	ERR_GEN ( 273, chk_8 ( A ) )

#define ERR_expr_add_ptrdiff()\
	ERR_GEN ( 274 )

#define ERR_expr_add_array( A, B, C )\
	ERR_GEN ( 275, chk_B ( A ), chk_G ( B ), chk_8 ( C ) )

#define ERR_expr_add_different()\
	ERR_GEN ( 276 )

#define ERR_expr_shift_op( A, B, C )\
	ERR_GEN ( 277, chk_8 ( A ), chk_G ( B ), chk_G ( C ) )

#define ERR_expr_shift_op1_sign( A )\
	ERR_GEN ( 278, chk_8 ( A ) )

#define ERR_expr_shift_op1_neg( A, B )\
	ERR_GEN ( 279, chk_8 ( A ), chk_B ( B ) )

#define ERR_expr_shift_op2_neg( A, B )\
	ERR_GEN ( 280, chk_8 ( A ), chk_B ( B ) )

#define ERR_expr_shift_op2_big( A, B, C )\
	ERR_GEN ( 281, chk_8 ( A ), chk_B ( B ), chk_G ( C ) )

#define ERR_expr_rel_op( A, B, C )\
	ERR_GEN ( 282, chk_8 ( A ), chk_G ( B ), chk_G ( C ) )

#define ERR_expr_rel_nonzero( A, B, C )\
	ERR_GEN ( 283, chk_8 ( A ), chk_G ( B ), chk_G ( C ) )

#define ERR_expr_rel_ptr( A )\
	ERR_GEN ( 284, chk_8 ( A ) )

#define ERR_expr_rel_ptr_void( A, B, C )\
	ERR_GEN ( 285, chk_8 ( A ), chk_G ( B ), chk_G ( C ) )

#define ERR_expr_rel_paren( A, B )\
	ERR_GEN ( 286, chk_8 ( A ), chk_8 ( B ) )

#define ERR_expr_rel_true()\
	ERR_GEN ( 287 )

#define ERR_expr_rel_false()\
	ERR_GEN ( 288 )

#define ERR_expr_rel_null( A )\
	ERR_GEN ( 289, chk_8 ( A ) )

#define ERR_expr_eq_op( A, B, C )\
	ERR_GEN ( 290, chk_8 ( A ), chk_G ( B ), chk_G ( C ) )

#define ERR_expr_eq_nonzero( A, B, C )\
	ERR_GEN ( 291, chk_8 ( A ), chk_G ( B ), chk_G ( C ) )

#define ERR_expr_eq_ptr( A )\
	ERR_GEN ( 292, chk_8 ( A ) )

#define ERR_expr_eq_mptr( A )\
	ERR_GEN ( 293, chk_8 ( A ) )

#define ERR_expr_eq_float( A )\
	ERR_GEN ( 294, chk_8 ( A ) )

#define ERR_expr_bit_and_op( A, B, C )\
	ERR_GEN ( 295, chk_8 ( A ), chk_G ( B ), chk_G ( C ) )

#define ERR_expr_xor_op( A, B, C )\
	ERR_GEN ( 296, chk_8 ( A ), chk_G ( B ), chk_G ( C ) )

#define ERR_expr_or_op( A, B, C )\
	ERR_GEN ( 297, chk_8 ( A ), chk_G ( B ), chk_G ( C ) )

#define ERR_expr_log_and_op( A )\
	ERR_GEN ( 298, chk_8 ( A ) )

#define ERR_expr_log_or_op( A )\
	ERR_GEN ( 299, chk_8 ( A ) )

#define ERR_expr_cond_bool()\
	ERR_GEN ( 300 )

#define ERR_expr_cond_const()\
	ERR_GEN ( 301 )

#define ERR_expr_cond_op( A, B )\
	ERR_GEN ( 302, chk_G ( A ), chk_G ( B ) )

#define ERR_expr_cond_qual( A, B )\
	ERR_GEN ( 303, chk_G ( A ), chk_G ( B ) )

#define ERR_expr_cond_nonzero( A, B )\
	ERR_GEN ( 304, chk_G ( A ), chk_G ( B ) )

#define ERR_expr_cond_ptr()\
	ERR_GEN ( 305 )

#define ERR_expr_cond_mptr()\
	ERR_GEN ( 306 )

#define ERR_expr_ass_mod( A )\
	ERR_GEN ( 307, chk_8 ( A ) )

#define ERR_expr_ass_op( A, B, C )\
	ERR_GEN ( 308, chk_8 ( A ), chk_G ( B ), chk_G ( C ) )

#define ERR_expr_ass_incompl( A )\
	ERR_GEN ( 309, chk_8 ( A ) )

#define ERR_expr_ass_conv()\
	ERR_GEN ( 310 )

#define ERR_expr_ass_twice( A )\
	ERR_GEN ( 311, chk_7 ( A ) )

#define ERR_expr_const_bad()\
	ERR_GEN ( 312 )

#define ERR_expr_const_int( A )\
	ERR_GEN ( 313, chk_G ( A ) )

#define ERR_expr_const_off_mem( A )\
	ERR_GEN ( 314, chk_9 ( A ) )

#define ERR_expr_const_off_array( A )\
	ERR_GEN ( 315, chk_G ( A ) )

#define ERR_expr_const_off_dim()\
	ERR_GEN ( 316 )

#define ERR_stmt_stmt_unreach()\
	ERR_GEN ( 317 )

#define ERR_stmt_stmt_empty( A )\
	ERR_GEN ( 318, chk_8 ( A ) )

#define ERR_stmt_label_redef( A, B, C )\
	ERR_GEN ( 319, chk_7 ( A ), chk_9 ( B ), chk_D ( C ) )

#define ERR_stmt_label_unused( A, B )\
	ERR_GEN ( 320, chk_7 ( A ), chk_9 ( B ) )

#define ERR_stmt_label_case()\
	ERR_GEN ( 321 )

#define ERR_stmt_label_default()\
	ERR_GEN ( 322 )

#define ERR_stmt_label_fall( A )\
	ERR_GEN ( 323, chk_8 ( A ) )

#define ERR_stmt_expr_discard_func()\
	ERR_GEN ( 324 )

#define ERR_stmt_expr_discard_val()\
	ERR_GEN ( 325 )

#define ERR_stmt_expr_incompl()\
	ERR_GEN ( 326 )

#define ERR_stmt_select_type( A )\
	ERR_GEN ( 327, chk_G ( A ) )

#define ERR_stmt_select_typedef()\
	ERR_GEN ( 328 )

#define ERR_stmt_if_cond()\
	ERR_GEN ( 329 )

#define ERR_stmt_if_const()\
	ERR_GEN ( 330 )

#define ERR_stmt_if_no_else()\
	ERR_GEN ( 331 )

#define ERR_stmt_switch_control( A )\
	ERR_GEN ( 332, chk_G ( A ) )

#define ERR_stmt_switch_conv()\
	ERR_GEN ( 333 )

#define ERR_stmt_switch_const()\
	ERR_GEN ( 334 )

#define ERR_stmt_switch_case_const()\
	ERR_GEN ( 335 )

#define ERR_stmt_switch_case_dup( A, B )\
	ERR_GEN ( 336, chk_B ( A ), chk_D ( B ) )

#define ERR_stmt_switch_default_dup( A )\
	ERR_GEN ( 337, chk_D ( A ) )

#define ERR_stmt_switch_case_not( A )\
	ERR_GEN ( 338, chk_B ( A ) )

#define ERR_stmt_switch_default_not()\
	ERR_GEN ( 339 )

#define ERR_stmt_switch_exhaust_none()\
	ERR_GEN ( 340 )

#define ERR_stmt_switch_exhaust_default()\
	ERR_GEN ( 341 )

#define ERR_stmt_switch_case_none()\
	ERR_GEN ( 342 )

#define ERR_stmt_switch_no_default()\
	ERR_GEN ( 343 )

#define ERR_stmt_switch_case_enum( A )\
	ERR_GEN ( 344, chk_9 ( A ) )

#define ERR_stmt_switch_case_extra( A, B )\
	ERR_GEN ( 345, chk_B ( A ), chk_G ( B ) )

#define ERR_stmt_while_cond()\
	ERR_GEN ( 346 )

#define ERR_stmt_while_const()\
	ERR_GEN ( 347 )

#define ERR_stmt_do_cond()\
	ERR_GEN ( 348 )

#define ERR_stmt_do_const()\
	ERR_GEN ( 349 )

#define ERR_stmt_for_cond()\
	ERR_GEN ( 350 )

#define ERR_stmt_for_const()\
	ERR_GEN ( 351 )

#define ERR_stmt_for_init( A )\
	ERR_GEN ( 352, chk_7 ( A ) )

#define ERR_stmt_break_bad()\
	ERR_GEN ( 353 )

#define ERR_stmt_cont_bad()\
	ERR_GEN ( 354 )

#define ERR_stmt_return_void( A, B )\
	ERR_GEN ( 355, chk_7 ( A ), chk_G ( B ) )

#define ERR_stmt_return_none( A, B )\
	ERR_GEN ( 356, chk_7 ( A ), chk_G ( B ) )

#define ERR_stmt_return_bottom( A, B )\
	ERR_GEN ( 357, chk_7 ( A ), chk_G ( B ) )

#define ERR_stmt_return_conv()\
	ERR_GEN ( 358 )

#define ERR_stmt_return_fall( A, B )\
	ERR_GEN ( 359, chk_7 ( A ), chk_G ( B ) )

#define ERR_stmt_return_auto( A, B )\
	ERR_GEN ( 360, chk_9 ( A ), chk_8 ( B ) )

#define ERR_stmt_goto_undef( A, B )\
	ERR_GEN ( 361, chk_7 ( A ), chk_9 ( B ) )

#define ERR_stmt_goto_case( A )\
	ERR_GEN ( 362, chk_8 ( A ) )

#define ERR_stmt_dcl_start()\
	ERR_GEN ( 363 )

#define ERR_stmt_dcl_bypass_lab( A, B )\
	ERR_GEN ( 364, chk_7 ( A ), chk_7 ( B ) )

#define ERR_stmt_dcl_bypass_case( A, B )\
	ERR_GEN ( 365, chk_B ( A ), chk_7 ( B ) )

#define ERR_stmt_dcl_bypass_default( A )\
	ERR_GEN ( 366, chk_7 ( A ) )

#define ERR_stmt_dcl_unused( A )\
	ERR_GEN ( 367, chk_9 ( A ) )

#define ERR_stmt_dcl_unset( A )\
	ERR_GEN ( 368, chk_9 ( A ) )

#define ERR_stmt_dcl_reset( A )\
	ERR_GEN ( 369, chk_9 ( A ) )

#define ERR_dcl_dcl_none()\
	ERR_GEN ( 370 )

#define ERR_dcl_dcl_empty()\
	ERR_GEN ( 371 )

#define ERR_dcl_dcl_semicolon()\
	ERR_GEN ( 372 )

#define ERR_dcl_dcl_anon()\
	ERR_GEN ( 373 )

#define ERR_dcl_dcl_ds_empty()\
	ERR_GEN ( 374 )

#define ERR_dcl_dcl_ds_func()\
	ERR_GEN ( 375 )

#define ERR_dcl_spec_dup( A )\
	ERR_GEN ( 376, chk_4 ( A ) )

#define ERR_dcl_spec_order( A )\
	ERR_GEN ( 377, chk_4 ( A ) )

#define ERR_dcl_stc_dup( A, B )\
	ERR_GEN ( 378, chk_4 ( A ), chk_4 ( B ) )

#define ERR_dcl_stc_stat_block()\
	ERR_GEN ( 379 )

#define ERR_dcl_stc_bad( A )\
	ERR_GEN ( 380, chk_4 ( A ) )

#define ERR_dcl_stc_expl_spec( A )\
	ERR_GEN ( 381, chk_4 ( A ) )

#define ERR_dcl_stc_auto_bad( A )\
	ERR_GEN ( 382, chk_4 ( A ) )

#define ERR_dcl_stc_auto_func( A )\
	ERR_GEN ( 383, chk_4 ( A ) )

#define ERR_dcl_stc_ext_inline()\
	ERR_GEN ( 384 )

#define ERR_dcl_stc_ext_mem()\
	ERR_GEN ( 385 )

#define ERR_dcl_stc_mut_bad()\
	ERR_GEN ( 386 )

#define ERR_dcl_stc_mut_const( A )\
	ERR_GEN ( 387, chk_9 ( A ) )

#define ERR_dcl_stc_param( A )\
	ERR_GEN ( 388, chk_4 ( A ) )

#define ERR_dcl_stc_auto_par()\
	ERR_GEN ( 389 )

#define ERR_dcl_stc_internal( A, B )\
	ERR_GEN ( 390, chk_9 ( A ), chk_D ( B ) )

#define ERR_dcl_stc_external( A, B )\
	ERR_GEN ( 391, chk_9 ( A ), chk_D ( B ) )

#define ERR_dcl_fct_spec_inline_bad()\
	ERR_GEN ( 392 )

#define ERR_dcl_fct_spec_block()\
	ERR_GEN ( 393 )

#define ERR_dcl_fct_spec_virtual()\
	ERR_GEN ( 394 )

#define ERR_dcl_fct_spec_explicit()\
	ERR_GEN ( 395 )

#define ERR_dcl_fct_spec_expl_constr()\
	ERR_GEN ( 396 )

#define ERR_dcl_fct_spec_expl_conv()\
	ERR_GEN ( 397 )

#define ERR_dcl_fct_spec_inline_call( A )\
	ERR_GEN ( 398, chk_9 ( A ) )

#define ERR_dcl_typedef_func()\
	ERR_GEN ( 399 )

#define ERR_dcl_typedef_par()\
	ERR_GEN ( 400 )

#define ERR_dcl_typedef_dspec( A )\
	ERR_GEN ( 401, chk_4 ( A ) )

#define ERR_dcl_typedef_dcl()\
	ERR_GEN ( 402 )

#define ERR_dcl_typedef_constr( A, B )\
	ERR_GEN ( 403, chk_7 ( A ), chk_6 ( B ) )

#define ERR_dcl_typedef_destr( A, B )\
	ERR_GEN ( 404, chk_7 ( A ), chk_6 ( B ) )

#define ERR_dcl_friend_class()\
	ERR_GEN ( 405 )

#define ERR_dcl_type_infer( A )\
	ERR_GEN ( 406, chk_G ( A ) )

#define ERR_dcl_type_none()\
	ERR_GEN ( 407 )

#define ERR_dcl_type_qual()\
	ERR_GEN ( 408 )

#define ERR_dcl_type_cv_dup( A )\
	ERR_GEN ( 409, chk_3 ( A ) )

#define ERR_dcl_type_type_cv( A, B )\
	ERR_GEN ( 410, chk_9 ( A ), chk_3 ( B ) )

#define ERR_dcl_type_cv_unused( A )\
	ERR_GEN ( 411, chk_3 ( A ) )

#define ERR_dcl_type_simple_dup( A )\
	ERR_GEN ( 412, chk_1 ( A ) )

#define ERR_dcl_type_simple_bad( A, B )\
	ERR_GEN ( 413, chk_1 ( A ), chk_1 ( B ) )

#define ERR_dcl_type_simple_llong( A )\
	ERR_GEN ( 414, chk_1 ( A ) )

#define ERR_dcl_type_simple_many( A, B )\
	ERR_GEN ( 415, chk_G ( A ), chk_G ( B ) )

#define ERR_dcl_type_simple_undecl( A, B )\
	ERR_GEN ( 416, chk_1 ( A ), chk_G ( B ) )

#define ERR_dcl_type_simple_undef( A )\
	ERR_GEN ( 417, chk_7 ( A ) )

#define ERR_dcl_type_elab_bad( A, B, C, D )\
	ERR_GEN ( 418, chk_1 ( A ), chk_1 ( B ), chk_7 ( C ), chk_D ( D ) )

#define ERR_dcl_type_elab_qual( A )\
	ERR_GEN ( 419, chk_1 ( A ) )

#define ERR_dcl_enum_none()\
	ERR_GEN ( 420 )

#define ERR_dcl_enum_const( A )\
	ERR_GEN ( 421, chk_9 ( A ) )

#define ERR_dcl_enum_zero( A )\
	ERR_GEN ( 422, chk_G ( A ) )

#define ERR_dcl_nspace_scope()\
	ERR_GEN ( 423 )

#define ERR_dcl_nspace_undef( A )\
	ERR_GEN ( 424, chk_7 ( A ) )

#define ERR_dcl_nspace_def_orig( A, B )\
	ERR_GEN ( 425, chk_7 ( A ), chk_7 ( B ) )

#define ERR_dcl_nspace_unnamed_static()\
	ERR_GEN ( 426 )

#define ERR_dcl_nspace_memdef_scope( A )\
	ERR_GEN ( 427, chk_9 ( A ) )

#define ERR_dcl_nspace_alias_class( A )\
	ERR_GEN ( 428, chk_A ( A ) )

#define ERR_dcl_nspace_alias_bad( A, B )\
	ERR_GEN ( 429, chk_7 ( A ), chk_D ( B ) )

#define ERR_dcl_nspace_alias_redef( A, B )\
	ERR_GEN ( 430, chk_7 ( A ), chk_D ( B ) )

#define ERR_dcl_nspace_udecl_unqual()\
	ERR_GEN ( 431 )

#define ERR_dcl_nspace_udecl_mem( A )\
	ERR_GEN ( 432, chk_7 ( A ) )

#define ERR_dcl_nspace_udecl_base( A, B )\
	ERR_GEN ( 433, chk_7 ( A ), chk_2 ( B ) )

#define ERR_dcl_nspace_udecl_vis( A, B )\
	ERR_GEN ( 434, chk_7 ( A ), chk_2 ( B ) )

#define ERR_dcl_nspace_udecl_id( A )\
	ERR_GEN ( 435, chk_7 ( A ) )

#define ERR_dcl_nspace_udecl_constr( A )\
	ERR_GEN ( 436, chk_7 ( A ) )

#define ERR_dcl_nspace_udecl_acc( A, B )\
	ERR_GEN ( 437, chk_7 ( A ), chk_D ( B ) )

#define ERR_dcl_nspace_udecl_multi( A, B )\
	ERR_GEN ( 438, chk_7 ( A ), chk_D ( B ) )

#define ERR_dcl_nspace_udecl_redecl( A, B )\
	ERR_GEN ( 439, chk_7 ( A ), chk_D ( B ) )

#define ERR_dcl_nspace_udir_class( A )\
	ERR_GEN ( 440, chk_A ( A ) )

#define ERR_dcl_nspace_udir_dup( A )\
	ERR_GEN ( 441, chk_A ( A ) )

#define ERR_dcl_asm_ti()\
	ERR_GEN ( 442 )

#define ERR_dcl_asm_args()\
	ERR_GEN ( 443 )

#define ERR_dcl_link_unknown( A )\
	ERR_GEN ( 444, chk_F ( A ) )

#define ERR_dcl_link_scope()\
	ERR_GEN ( 445 )

#define ERR_dcl_link_lang( A, B, C )\
	ERR_GEN ( 446, chk_9 ( A ), chk_J ( B ), chk_D ( C ) )

#define ERR_dcl_link_func( A )\
	ERR_GEN ( 447, chk_J ( A ) )

#define ERR_dcl_link_conv()\
	ERR_GEN ( 448 )

#define ERR_dcl_link_over()\
	ERR_GEN ( 449 )

#define ERR_dcl_link_redecl( A, B )\
	ERR_GEN ( 450, chk_6 ( A ), chk_D ( B ) )

#define ERR_dcl_meaning_id( A, B )\
	ERR_GEN ( 451, chk_E ( A ), chk_7 ( B ) )

#define ERR_dcl_meaning_full( A, B )\
	ERR_GEN ( 452, chk_E ( A ), chk_7 ( B ) )

#define ERR_dcl_meaning_mem( A, B )\
	ERR_GEN ( 453, chk_E ( A ), chk_7 ( B ) )

#define ERR_dcl_meaning_paren()\
	ERR_GEN ( 454 )

#define ERR_dcl_ref_cv( A )\
	ERR_GEN ( 455, chk_3 ( A ) )

#define ERR_dcl_ref_cv_type( A, B )\
	ERR_GEN ( 456, chk_3 ( A ), chk_9 ( B ) )

#define ERR_dcl_ref_void( A )\
	ERR_GEN ( 457, chk_G ( A ) )

#define ERR_dcl_ref_ref()\
	ERR_GEN ( 458 )

#define ERR_dcl_ref_ptr()\
	ERR_GEN ( 459 )

#define ERR_dcl_ref_array()\
	ERR_GEN ( 460 )

#define ERR_dcl_mptr_type( A )\
	ERR_GEN ( 461, chk_7 ( A ) )

#define ERR_dcl_mptr_class( A )\
	ERR_GEN ( 462, chk_G ( A ) )

#define ERR_dcl_mptr_void( A )\
	ERR_GEN ( 463, chk_G ( A ) )

#define ERR_dcl_mptr_ref()\
	ERR_GEN ( 464 )

#define ERR_dcl_array_void( A )\
	ERR_GEN ( 465, chk_G ( A ) )

#define ERR_dcl_array_incompl()\
	ERR_GEN ( 466 )

#define ERR_dcl_array_abstract()\
	ERR_GEN ( 467 )

#define ERR_dcl_array_array()\
	ERR_GEN ( 468 )

#define ERR_dcl_array_bitf()\
	ERR_GEN ( 469 )

#define ERR_dcl_array_func()\
	ERR_GEN ( 470 )

#define ERR_dcl_array_dim_const()\
	ERR_GEN ( 471 )

#define ERR_dcl_array_dim_zero()\
	ERR_GEN ( 472 )

#define ERR_dcl_array_dim_neg( A )\
	ERR_GEN ( 473, chk_B ( A ) )

#define ERR_dcl_fct_par_void( A, B )\
	ERR_GEN ( 474, chk_7 ( A ), chk_G ( B ) )

#define ERR_dcl_fct_par_array( A, B )\
	ERR_GEN ( 475, chk_7 ( A ), chk_G ( B ) )

#define ERR_dcl_fct_par_weak()\
	ERR_GEN ( 476 )

#define ERR_dcl_fct_par_empty()\
	ERR_GEN ( 477 )

#define ERR_dcl_fct_par_ellipsis()\
	ERR_GEN ( 478 )

#define ERR_dcl_fct_weak()\
	ERR_GEN ( 479 )

#define ERR_dcl_fct_proto()\
	ERR_GEN ( 480 )

#define ERR_dcl_fct_nonproto()\
	ERR_GEN ( 481 )

#define ERR_dcl_fct_array()\
	ERR_GEN ( 482 )

#define ERR_dcl_fct_bitf()\
	ERR_GEN ( 483 )

#define ERR_dcl_fct_func()\
	ERR_GEN ( 484 )

#define ERR_dcl_fct_typedef_par()\
	ERR_GEN ( 485 )

#define ERR_dcl_fct_typedef_ret()\
	ERR_GEN ( 486 )

#define ERR_dcl_fct_cv_ret( A )\
	ERR_GEN ( 487, chk_3 ( A ) )

#define ERR_dcl_fct_cv( A )\
	ERR_GEN ( 488, chk_3 ( A ) )

#define ERR_dcl_fct_cv_decl( A )\
	ERR_GEN ( 489, chk_3 ( A ) )

#define ERR_dcl_fct_compat_ellipsis()\
	ERR_GEN ( 490 )

#define ERR_dcl_fct_compat_prom( A )\
	ERR_GEN ( 491, chk_G ( A ) )

#define ERR_dcl_fct_qual( A, B )\
	ERR_GEN ( 492, chk_3 ( A ), chk_9 ( B ) )

#define ERR_dcl_fct_ret()\
	ERR_GEN ( 493 )

#define ERR_dcl_fct_ret_void( A )\
	ERR_GEN ( 494, chk_G ( A ) )

#define ERR_dcl_fct_typedef()\
	ERR_GEN ( 495 )

#define ERR_dcl_fct_par_proto()\
	ERR_GEN ( 496 )

#define ERR_dcl_fct_par_anon()\
	ERR_GEN ( 497 )

#define ERR_dcl_fct_par_undecl( A )\
	ERR_GEN ( 498, chk_6 ( A ) )

#define ERR_dcl_fct_par_typedef( A )\
	ERR_GEN ( 499, chk_7 ( A ) )

#define ERR_dcl_fct_par_none()\
	ERR_GEN ( 500 )

#define ERR_dcl_fct_par_impl( A )\
	ERR_GEN ( 501, chk_7 ( A ) )

#define ERR_dcl_fct_par_order()\
	ERR_GEN ( 502 )

#define ERR_dcl_fct_default_bad()\
	ERR_GEN ( 503 )

#define ERR_dcl_fct_default_missing( A )\
	ERR_GEN ( 504, chk_7 ( A ) )

#define ERR_dcl_fct_default_dup( A, B )\
	ERR_GEN ( 505, chk_7 ( A ), chk_D ( B ) )

#define ERR_dcl_fct_default_redef( A, B )\
	ERR_GEN ( 506, chk_7 ( A ), chk_D ( B ) )

#define ERR_dcl_fct_default_templ()\
	ERR_GEN ( 507 )

#define ERR_dcl_fct_default_param( A )\
	ERR_GEN ( 508, chk_7 ( A ) )

#define ERR_dcl_fct_default_weak( A )\
	ERR_GEN ( 509, chk_7 ( A ) )

#define ERR_dcl_fct_def_scope()\
	ERR_GEN ( 510 )

#define ERR_dcl_fct_def_comment( A )\
	ERR_GEN ( 511, chk_9 ( A ) )

#define ERR_dcl_init_decl( A, B )\
	ERR_GEN ( 512, chk_7 ( A ), chk_J ( B ) )

#define ERR_dcl_init_typedef( A )\
	ERR_GEN ( 513, chk_7 ( A ) )

#define ERR_dcl_init_incompl()\
	ERR_GEN ( 514 )

#define ERR_dcl_init_func( A )\
	ERR_GEN ( 515, chk_9 ( A ) )

#define ERR_dcl_init_bad()\
	ERR_GEN ( 516 )

#define ERR_dcl_init_const()\
	ERR_GEN ( 517 )

#define ERR_dcl_init_ctor( A )\
	ERR_GEN ( 518, chk_G ( A ) )

#define ERR_dcl_init_conv()\
	ERR_GEN ( 519 )

#define ERR_dcl_init_assign()\
	ERR_GEN ( 520 )

#define ERR_dcl_init_dynamic()\
	ERR_GEN ( 521 )

#define ERR_dcl_init_aggr_array_bad()\
	ERR_GEN ( 522 )

#define ERR_dcl_init_aggr_dynamic()\
	ERR_GEN ( 523 )

#define ERR_dcl_init_aggr_array_ti( A, B )\
	ERR_GEN ( 524, chk_B ( A ), chk_G ( B ) )

#define ERR_dcl_init_aggr_excess( A )\
	ERR_GEN ( 525, chk_G ( A ) )

#define ERR_dcl_init_aggr_pad( A, B )\
	ERR_GEN ( 526, chk_B ( A ), chk_G ( B ) )

#define ERR_dcl_init_aggr_type( A )\
	ERR_GEN ( 527, chk_G ( A ) )

#define ERR_dcl_init_aggr_empty()\
	ERR_GEN ( 528 )

#define ERR_dcl_init_aggr_no_scalar()\
	ERR_GEN ( 529 )

#define ERR_dcl_init_aggr_nest()\
	ERR_GEN ( 530 )

#define ERR_dcl_init_aggr_partial()\
	ERR_GEN ( 531 )

#define ERR_dcl_init_aggr_auto( A )\
	ERR_GEN ( 532, chk_7 ( A ) )

#define ERR_dcl_init_string_char()\
	ERR_GEN ( 533 )

#define ERR_dcl_init_string_wchar()\
	ERR_GEN ( 534 )

#define ERR_dcl_init_string_excess( A )\
	ERR_GEN ( 535, chk_G ( A ) )

#define ERR_dcl_init_string_zero( A )\
	ERR_GEN ( 536, chk_G ( A ) )

#define ERR_dcl_init_ref_none()\
	ERR_GEN ( 537 )

#define ERR_dcl_init_ref_ambig()\
	ERR_GEN ( 538 )

#define ERR_dcl_init_ref_const()\
	ERR_GEN ( 539 )

#define ERR_dcl_init_ref_qual( A )\
	ERR_GEN ( 540, chk_3 ( A ) )

#define ERR_dcl_init_ref_func()\
	ERR_GEN ( 541 )

#define ERR_dcl_init_ref_tmp( A )\
	ERR_GEN ( 542, chk_G ( A ) )

#define ERR_class_none()\
	ERR_GEN ( 543 )

#define ERR_class_mem_empty()\
	ERR_GEN ( 544 )

#define ERR_class_mem_declarator()\
	ERR_GEN ( 545 )

#define ERR_class_mem_semicolon()\
	ERR_GEN ( 546 )

#define ERR_class_mem_anon()\
	ERR_GEN ( 547 )

#define ERR_class_mem_ds_empty()\
	ERR_GEN ( 548 )

#define ERR_class_mem_redecl( A, B )\
	ERR_GEN ( 549, chk_7 ( A ), chk_D ( B ) )

#define ERR_class_mem_incompl_mem( A )\
	ERR_GEN ( 550, chk_7 ( A ) )

#define ERR_class_mem_init_mem( A )\
	ERR_GEN ( 551, chk_9 ( A ) )

#define ERR_class_mem_def( A )\
	ERR_GEN ( 552, chk_9 ( A ) )

#define ERR_class_mem_init_const()\
	ERR_GEN ( 553 )

#define ERR_class_mem_incompl_stat( A )\
	ERR_GEN ( 554, chk_7 ( A ) )

#define ERR_class_mem_ctor( A )\
	ERR_GEN ( 555, chk_7 ( A ) )

#define ERR_class_mem_ctor_data( A )\
	ERR_GEN ( 556, chk_7 ( A ) )

#define ERR_class_mem_ref( A )\
	ERR_GEN ( 557, chk_2 ( A ) )

#define ERR_class_mem_const( A )\
	ERR_GEN ( 558, chk_2 ( A ) )

#define ERR_class_mfct_eof( A )\
	ERR_GEN ( 559, chk_9 ( A ) )

#define ERR_class_mfct_scope( A )\
	ERR_GEN ( 560, chk_9 ( A ) )

#define ERR_class_mfct_redecl( A )\
	ERR_GEN ( 561, chk_9 ( A ) )

#define ERR_class_this_qual( A )\
	ERR_GEN ( 562, chk_3 ( A ) )

#define ERR_class_static_mfct_virt()\
	ERR_GEN ( 563 )

#define ERR_class_static_data_init( A, B )\
	ERR_GEN ( 564, chk_7 ( A ), chk_G ( B ) )

#define ERR_class_static_data_const( A, B )\
	ERR_GEN ( 565, chk_7 ( A ), chk_G ( B ) )

#define ERR_class_static_data_def( A, B )\
	ERR_GEN ( 566, chk_7 ( A ), chk_D ( B ) )

#define ERR_class_static_data_scope( A )\
	ERR_GEN ( 567, chk_7 ( A ) )

#define ERR_class_static_data_anon( A )\
	ERR_GEN ( 568, chk_7 ( A ) )

#define ERR_class_union_deriv( A )\
	ERR_GEN ( 569, chk_2 ( A ) )

#define ERR_class_union_base( A )\
	ERR_GEN ( 570, chk_2 ( A ) )

#define ERR_class_union_static( A )\
	ERR_GEN ( 571, chk_2 ( A ) )

#define ERR_class_union_virtual( A )\
	ERR_GEN ( 572, chk_2 ( A ) )

#define ERR_class_union_ref( A, B )\
	ERR_GEN ( 573, chk_2 ( A ), chk_G ( B ) )

#define ERR_class_union_mem( A, B )\
	ERR_GEN ( 574, chk_2 ( A ), chk_G ( B ) )

#define ERR_class_union_anon_private()\
	ERR_GEN ( 575 )

#define ERR_class_union_anon_func()\
	ERR_GEN ( 576 )

#define ERR_class_union_anon_static()\
	ERR_GEN ( 577 )

#define ERR_class_union_anon_mem()\
	ERR_GEN ( 578 )

#define ERR_class_bit_base( A )\
	ERR_GEN ( 579, chk_G ( A ) )

#define ERR_class_bit_base_int( A )\
	ERR_GEN ( 580, chk_G ( A ) )

#define ERR_class_bit_sign( A )\
	ERR_GEN ( 581, chk_1 ( A ) )

#define ERR_class_bit_dim_const()\
	ERR_GEN ( 582 )

#define ERR_class_bit_dim_zero()\
	ERR_GEN ( 583 )

#define ERR_class_bit_dim_neg( A )\
	ERR_GEN ( 584, chk_B ( A ) )

#define ERR_class_bit_dim_big( A, B )\
	ERR_GEN ( 585, chk_B ( A ), chk_G ( B ) )

#define ERR_class_bit_static()\
	ERR_GEN ( 586 )

#define ERR_class_bit_typedef()\
	ERR_GEN ( 587 )

#define ERR_class_bit_ptr()\
	ERR_GEN ( 588 )

#define ERR_class_bit_ref()\
	ERR_GEN ( 589 )

#define ERR_class_bit_mptr()\
	ERR_GEN ( 590 )

#define ERR_class_local_func( A )\
	ERR_GEN ( 591, chk_9 ( A ) )

#define ERR_class_local_static( A )\
	ERR_GEN ( 592, chk_7 ( A ) )

#define ERR_class_local_auto( A )\
	ERR_GEN ( 593, chk_7 ( A ) )

#define ERR_class_derived_class( A )\
	ERR_GEN ( 594, chk_G ( A ) )

#define ERR_class_derived_incompl()\
	ERR_GEN ( 595 )

#define ERR_class_derived_empty( A )\
	ERR_GEN ( 596, chk_2 ( A ) )

#define ERR_class_derived_base( A, B )\
	ERR_GEN ( 597, chk_2 ( A ), chk_2 ( B ) )

#define ERR_class_derived_virt( A, B )\
	ERR_GEN ( 598, chk_2 ( A ), chk_2 ( B ) )

#define ERR_class_mi_dup( A, B )\
	ERR_GEN ( 599, chk_2 ( A ), chk_2 ( B ) )

#define ERR_class_member_lookup_ambig( A, B )\
	ERR_GEN ( 600, chk_2 ( A ), chk_2 ( B ) )

#define ERR_class_member_lookup_func()\
	ERR_GEN ( 601 )

#define ERR_class_virtual_poly( A )\
	ERR_GEN ( 602, chk_2 ( A ) )

#define ERR_class_virtual_override( A )\
	ERR_GEN ( 603, chk_6 ( A ) )

#define ERR_class_virtual_hide( A, B )\
	ERR_GEN ( 604, chk_6 ( A ), chk_9 ( B ) )

#define ERR_class_virtual_ret( A, B, C )\
	ERR_GEN ( 605, chk_7 ( A ), chk_9 ( B ), chk_D ( C ) )

#define ERR_class_virtual_darg( A )\
	ERR_GEN ( 606, chk_7 ( A ) )

#define ERR_class_virtual_ambig( A, B )\
	ERR_GEN ( 607, chk_7 ( A ), chk_9 ( B ) )

#define ERR_class_virtual_final( A, B )\
	ERR_GEN ( 608, chk_9 ( A ), chk_2 ( B ) )

#define ERR_class_virtual_destr( A )\
	ERR_GEN ( 609, chk_2 ( A ) )

#define ERR_class_virtual_not( A )\
	ERR_GEN ( 610, chk_9 ( A ) )

#define ERR_class_abstract_virt()\
	ERR_GEN ( 611 )

#define ERR_class_abstract_zero()\
	ERR_GEN ( 612 )

#define ERR_class_abstract_class( A )\
	ERR_GEN ( 613, chk_2 ( A ) )

#define ERR_class_abstract_pure( A )\
	ERR_GEN ( 614, chk_9 ( A ) )

#define ERR_class_abstract_decl( A )\
	ERR_GEN ( 615, chk_7 ( A ) )

#define ERR_class_abstract_mem( A )\
	ERR_GEN ( 616, chk_7 ( A ) )

#define ERR_class_abstract_par()\
	ERR_GEN ( 617 )

#define ERR_class_abstract_ret()\
	ERR_GEN ( 618 )

#define ERR_class_abstract_cast()\
	ERR_GEN ( 619 )

#define ERR_class_abstract_call( A )\
	ERR_GEN ( 620, chk_9 ( A ) )

#define ERR_class_access_spec_priv( A )\
	ERR_GEN ( 621, chk_2 ( A ) )

#define ERR_class_access_spec_id( A, B, C )\
	ERR_GEN ( 622, chk_9 ( A ), chk_0 ( B ), chk_9 ( C ) )

#define ERR_class_access_spec_none( A, B )\
	ERR_GEN ( 623, chk_9 ( A ), chk_0 ( B ) )

#define ERR_class_access_spec_change( A, B )\
	ERR_GEN ( 624, chk_9 ( A ), chk_D ( B ) )

#define ERR_class_access_base_acc( A, B )\
	ERR_GEN ( 625, chk_9 ( A ), chk_0 ( B ) )

#define ERR_class_access_base_id( A, B, C, D )\
	ERR_GEN ( 626, chk_2 ( A ), chk_2 ( B ), chk_0 ( C ), chk_9 ( D ) )

#define ERR_class_access_base_none( A, B, C )\
	ERR_GEN ( 627, chk_2 ( A ), chk_2 ( B ), chk_0 ( C ) )

#define ERR_class_access_dcl_using( A )\
	ERR_GEN ( 628, chk_7 ( A ) )

#define ERR_class_friend_decl()\
	ERR_GEN ( 629 )

#define ERR_class_friend_elab()\
	ERR_GEN ( 630 )

#define ERR_class_friend_storage( A )\
	ERR_GEN ( 631, chk_4 ( A ) )

#define ERR_class_friend_def()\
	ERR_GEN ( 632 )

#define ERR_class_friend_local()\
	ERR_GEN ( 633 )

#define ERR_class_friend_pre( A )\
	ERR_GEN ( 634, chk_7 ( A ) )

#define ERR_class_friend_dup_func( A, B )\
	ERR_GEN ( 635, chk_9 ( A ), chk_2 ( B ) )

#define ERR_class_friend_dup_class( A, B )\
	ERR_GEN ( 636, chk_2 ( A ), chk_2 ( B ) )

#define ERR_class_special_decl( A )\
	ERR_GEN ( 637, chk_9 ( A ) )

#define ERR_class_ctor_static()\
	ERR_GEN ( 638 )

#define ERR_class_ctor_virtual()\
	ERR_GEN ( 639 )

#define ERR_class_ctor_ret( A )\
	ERR_GEN ( 640, chk_6 ( A ) )

#define ERR_class_ctor_qual( A, B )\
	ERR_GEN ( 641, chk_6 ( A ), chk_3 ( B ) )

#define ERR_class_ctor_result( A )\
	ERR_GEN ( 642, chk_9 ( A ) )

#define ERR_class_ctor_addr( A )\
	ERR_GEN ( 643, chk_9 ( A ) )

#define ERR_class_ctor_default( A )\
	ERR_GEN ( 644, chk_2 ( A ) )

#define ERR_class_ctor_user( A )\
	ERR_GEN ( 645, chk_2 ( A ) )

#define ERR_class_ctor_nontriv( A )\
	ERR_GEN ( 646, chk_2 ( A ) )

#define ERR_class_ctor_make( A )\
	ERR_GEN ( 647, chk_2 ( A ) )

#define ERR_class_ctor_private( A )\
	ERR_GEN ( 648, chk_2 ( A ) )

#define ERR_class_conv_fct_typedef( A )\
	ERR_GEN ( 649, chk_6 ( A ) )

#define ERR_class_conv_fct_ret( A )\
	ERR_GEN ( 650, chk_6 ( A ) )

#define ERR_class_conv_fct_ret_bad( A, B )\
	ERR_GEN ( 651, chk_6 ( A ), chk_G ( B ) )

#define ERR_class_conv_fct_pars( A )\
	ERR_GEN ( 652, chk_6 ( A ) )

#define ERR_class_conv_fct_void( A )\
	ERR_GEN ( 653, chk_6 ( A ) )

#define ERR_class_conv_fct_mem()\
	ERR_GEN ( 654 )

#define ERR_class_dtor_static()\
	ERR_GEN ( 655 )

#define ERR_class_dtor_ret( A )\
	ERR_GEN ( 656, chk_6 ( A ) )

#define ERR_class_dtor_pars( A )\
	ERR_GEN ( 657, chk_6 ( A ) )

#define ERR_class_dtor_func( A )\
	ERR_GEN ( 658, chk_6 ( A ) )

#define ERR_class_dtor_inherit( A, B )\
	ERR_GEN ( 659, chk_6 ( A ), chk_A ( B ) )

#define ERR_class_dtor_qual( A, B )\
	ERR_GEN ( 660, chk_6 ( A ), chk_3 ( B ) )

#define ERR_class_dtor_default( A )\
	ERR_GEN ( 661, chk_2 ( A ) )

#define ERR_class_dtor_nontriv( A )\
	ERR_GEN ( 662, chk_2 ( A ) )

#define ERR_class_dtor_result( A )\
	ERR_GEN ( 663, chk_9 ( A ) )

#define ERR_class_dtor_addr( A )\
	ERR_GEN ( 664, chk_9 ( A ) )

#define ERR_class_dtor_private( A )\
	ERR_GEN ( 665, chk_2 ( A ) )

#define ERR_class_dtor_three( A )\
	ERR_GEN ( 666, chk_2 ( A ) )

#define ERR_class_free_static( A )\
	ERR_GEN ( 667, chk_6 ( A ) )

#define ERR_class_base_init_bad( A )\
	ERR_GEN ( 668, chk_9 ( A ) )

#define ERR_class_base_init_empty( A )\
	ERR_GEN ( 669, chk_9 ( A ) )

#define ERR_class_base_init_old( A )\
	ERR_GEN ( 670, chk_9 ( A ) )

#define ERR_class_base_init_uniq( A )\
	ERR_GEN ( 671, chk_2 ( A ) )

#define ERR_class_base_init_static( A )\
	ERR_GEN ( 672, chk_7 ( A ) )

#define ERR_class_base_init_inherit( A )\
	ERR_GEN ( 673, chk_7 ( A ) )

#define ERR_class_base_init_base( A )\
	ERR_GEN ( 674, chk_2 ( A ) )

#define ERR_class_base_init_ambig( A )\
	ERR_GEN ( 675, chk_2 ( A ) )

#define ERR_class_base_init_dup( A )\
	ERR_GEN ( 676, chk_7 ( A ) )

#define ERR_class_base_init_none( A )\
	ERR_GEN ( 677, chk_7 ( A ) )

#define ERR_class_base_init_order( A )\
	ERR_GEN ( 678, chk_7 ( A ) )

#define ERR_class_base_init_union( A )\
	ERR_GEN ( 679, chk_2 ( A ) )

#define ERR_class_base_init_anon( A )\
	ERR_GEN ( 680, chk_7 ( A ) )

#define ERR_class_base_init_err( A )\
	ERR_GEN ( 681, chk_9 ( A ) )

#define ERR_class_base_init_impl( A )\
	ERR_GEN ( 682, chk_9 ( A ) )

#define ERR_class_copy_bad( A )\
	ERR_GEN ( 683, chk_6 ( A ) )

#define ERR_class_copy_constr( A )\
	ERR_GEN ( 684, chk_2 ( A ) )

#define ERR_class_copy_assign( A )\
	ERR_GEN ( 685, chk_2 ( A ) )

#define ERR_class_copy_nontriv_constr( A )\
	ERR_GEN ( 686, chk_2 ( A ) )

#define ERR_class_copy_nontriv_assign( A )\
	ERR_GEN ( 687, chk_2 ( A ) )

#define ERR_class_copy_ptr()\
	ERR_GEN ( 688 )

#define ERR_over_load_pars()\
	ERR_GEN ( 689 )

#define ERR_over_match_call_mem( A )\
	ERR_GEN ( 690, chk_7 ( A ) )

#define ERR_over_match_call_ok( A )\
	ERR_GEN ( 691, chk_9 ( A ) )

#define ERR_over_match_call_target( A )\
	ERR_GEN ( 692, chk_7 ( A ) )

#define ERR_over_match_call_ambig( A )\
	ERR_GEN ( 693, chk_7 ( A ) )

#define ERR_over_match_oper_ok( A )\
	ERR_GEN ( 694, chk_9 ( A ) )

#define ERR_over_match_oper_target( A )\
	ERR_GEN ( 695, chk_8 ( A ) )

#define ERR_over_match_oper_ambig( A )\
	ERR_GEN ( 696, chk_8 ( A ) )

#define ERR_over_match_oper_arrow()\
	ERR_GEN ( 697 )

#define ERR_over_match_ctor_ok( A )\
	ERR_GEN ( 698, chk_9 ( A ) )

#define ERR_over_match_ctor_target( A )\
	ERR_GEN ( 699, chk_7 ( A ) )

#define ERR_over_match_ctor_ambig( A )\
	ERR_GEN ( 700, chk_7 ( A ) )

#define ERR_over_match_ctor_none( A )\
	ERR_GEN ( 701, chk_7 ( A ) )

#define ERR_over_match_conv_ok( A )\
	ERR_GEN ( 702, chk_9 ( A ) )

#define ERR_over_match_conv_target( A, B )\
	ERR_GEN ( 703, chk_G ( A ), chk_G ( B ) )

#define ERR_over_match_conv_ambig( A, B )\
	ERR_GEN ( 704, chk_G ( A ), chk_G ( B ) )

#define ERR_over_match_conv_dup( A )\
	ERR_GEN ( 705, chk_G ( A ) )

#define ERR_over_match_viable_none( A )\
	ERR_GEN ( 706, chk_7 ( A ) )

#define ERR_over_match_viable_list()\
	ERR_GEN ( 707 )

#define ERR_over_match_best_install()\
	ERR_GEN ( 708 )

#define ERR_over_match_best_common()\
	ERR_GEN ( 709 )

#define ERR_over_over_context( A )\
	ERR_GEN ( 710, chk_7 ( A ) )

#define ERR_over_over_none( A, B )\
	ERR_GEN ( 711, chk_7 ( A ), chk_G ( B ) )

#define ERR_over_over_ok( A )\
	ERR_GEN ( 712, chk_9 ( A ) )

#define ERR_over_oper_bad( A )\
	ERR_GEN ( 713, chk_8 ( A ) )

#define ERR_over_oper_static()\
	ERR_GEN ( 714 )

#define ERR_over_oper_type( A )\
	ERR_GEN ( 715, chk_6 ( A ) )

#define ERR_over_oper_default( A )\
	ERR_GEN ( 716, chk_6 ( A ) )

#define ERR_over_oper_func( A )\
	ERR_GEN ( 717, chk_7 ( A ) )

#define ERR_over_unary_pars( A, B, C )\
	ERR_GEN ( 718, chk_6 ( A ), chk_M ( B ), chk_N ( C ) )

#define ERR_over_binary_pars_p2( A, B, C )\
	ERR_GEN ( 719, chk_6 ( A ), chk_M ( B ), chk_N ( C ) )

#define ERR_over_binary_pars_p1( A, B, C, D )\
	ERR_GEN ( 720, chk_6 ( A ), chk_M ( B ), chk_M ( C ), chk_N ( D ) )

#define ERR_over_ass_mem( A )\
	ERR_GEN ( 721, chk_6 ( A ) )

#define ERR_over_ass_pars( A, B, C )\
	ERR_GEN ( 722, chk_6 ( A ), chk_M ( B ), chk_N ( C ) )

#define ERR_over_call_mem( A )\
	ERR_GEN ( 723, chk_6 ( A ) )

#define ERR_over_sub_mem( A )\
	ERR_GEN ( 724, chk_6 ( A ) )

#define ERR_over_sub_pars( A, B, C )\
	ERR_GEN ( 725, chk_6 ( A ), chk_M ( B ), chk_N ( C ) )

#define ERR_over_ref_mem( A )\
	ERR_GEN ( 726, chk_6 ( A ) )

#define ERR_over_ref_pars( A, B, C )\
	ERR_GEN ( 727, chk_6 ( A ), chk_M ( B ), chk_N ( C ) )

#define ERR_over_inc_pars( A, B, C, D )\
	ERR_GEN ( 728, chk_6 ( A ), chk_M ( B ), chk_M ( C ), chk_N ( D ) )

#define ERR_over_inc_pars_p2( A, B )\
	ERR_GEN ( 729, chk_6 ( A ), chk_G ( B ) )

#define ERR_temp_decl_bad()\
	ERR_GEN ( 730 )

#define ERR_temp_decl_scope()\
	ERR_GEN ( 731 )

#define ERR_temp_decl_func()\
	ERR_GEN ( 732 )

#define ERR_temp_decl_one()\
	ERR_GEN ( 733 )

#define ERR_temp_decl_linkage()\
	ERR_GEN ( 734 )

#define ERR_temp_decl_export( A )\
	ERR_GEN ( 735, chk_7 ( A ) )

#define ERR_temp_decl_undef( A )\
	ERR_GEN ( 736, chk_9 ( A ) )

#define ERR_temp_param_eof()\
	ERR_GEN ( 737 )

#define ERR_temp_param_dup( A )\
	ERR_GEN ( 738, chk_6 ( A ) )

#define ERR_temp_param_type( A, B )\
	ERR_GEN ( 739, chk_7 ( A ), chk_G ( B ) )

#define ERR_temp_param_dcl_stc( A )\
	ERR_GEN ( 740, chk_4 ( A ) )

#define ERR_temp_param_default( A )\
	ERR_GEN ( 741, chk_7 ( A ) )

#define ERR_temp_param_func()\
	ERR_GEN ( 742 )

#define ERR_temp_param_redecl()\
	ERR_GEN ( 743 )

#define ERR_temp_param_none( A )\
	ERR_GEN ( 744, chk_9 ( A ) )

#define ERR_temp_names_eof( A )\
	ERR_GEN ( 745, chk_9 ( A ) )

#define ERR_temp_names_hack()\
	ERR_GEN ( 746 )

#define ERR_temp_names_bad()\
	ERR_GEN ( 747 )

#define ERR_temp_names_not( A )\
	ERR_GEN ( 748, chk_7 ( A ) )

#define ERR_temp_names_mem( A )\
	ERR_GEN ( 749, chk_7 ( A ) )

#define ERR_temp_arg_type( A, B )\
	ERR_GEN ( 750, chk_7 ( A ), chk_9 ( B ) )

#define ERR_temp_arg_exp( A, B )\
	ERR_GEN ( 751, chk_7 ( A ), chk_9 ( B ) )

#define ERR_temp_arg_less( A )\
	ERR_GEN ( 752, chk_9 ( A ) )

#define ERR_temp_arg_more( A )\
	ERR_GEN ( 753, chk_9 ( A ) )

#define ERR_temp_arg_local( A )\
	ERR_GEN ( 754, chk_G ( A ) )

#define ERR_temp_arg_const()\
	ERR_GEN ( 755 )

#define ERR_temp_arg_internal()\
	ERR_GEN ( 756 )

#define ERR_temp_arg_over()\
	ERR_GEN ( 757 )

#define ERR_temp_arg_bad()\
	ERR_GEN ( 758 )

#define ERR_temp_arg_init( A, B )\
	ERR_GEN ( 759, chk_7 ( A ), chk_9 ( B ) )

#define ERR_temp_arg_templ( A, B )\
	ERR_GEN ( 760, chk_7 ( A ), chk_9 ( B ) )

#define ERR_temp_arg_templ_not( A, B )\
	ERR_GEN ( 761, chk_7 ( A ), chk_7 ( B ) )

#define ERR_temp_arg_templ_bad( A, B )\
	ERR_GEN ( 762, chk_7 ( A ), chk_G ( B ) )

#define ERR_temp_mem_virtual()\
	ERR_GEN ( 763 )

#define ERR_temp_mem_destr()\
	ERR_GEN ( 764 )

#define ERR_temp_mem_local()\
	ERR_GEN ( 765 )

#define ERR_temp_class_spec_primary( A )\
	ERR_GEN ( 766, chk_G ( A ) )

#define ERR_temp_class_spec_depend( A )\
	ERR_GEN ( 767, chk_G ( A ) )

#define ERR_temp_class_spec_darg()\
	ERR_GEN ( 768 )

#define ERR_temp_class_spec_ambig( A )\
	ERR_GEN ( 769, chk_G ( A ) )

#define ERR_temp_class_spec_match( A )\
	ERR_GEN ( 770, chk_9 ( A ) )

#define ERR_temp_res_nspace( A, B )\
	ERR_GEN ( 771, chk_A ( A ), chk_G ( B ) )

#define ERR_temp_res_qual()\
	ERR_GEN ( 772 )

#define ERR_temp_res_type( A, B )\
	ERR_GEN ( 773, chk_A ( A ), chk_6 ( B ) )

#define ERR_temp_res_key( A, B, C, D )\
	ERR_GEN ( 774, chk_1 ( A ), chk_7 ( B ), chk_9 ( C ), chk_G ( D ) )

#define ERR_temp_local_not( A )\
	ERR_GEN ( 775, chk_G ( A ) )

#define ERR_temp_local_hide( A )\
	ERR_GEN ( 776, chk_7 ( A ) )

#define ERR_temp_spec_type( A, B )\
	ERR_GEN ( 777, chk_G ( A ), chk_7 ( B ) )

#define ERR_temp_spec_bad( A )\
	ERR_GEN ( 778, chk_G ( A ) )

#define ERR_temp_spec_member( A )\
	ERR_GEN ( 779, chk_9 ( A ) )

#define ERR_temp_spec_prefix()\
	ERR_GEN ( 780 )

#define ERR_temp_spec_reinst( A )\
	ERR_GEN ( 781, chk_G ( A ) )

#define ERR_temp_spec_respec( A )\
	ERR_GEN ( 782, chk_G ( A ) )

#define ERR_temp_spec_redecl( A )\
	ERR_GEN ( 783, chk_G ( A ) )

#define ERR_temp_spec_used( A )\
	ERR_GEN ( 784, chk_G ( A ) )

#define ERR_temp_spec_post( A, B )\
	ERR_GEN ( 785, chk_G ( A ), chk_G ( B ) )

#define ERR_temp_inst_def( A )\
	ERR_GEN ( 786, chk_G ( A ) )

#define ERR_temp_inst_depth( A )\
	ERR_GEN ( 787, chk_L ( A ) )

#define ERR_temp_inst_comment( A, B )\
	ERR_GEN ( 788, chk_G ( A ), chk_D ( B ) )

#define ERR_temp_explicit_bad( A )\
	ERR_GEN ( 789, chk_9 ( A ) )

#define ERR_temp_explicit_id( A )\
	ERR_GEN ( 790, chk_7 ( A ) )

#define ERR_temp_explicit_def()\
	ERR_GEN ( 791 )

#define ERR_temp_explicit_incompl()\
	ERR_GEN ( 792 )

#define ERR_temp_explicit_templ()\
	ERR_GEN ( 793 )

#define ERR_temp_expl_spec_dargs()\
	ERR_GEN ( 794 )

#define ERR_temp_deduct_fail( A )\
	ERR_GEN ( 795, chk_9 ( A ) )

#define ERR_temp_deduct_undef( A, B )\
	ERR_GEN ( 796, chk_7 ( A ), chk_9 ( B ) )

#define ERR_except_handlers()\
	ERR_GEN ( 797 )

#define ERR_except_not()\
	ERR_GEN ( 798 )

#define ERR_except_jump_into()\
	ERR_GEN ( 799 )

#define ERR_except_throw_type()\
	ERR_GEN ( 800 )

#define ERR_except_throw_typedef()\
	ERR_GEN ( 801 )

#define ERR_except_throw_copy()\
	ERR_GEN ( 802 )

#define ERR_except_throw_incompl()\
	ERR_GEN ( 803 )

#define ERR_except_throw_ambig()\
	ERR_GEN ( 804 )

#define ERR_except_handle_typedef()\
	ERR_GEN ( 805 )

#define ERR_except_handle_unreach( A, B )\
	ERR_GEN ( 806, chk_G ( A ), chk_G ( B ) )

#define ERR_except_handle_ellipsis()\
	ERR_GEN ( 807 )

#define ERR_except_handle_incompl()\
	ERR_GEN ( 808 )

#define ERR_except_handle_return( A )\
	ERR_GEN ( 809, chk_7 ( A ) )

#define ERR_except_spec_bad()\
	ERR_GEN ( 810 )

#define ERR_except_spec_typedef()\
	ERR_GEN ( 811 )

#define ERR_except_spec_ellipsis()\
	ERR_GEN ( 812 )

#define ERR_except_spec_incompl()\
	ERR_GEN ( 813 )

#define ERR_except_spec_wrong( A, B )\
	ERR_GEN ( 814, chk_7 ( A ), chk_D ( B ) )

#define ERR_except_spec_virtual( A, B, C )\
	ERR_GEN ( 815, chk_7 ( A ), chk_9 ( B ), chk_D ( C ) )

#define ERR_except_spec_assign()\
	ERR_GEN ( 816 )

#define ERR_except_spec_init()\
	ERR_GEN ( 817 )

#define ERR_except_spec_throw( A )\
	ERR_GEN ( 818, chk_G ( A ) )

#define ERR_except_spec_call( A, B )\
	ERR_GEN ( 819, chk_9 ( A ), chk_G ( B ) )

#define ERR_cpp_bad()\
	ERR_GEN ( 820 )

#define ERR_cpp_unknown( A )\
	ERR_GEN ( 821, chk_6 ( A ) )

#define ERR_cpp_end( A )\
	ERR_GEN ( 822, chk_8 ( A ) )

#define ERR_cpp_indent()\
	ERR_GEN ( 823 )

#define ERR_cpp_indent_dir()\
	ERR_GEN ( 824 )

#define ERR_cpp_space_replace()\
	ERR_GEN ( 825 )

#define ERR_cpp_old( A )\
	ERR_GEN ( 826, chk_8 ( A ) )

#define ERR_cpp_cond_if_match( A, B )\
	ERR_GEN ( 827, chk_8 ( A ), chk_8 ( B ) )

#define ERR_cpp_cond_else_dup( A, B, C )\
	ERR_GEN ( 828, chk_8 ( A ), chk_8 ( B ), chk_D ( C ) )

#define ERR_cpp_cond_def_id()\
	ERR_GEN ( 829 )

#define ERR_cpp_cond_def_replace()\
	ERR_GEN ( 830 )

#define ERR_cpp_cond_ifdef_id( A )\
	ERR_GEN ( 831, chk_8 ( A ) )

#define ERR_cpp_cond_zero( A )\
	ERR_GEN ( 832, chk_6 ( A ) )

#define ERR_cpp_cond_if_const( A )\
	ERR_GEN ( 833, chk_8 ( A ) )

#define ERR_cpp_cond_if_ti( A )\
	ERR_GEN ( 834, chk_8 ( A ) )

#define ERR_cpp_cond_if_ti_decl( A )\
	ERR_GEN ( 835, chk_8 ( A ) )

#define ERR_cpp_cond_if_jump_into()\
	ERR_GEN ( 836 )

#define ERR_cpp_cond_if_macro( A )\
	ERR_GEN ( 837, chk_6 ( A ) )

#define ERR_cpp_cond_endif_end( A )\
	ERR_GEN ( 838, chk_8 ( A ) )

#define ERR_cpp_include_bad()\
	ERR_GEN ( 839 )

#define ERR_cpp_include_incompl()\
	ERR_GEN ( 840 )

#define ERR_cpp_include_undef( A )\
	ERR_GEN ( 841, chk_J ( A ) )

#define ERR_cpp_include_empty()\
	ERR_GEN ( 842 )

#define ERR_cpp_include_full( A )\
	ERR_GEN ( 843, chk_J ( A ) )

#define ERR_cpp_include_unknown( A )\
	ERR_GEN ( 844, chk_J ( A ) )

#define ERR_cpp_include_open( A )\
	ERR_GEN ( 845, chk_J ( A ) )

#define ERR_cpp_include_close( A )\
	ERR_GEN ( 846, chk_J ( A ) )

#define ERR_cpp_include_depth( A )\
	ERR_GEN ( 847, chk_L ( A ) )

#define ERR_cpp_include_dup( A, B )\
	ERR_GEN ( 848, chk_J ( A ), chk_D ( B ) )

#define ERR_cpp_include_date()\
	ERR_GEN ( 849 )

#define ERR_cpp_replace_id( A )\
	ERR_GEN ( 850, chk_8 ( A ) )

#define ERR_cpp_replace_redef_ok( A, B )\
	ERR_GEN ( 851, chk_7 ( A ), chk_D ( B ) )

#define ERR_cpp_replace_redef_bad( A, B )\
	ERR_GEN ( 852, chk_7 ( A ), chk_D ( B ) )

#define ERR_cpp_replace_redef_weak( A, B )\
	ERR_GEN ( 853, chk_7 ( A ), chk_D ( B ) )

#define ERR_cpp_replace_redef_space( A, B )\
	ERR_GEN ( 854, chk_7 ( A ), chk_D ( B ) )

#define ERR_cpp_replace_redef_nest( A, B )\
	ERR_GEN ( 855, chk_7 ( A ), chk_D ( B ) )

#define ERR_cpp_replace_par_dup( A, B )\
	ERR_GEN ( 856, chk_6 ( A ), chk_6 ( B ) )

#define ERR_cpp_replace_par_bad( A )\
	ERR_GEN ( 857, chk_6 ( A ) )

#define ERR_cpp_replace_arg_none( A )\
	ERR_GEN ( 858, chk_6 ( A ) )

#define ERR_cpp_replace_arg_empty( A, B )\
	ERR_GEN ( 859, chk_M ( A ), chk_6 ( B ) )

#define ERR_cpp_replace_arg_ppdir( A )\
	ERR_GEN ( 860, chk_6 ( A ) )

#define ERR_cpp_replace_arg_eof( A )\
	ERR_GEN ( 861, chk_6 ( A ) )

#define ERR_cpp_replace_arg_number( A, B, C, D )\
	ERR_GEN ( 862, chk_6 ( A ), chk_M ( B ), chk_N ( C ), chk_M ( D ) )

#define ERR_cpp_stringize_par( A )\
	ERR_GEN ( 863, chk_6 ( A ) )

#define ERR_cpp_stringize_bad( A )\
	ERR_GEN ( 864, chk_6 ( A ) )

#define ERR_cpp_stringize_old( A, B )\
	ERR_GEN ( 865, chk_6 ( A ), chk_6 ( B ) )

#define ERR_cpp_concat_place( A )\
	ERR_GEN ( 866, chk_6 ( A ) )

#define ERR_cpp_concat_bad( A )\
	ERR_GEN ( 867, chk_6 ( A ) )

#define ERR_cpp_rescan_recursive( A )\
	ERR_GEN ( 868, chk_6 ( A ) )

#define ERR_cpp_scope_id( A )\
	ERR_GEN ( 869, chk_8 ( A ) )

#define ERR_cpp_scope_undef( A )\
	ERR_GEN ( 870, chk_6 ( A ) )

#define ERR_cpp_line_bad( A )\
	ERR_GEN ( 871, chk_8 ( A ) )

#define ERR_cpp_line_float( A )\
	ERR_GEN ( 872, chk_8 ( A ) )

#define ERR_cpp_line_range( A )\
	ERR_GEN ( 873, chk_8 ( A ) )

#define ERR_cpp_error_msg( A )\
	ERR_GEN ( 874, chk_J ( A ) )

#define ERR_cpp_pragma_unknown( A )\
	ERR_GEN ( 875, chk_8 ( A ) )

#define ERR_cpp_null()\
	ERR_GEN ( 876 )

#define ERR_cpp_predef_bad( A, B )\
	ERR_GEN ( 877, chk_6 ( A ), chk_8 ( B ) )

#define ERR_cpp_predef_undef( A )\
	ERR_GEN ( 878, chk_7 ( A ) )

#define ERR_cpp_predef_redef( A )\
	ERR_GEN ( 879, chk_7 ( A ) )

#define ERR_cpp_predef_keyword( A )\
	ERR_GEN ( 880, chk_6 ( A ) )

#define ERR_lib_builtin( A, B )\
	ERR_GEN ( 881, chk_J ( A ), chk_6 ( B ) )

#define ERR_printf_unknown( A )\
	ERR_GEN ( 882, chk_J ( A ) )

#define ERR_printf_invalid( A )\
	ERR_GEN ( 883, chk_J ( A ) )

#define ERR_printf_unterm( A )\
	ERR_GEN ( 884, chk_J ( A ) )

#define ERR_printf_flags( A, B )\
	ERR_GEN ( 885, chk_J ( A ), chk_J ( B ) )

#define ERR_printf_width( A )\
	ERR_GEN ( 886, chk_J ( A ) )

#define ERR_printf_precision( A )\
	ERR_GEN ( 887, chk_J ( A ) )

#define ERR_printf_arg_zero()\
	ERR_GEN ( 888 )

#define ERR_printf_arg_large( A )\
	ERR_GEN ( 889, chk_M ( A ) )

#define ERR_printf_arg_compat( A )\
	ERR_GEN ( 890, chk_M ( A ) )

#define ERR_printf_arg_none( A )\
	ERR_GEN ( 891, chk_M ( A ) )

#define ERR_printf_arg_mix()\
	ERR_GEN ( 892 )

#define ERR_limits_max( A, B, C )\
	ERR_GEN ( 893, chk_J ( A ), chk_L ( B ), chk_L ( C ) )

#define ERR_limits_min( A, B, C )\
	ERR_GEN ( 894, chk_J ( A ), chk_L ( B ), chk_L ( C ) )

#define ERR_pragma_scope_undef( A )\
	ERR_GEN ( 895, chk_6 ( A ) )

#define ERR_pragma_scope_redef( A )\
	ERR_GEN ( 896, chk_6 ( A ) )

#define ERR_pragma_scope_end()\
	ERR_GEN ( 897 )

#define ERR_pragma_scope_set( A )\
	ERR_GEN ( 898, chk_J ( A ) )

#define ERR_pragma_dblock_name( A )\
	ERR_GEN ( 899, chk_6 ( A ) )

#define ERR_pragma_dblock_end()\
	ERR_GEN ( 900 )

#define ERR_pragma_dir_undef( A )\
	ERR_GEN ( 901, chk_J ( A ) )

#define ERR_pragma_dir_mode( A )\
	ERR_GEN ( 902, chk_J ( A ) )

#define ERR_pragma_error_bad( A )\
	ERR_GEN ( 903, chk_F ( A ) )

#define ERR_pragma_option_bad( A )\
	ERR_GEN ( 904, chk_F ( A ) )

#define ERR_pragma_keyword_bad( A )\
	ERR_GEN ( 905, chk_6 ( A ) )

#define ERR_pragma_char_lit( A )\
	ERR_GEN ( 906, chk_G ( A ) )

#define ERR_pragma_builtin_type( A )\
	ERR_GEN ( 907, chk_G ( A ) )

#define ERR_pragma_promote_type( A )\
	ERR_GEN ( 908, chk_G ( A ) )

#define ERR_pragma_promote_compat( A )\
	ERR_GEN ( 909, chk_G ( A ) )

#define ERR_pragma_compat_type()\
	ERR_GEN ( 910 )

#define ERR_pragma_arg_dup( A )\
	ERR_GEN ( 911, chk_G ( A ) )

#define ERR_pragma_arg_cycle()\
	ERR_GEN ( 912 )

#define ERR_pragma_lit_type( A )\
	ERR_GEN ( 913, chk_G ( A ) )

#define ERR_pragma_lit_range( A, B )\
	ERR_GEN ( 914, chk_B ( A ), chk_G ( B ) )

#define ERR_pragma_lit_question()\
	ERR_GEN ( 915 )

#define ERR_pragma_token_sort( A )\
	ERR_GEN ( 916, chk_7 ( A ) )

#define ERR_pragma_preserve_undecl( A, B )\
	ERR_GEN ( 917, chk_8 ( A ), chk_7 ( B ) )

#define ERR_pragma_weak_redef( A )\
	ERR_GEN ( 918, chk_7 ( A ) )

#define ERR_pragma_cpp_known( A )\
	ERR_GEN ( 919, chk_8 ( A ) )

#define ERR_pragma_cpp_ident( A )\
	ERR_GEN ( 920, chk_8 ( A ) )

#define ERR_pragma_assert_id( A )\
	ERR_GEN ( 921, chk_8 ( A ) )

#define ERR_pragma_assert_open( A )\
	ERR_GEN ( 922, chk_8 ( A ) )

#define ERR_pragma_assert_paren( A )\
	ERR_GEN ( 923, chk_8 ( A ) )

#define ERR_pragma_assert_empty( A )\
	ERR_GEN ( 924, chk_8 ( A ) )

#define ERR_pragma_assert_pred( A )\
	ERR_GEN ( 925, chk_6 ( A ) )

#define ERR_port_entry_undef( A )\
	ERR_GEN ( 926, chk_J ( A ) )

#define ERR_port_entry_redef( A )\
	ERR_GEN ( 927, chk_J ( A ) )

#define ERR_token_info( A )\
	ERR_GEN ( 928, chk_7 ( A ) )

#define ERR_token_redecl( A, B )\
	ERR_GEN ( 929, chk_7 ( A ), chk_D ( B ) )

#define ERR_token_redef( A, B )\
	ERR_GEN ( 930, chk_7 ( A ), chk_D ( B ) )

#define ERR_token_redef_ok( A, B )\
	ERR_GEN ( 931, chk_7 ( A ), chk_D ( B ) )

#define ERR_token_undef( A )\
	ERR_GEN ( 932, chk_7 ( A ) )

#define ERR_token_undecl( A )\
	ERR_GEN ( 933, chk_7 ( A ) )

#define ERR_token_qual( A )\
	ERR_GEN ( 934, chk_7 ( A ) )

#define ERR_token_scope( A )\
	ERR_GEN ( 935, chk_7 ( A ) )

#define ERR_token_no_def( A, B )\
	ERR_GEN ( 936, chk_7 ( A ), chk_D ( B ) )

#define ERR_token_def_not( A )\
	ERR_GEN ( 937, chk_7 ( A ) )

#define ERR_token_def_args( A )\
	ERR_GEN ( 938, chk_7 ( A ) )

#define ERR_token_def_func( A, B )\
	ERR_GEN ( 939, chk_7 ( A ), chk_G ( B ) )

#define ERR_token_def_ambig( A )\
	ERR_GEN ( 940, chk_7 ( A ) )

#define ERR_token_def_except()\
	ERR_GEN ( 941 )

#define ERR_token_def_implicit( A )\
	ERR_GEN ( 942, chk_7 ( A ) )

#define ERR_token_proc_high()\
	ERR_GEN ( 943 )

#define ERR_token_func( A )\
	ERR_GEN ( 944, chk_G ( A ) )

#define ERR_token_mem( A )\
	ERR_GEN ( 945, chk_G ( A ) )

#define ERR_token_mem_off()\
	ERR_GEN ( 946 )

#define ERR_token_stmt_ret( A )\
	ERR_GEN ( 947, chk_7 ( A ) )

#define ERR_token_stmt_jump()\
	ERR_GEN ( 948 )

#define ERR_token_const( A )\
	ERR_GEN ( 949, chk_7 ( A ) )

#define ERR_token_arg_sort( A )\
	ERR_GEN ( 950, chk_7 ( A ) )

#define ERR_token_arg_bad( A )\
	ERR_GEN ( 951, chk_7 ( A ) )

#define ERR_token_arg_exp( A )\
	ERR_GEN ( 952, chk_7 ( A ) )

#define ERR_token_arg_const( A )\
	ERR_GEN ( 953, chk_7 ( A ) )

#define ERR_token_arg_lvalue( A )\
	ERR_GEN ( 954, chk_7 ( A ) )

#define ERR_token_arg_mem( A )\
	ERR_GEN ( 955, chk_7 ( A ) )

#define ERR_token_arg_nat( A )\
	ERR_GEN ( 956, chk_7 ( A ) )

#define ERR_token_arg_type( A, B, C )\
	ERR_GEN ( 957, chk_8 ( A ), chk_7 ( B ), chk_G ( C ) )

#define ERR_token_recursive( A )\
	ERR_GEN ( 958, chk_7 ( A ) )

#define ERR_token_arg_undef( A, B )\
	ERR_GEN ( 959, chk_7 ( A ), chk_7 ( B ) )

#define ERR_token_conv( A, B, C )\
	ERR_GEN ( 960, chk_7 ( A ), chk_G ( B ), chk_G ( C ) )


#endif
#endif
