/*
 * Implementation of a DEMReader to download and decode the SRTM2 dataset
 */
package mccombe.terrain;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.swing.JComponent;
import static mccombe.terrain.DEMReader.BUFFERLENGTH;

/**
 *
 * @author Mike McCombe
 */
public class SRTM2Reader extends DEMReader {

    public SRTM2Reader(JComponent item) throws MissingDataFileException {
        super(item);
    }

    public String datasetName() {
        return name;
    }

    public boolean downloadable() {
        return downloadable;
    }

    public int recordlength() {
        return recordlength;
    }

    public String formatstring() {
        return filenameformat;
    }

    public String extn() {
        return extn;
    }

    public boolean littleendian() {
        return littleendian;
    }

    public int missingValue() {
        return missingValue;
    }
    public String zipEntryName(String name){
        return name + ".hgt";
    }
    @Override
    public String[] copyright() {
        return copyright ;
    }
    @Override
    protected String getDownloadSiteName(){
        return sitename + getProperty(TerrainProperties.REGION);
    }
    protected static final String sitename = "https://dds.cr.usgs.gov/srtm/version2_1/SRTM3/";
    protected static final boolean downloadable = true;
    protected static final int recordlength = 1201;
    protected static final String filenameformat = "%1s%02d%1s%03d";
    protected static final String name = "Shuttle Radar Topography Mission";
    protected static final String extn = ".hgt.zip";
    protected static final boolean littleendian = false;
    protected static final int missingValue = -32768;
    protected String[] copyright = {"SRTM DEM data is public-domain."};
}
