
/******************************************************************************
* MODULE     : edit_main.gen.h
* DESCRIPTION: the main structure for the mathematical editor
* COPYRIGHT  : (C) 1999  Joris van der Hoeven
*******************************************************************************
* This software falls under the GNU general public license and comes WITHOUT
* ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for more details.
* If you don't have this file, write to the Free Software Foundation, Inc.,
* 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
******************************************************************************/

#include <Interface/edit_interface.gen.h>
#include <Interface/edit_cursor.gen.h>
#include <Editor/edit_typeset.gen.h>
#include <Modify/edit_modify.gen.h>
#include <Modify/edit_text.gen.h>
#include <Modify/edit_math.gen.h>
#include <Modify/edit_table.gen.h>
#include <Modify/edit_dynamic.gen.h>
#include <Process/edit_process.gen.h>
#include <Replace/edit_select.gen.h>
#include <Replace/edit_replace.gen.h>

#module edit_main
#import edit_interface
#import edit_cursor
#import edit_typeset
#import edit_modify
#import edit_text
#import edit_math
#import edit_table
#import edit_dynamic
#import edit_process
#import edit_select
#import edit_replace

class edit_main_rep:
  public edit_interface_rep,
  public edit_cursor_rep,
  public edit_typeset_rep,
  public edit_modify_rep,
  public edit_text_rep,
  public edit_math_rep,
  public edit_table_rep,
  public edit_dynamic_rep,
  public edit_process_rep,
  public edit_select_rep,
  public edit_replace_rep
{
public:
  edit_main_rep (server_rep* sv, display dis, tm_buffer buf);
  ~edit_main_rep ();
  
  void clear_buffer ();
  void new_window ();
  void clone_window ();
  void tex_buffer ();
  string get_name ();
  void focus_on_this_editor ();

  void set_page_parameters ();
  void set_page_medium (string medium);
  void set_page_type (string type);
  void set_page_orientation (string orientation);

  void print (string ps_name, bool to_file, int first, int last);
  void print_to_file (string ps_name, string first="1", string last="1000000");
  void print_buffer (string first="1", string last="1000000");
  void export_ps (string ps_name, string first="1", string last="1000000");

  void eval (string s);
  void eval (scheme_tree p);
  bool exec (string s);
  bool exec (scheme_tree p);
  tree the_line ();
  tree the_buffer ();
  tree shell_eval (tree t);
  tree scheme_eval (tree t);
  tree edit_lisp_compile (tree t);
  tree edit_lisp_eval (tree t);
  tree prog_eval (tree t);
  void process_input ();

  void show_tree ();
  void show_env ();
  void show_path ();
  void show_cursor ();
  void show_selection ();
  void show_meminfo ();
  void edit_special ();
  void edit_test ();

  friend class editor;
};

#endmodule // edit_main
