# Copyright (c) 2001, 2002 by Intevation GmbH
# Authors:
# Bernhard Herzog <bh@intevation.de>
#
# This program is free software under the GPL (>=v2)
# Read the file COPYING coming with Thuban for details.

__version__ = "$Revision: 1.2 $"

from messages import CHANGED

from base import TitledObject, Modifiable

ALIGN_CENTER = "center"
ALIGN_TOP = "top"
ALIGN_BOTTOM = "bottom"
ALIGN_LEFT = "left"
ALIGN_RIGHT = "right"
ALIGN_BASELINE = "baseline"

class Label:

    def __init__(self, x, y, text, halign, valign):
        self.x = x
        self.y = y
        self.text = text
        self.halign = halign
        self.valign = valign


class LabelLayer(TitledObject, Modifiable):

    def __init__(self, title):
        TitledObject.__init__(self, title)
        Modifiable.__init__(self)
        self.labels = []

    def Labels(self):
        return self.labels

    def AddLabel(self, x, y, text, halign = "left", valign="center"):
        self.labels.append(Label(x, y, text, halign, valign))
        self.changed(CHANGED)

    def RemoveLabel(self, index):
        del self.labels[index]
        self.changed(CHANGED)

    def ClearLabels(self):
        """Remove all labels"""
        del self.labels[:]
        self.changed(CHANGED)
