package tijmp.actions;

import javax.swing.AbstractAction;
import tijmp.ui.FilterConfig;

/** An action that acts on a given filter config. 
 */
public abstract class FilterAction extends AbstractAction {
    private FilterConfig fc;
    
    public FilterAction (String title, FilterConfig fc) {
	super (title);
	if (fc == null)
	    throw new IllegalArgumentException ("fc may not be null");
	this.fc = fc;
    }

    public FilterConfig getFilterConfig () {
	return fc;
    }
}
