package tijmp.actions;

import java.awt.event.ActionEvent;
import tijmp.filter.PackageFilter;
import tijmp.ui.FilterConfig;

/** A class that sets the current filter to show one package
 *  and its sub packages.
 */
public class StrictPackage extends FilterAction {
    private String pname;

    public StrictPackage (FilterConfig fc, String pname) {
	super ("Show " + pname + " only", fc);
	this.pname = pname;
    }

    public void actionPerformed (ActionEvent e) {
	PackageFilter pf = new PackageFilter (pname);
	getFilterConfig ().setFilter (pf);
    }
}
