package tijmp.filter;

/** A filter that matches some common array classes. 
 *  Usually only useful for default removal of classes.
 */
public class CommonArrayFilter implements Filter {
    private static final String[] prefixes = 
    {"Ljava.", "Lsun.", "Ljavax.", "Ltijmp."};

    public boolean accept (Class<?> c) {
	String name = c.getName ();
	int i = 0;
	while (name.length () > 0 && name.charAt (i) == '[')
	    i++;
	name = name.substring (i);
	for (String p : prefixes)
	    if (name.startsWith (p))
		return true;
	return false;
    }
}
