package tijmp.ui;

import javax.swing.SwingConstants;
import javax.swing.table.DefaultTableCellRenderer;

/** A renderer that turns memory sizes into readable strings.
 */
public class ReadableSizeRenderer extends DefaultTableCellRenderer {
    private static final String[] sizes = {"B", "kB", "MB", "GB", "TB", "PB" };
    
    public ReadableSizeRenderer () {
	setHorizontalAlignment (SwingConstants.RIGHT);
    }

    @Override public void setValue (Object value) {
        setText (getNiceNumber (((Long)value).longValue ()));
    }

    private String getNiceNumber (long l) {
	double d = l;
	int p = 0;
	boolean negative = false;
	if (d < 0) {
	    d = -d;
	    negative = true;
	}
	while (d > 1024) {
	    p++;
	    d /= 1024;
	}
	if (p > 0)
	    return String.format ("%s%.2f %s", 
				  (negative ? "-" : ""), d, sizes[p]);
	return String.format ("%d %s", l, sizes[p]);
    }
}
