package tijmp.ui;

/** A class that can turn a class name into human readable format.
 */
public class Translator {
    public static String translate (Class<?> c, Object obj) {
	if (c.isPrimitive ()) {
	    if (c == Boolean.TYPE)
		return "boolean";
	    if (c == Character.TYPE)
		return "char";
	    if (c == Byte.TYPE)
		return "byte";
	    if (c == Short.TYPE)
		return "short";
	    if (c == Integer.TYPE)
		return "int";
	    if (c == Long.TYPE)
		return "long";
	    if (c == Float.TYPE)
		return "float";
	    if (c == Double.TYPE)
		return "double";
	    if (c == Void.TYPE)
		return "void";
	}
	if (c.isArray ()) {
	    if (obj instanceof boolean[]) {
		boolean[] b = (boolean[])obj; 
		return "boolean[" + b.length + "]";
	    }
	    if (obj instanceof char[]) {
		char[] b = (char[])obj; 
		return "char[" + b.length + "]";
	    }
	    if (obj instanceof byte[]) {
		byte[] b = (byte[])obj; 
		return "byte[" + b.length + "]";
	    }
	    if (obj instanceof short[]) {
		short[] b = (short[])obj;
		return "short[" + b.length + "]";
	    }
	    if (obj instanceof int[]) {
		int[] b = (int[])obj;
		return "int[" + b.length + "]";
	    }
	    if (obj instanceof long[]) {
		long[] b = (long[])obj;
		return "long[" + b.length + "]";
	    }
	    if (obj instanceof float[]) {
		float[] b = (float[])obj;
		return "float[" + b.length + "]";
	    }
	    if (obj instanceof double[]) {
		double[] b = (double[])obj;
		return "double[" + b.length + "]";
	    }
	    if (obj instanceof Object[]) {
		Object[] b = (Object[])obj;
		Class<?> comp = c.getComponentType ();
		Object o = b.length > 0 ? b[0] : null;
		// TODO: probably wrong order for nested arrays: 
		// TODO: Object[10][3][4711]
		String t = translate (comp, o);
		return t + "[" + b.length + "]"; 
	    }
	    Class<?> comp = c.getComponentType ();
	    return translate (comp, null) + "[]";
	}
	return c.getName ();
    }
}
