/*  tilp - a linking program for TI graphing calculators
 *  Copyright (C) 1999-2002  Romain Lievin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include "str.h"
#include <gtk/gtk.h>

#include "struct.h"
#include "info.h"
#include "gstruct.h"
#include "ginfo.h"

char *format(char *s, int max)
{
  gchar buf[MAXCHARS];
  gchar *i=NULL;
  gchar *j=s+strlen(s);

  i = (gchar*)strchr(s, DIR_SEPARATOR_C); // first slash
  j = (gchar *)strrchr(s, DIR_SEPARATOR_C); // last slash
  strcpy(buf, j);
  if(i == j) return s;
  i = (gchar *)strchr(i+1, DIR_SEPARATOR_C); // second slash

  *i = '\0';
  strcat(s, DIR_SEPARATOR_S);
  strcat(s, "...");
  strcat(s, buf);
  return s;
}

/* Refresh the info window */
void refresh_info()
{
  gchar buffer[MAXCHARS];
  gint d=0, v=0;
  longword m=0;

  switch(options.lp.calc_type)
    {
    case CALC_TI89:
    case CALC_TI92:
    case CALC_TI92P:
      if(ctree_win.varlist != NULL)
	{
	  snprintf(buffer, MAXCHARS, _("Memory used: %i bytes"), 
		   ctree_win.memory);
	}
      else
	{
	  snprintf(buffer, MAXCHARS, _("Memory used: %s"), _("N/A")); 
	}
      gtk_label_set(GTK_LABEL (clabel_win.label21), buffer);
      break;
    case CALC_TI83:
    case CALC_TI83P:
    case CALC_TI86:
      if(ctree_win.varlist != NULL)
	{
	  snprintf(buffer, MAXCHARS, _("Memory free: %i bytes"), 
		   ctree_win.memory);
	}
      else
	{
	  snprintf(buffer, MAXCHARS, _("Memory free: %s"), _("N/A")); 
	}
      gtk_label_set(GTK_LABEL (clabel_win.label21), buffer);
      break;
    default:
      break;
    }

  number_of_directories_vars_and_mem(&d, &v, &m);
  snprintf(buffer, MAXCHARS, _("Current directory: %s"), clist_win.cur_dir);
  gtk_label_set(GTK_LABEL (clabel_win.label22), format(buffer, 45));
}




