#include "PreviewPane.hpp"

#include "wx/wx.h"
#include "wx/sizer.h"

using namespace indii::tint;
using namespace indii::tint::gui;

PreviewPane::PreviewPane(wxWindow* parent, ImageResource* res, 
    ClusterModel* model) : wxPanel(parent, wxID_ANY, wxDefaultPosition,
	wxDefaultSize, wxTAB_TRAVERSAL|wxNO_FULL_REPAINT_ON_RESIZE|wxCLIP_CHILDREN) {
  SetBackgroundColour(wxColour(69,69,69));
  
  preview = new PreviewImage(this, res, model);

  wxBoxSizer* sizer = new wxBoxSizer(wxVERTICAL);
  sizer->Add(preview, 1, wxALIGN_CENTER|wxEXPAND);
  SetSizer(sizer);
}
