/***************************************************************************
                          klang.cpp  -  description                              
                             -------------------                                         
    begin                : Sat Jun 10 18:57:47 MEST 2000 
                                           
    copyright            : (C) 1999 by Daniel Reith                         
    email                : DanR@gmx.de
	
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "klang.h"

enum
{
  mOK = 23
};

BEGIN_EVENT_TABLE(klang, wxDialog)
  EVT_BUTTON(mOK, klang::OnOK)
END_EVENT_TABLE()

  //********************************************
  //* Konstruktor
  //********************************************

klang::klang(wxWindow *parent, vector<LEntry> results)
  :wxDialog(parent, -1, _("Langzeitstatistik"), wxDefaultPosition, wxSize(500, 300), wxDEFAULT_DIALOG_STYLE, _("Langzeitstatistik"))
{
  m_text = new wxStaticText(this, -1, _("Langzeitstatistik"), wxPoint(5,5), wxSize(495, 50), wxALIGN_CENTRE);
  m_text->SetFont(wxFont(24, wxDEFAULT, wxNORMAL, wxBOLD));
  m_grid = new wxGrid(this, -1, wxPoint(5, 50), wxSize(495, 200));
  m_grid->CreateGrid(5, 1);
  m_grid->SetColumnWidth(0, 250);
  for(int i=0; i<=4; ++i)
    {
      m_grid->SetRowHeight(i, 26);
      m_grid->SetCellAlignment(wxRIGHT, i, 0);
    }
  m_grid->SetEditable(FALSE);
  m_grid->SetLabelSize(wxVERTICAL, 200);
  m_grid->SetLabelValue(wxVERTICAL, _("Anschlge (ges)"), 0);
  m_grid->SetLabelValue(wxVERTICAL, _("falsche Anschlge"), 1);
  m_grid->SetLabelValue(wxVERTICAL, _("falsche Anschlge o/oo"), 2);
  m_grid->SetLabelValue(wxVERTICAL, _("Zeit"), 3);
  m_grid->SetLabelValue(wxVERTICAL, _("Anschlge / Minute"), 4);
  m_OK = new wxButton(this, mOK, _("Fertig"), wxPoint(175, 260), wxSize(150, 30));
  Center();
  int anschlaege=0;
  int fanschlaege=0;
  int promille=0;
  int zeit=0;
  int apm=0;
  int i;
  for(i=0; i < results.size(); ++i)
    {
      anschlaege += results[i].GetAnschlaege();
      fanschlaege += results[i].GetFehler();
      promille += results[i].GetPromille();
      apm += results[i].GetApM();
      zeit += results[i].GetZeit();
    }
  wxString s="";
  s << anschlaege;
  m_grid->SetCellValue(s, 0, 0);
  s = "";
  s << fanschlaege;
  m_grid->SetCellValue(s, 1, 0);
  s = "";
  s << (fanschlaege*1000/anschlaege);
  m_grid->SetCellValue(s, 2, 0);
  s = "";
  char c[10];
  struct tm *m_tm;
  time_t t = zeit;
   m_tm = localtime(&t);
   m_tm->tm_hour = m_tm->tm_hour - 1;
   strftime(c, 10, "%X", m_tm);
   s  << c;
   m_grid->SetCellValue(s, 3, 0);
   s= "";
   double a = anschlaege;
   double z = zeit;
   double d = a/z;
   s << (d*60);
   m_grid->SetCellValue(s, 4, 0);
}

void klang::OnOK(wxCommandEvent *event)
{
  EndModal(wxOK);
}
